/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.migration;

import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.registry.client.migration.MigrationInvoker;
import org.apache.dubbo.rpc.cluster.support.migration.MigrationRule;
import org.apache.dubbo.rpc.cluster.support.migration.MigrationStep;

public class MigrationRuleHandler<T> {
    private static final Logger logger = LoggerFactory.getLogger(MigrationRuleHandler.class);
    private MigrationInvoker<T> migrationInvoker;
    private MigrationStep currentStep;

    public MigrationRuleHandler(MigrationInvoker<T> invoker) {
        this.migrationInvoker = invoker;
    }

    public void doMigrate(String rawRule) {
        MigrationRule rule = MigrationRule.parse((String)rawRule);
        if (null != this.currentStep && this.currentStep.equals((Object)rule.getStep())) {
            if (logger.isInfoEnabled()) {
                logger.info("Migration step is not change. rule.getStep is " + this.currentStep.name());
            }
            return;
        }
        this.currentStep = rule.getStep();
        this.migrationInvoker.setMigrationRule(rule);
        if (this.migrationInvoker.isMigrationMultiRegistry()) {
            if (this.migrationInvoker.isServiceInvoker()) {
                this.migrationInvoker.refreshServiceDiscoveryInvoker();
            } else {
                this.migrationInvoker.refreshInterfaceInvoker();
            }
        } else {
            switch (rule.getStep()) {
                case APPLICATION_FIRST: {
                    this.migrationInvoker.migrateToServiceDiscoveryInvoker(false);
                    break;
                }
                case FORCE_APPLICATION: {
                    this.migrationInvoker.migrateToServiceDiscoveryInvoker(true);
                    break;
                }
                default: {
                    this.migrationInvoker.fallbackToInterfaceInvoker();
                }
            }
        }
    }
}

