/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata.proxy;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.metadata.ServiceInstanceMetadataUtils;
import org.apache.dubbo.registry.client.metadata.proxy.MetadataServiceProxyFactory;

abstract class BaseMetadataServiceProxyFactory
implements MetadataServiceProxyFactory {
    private final ConcurrentMap<String, MetadataService> proxiesCache = new ConcurrentHashMap<String, MetadataService>();

    BaseMetadataServiceProxyFactory() {
    }

    @Override
    public final MetadataService getProxy(ServiceInstance serviceInstance) {
        return this.proxiesCache.computeIfAbsent(this.createProxyCacheKey(serviceInstance), id -> this.createProxy(serviceInstance));
    }

    protected String createProxyCacheKey(ServiceInstance serviceInstance) {
        return serviceInstance.getServiceName() + "#" + ServiceInstanceMetadataUtils.getExportedServicesRevision(serviceInstance);
    }

    protected abstract MetadataService createProxy(ServiceInstance var1);
}

