/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.event;

import java.util.Collections;
import java.util.List;
import org.apache.dubbo.registry.client.ServiceInstance;

public class ServiceInstancesChangedEvent {
    private final String serviceName;
    private final List<ServiceInstance> serviceInstances;

    public ServiceInstancesChangedEvent(String serviceName, List<ServiceInstance> serviceInstances) {
        this.serviceName = serviceName;
        this.serviceInstances = Collections.unmodifiableList(serviceInstances);
    }

    protected ServiceInstancesChangedEvent() {
        this.serviceInstances = Collections.emptyList();
        this.serviceName = "";
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public List<ServiceInstance> getServiceInstances() {
        return this.serviceInstances;
    }
}

