/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.ProtocolServiceKey;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.metadata.ServiceInstanceNotificationCustomizer;

public class SpringCloudServiceInstanceNotificationCustomizer
implements ServiceInstanceNotificationCustomizer {
    @Override
    public void customize(List<ServiceInstance> serviceInstance) {
        for (final ServiceInstance instance : serviceInstance) {
            if (!"SPRING_CLOUD".equals(instance.getMetadata("preserved.register.source"))) continue;
            MetadataInfo.ServiceInfo serviceInfo = new MetadataInfo.ServiceInfo("*", "*", "*", "rest", instance.getPort(), "*", new HashMap());
            MetadataInfo metadataInfo = new MetadataInfo(instance.getServiceName(), "SPRING_CLOUD", new ConcurrentHashMap<String, MetadataInfo.ServiceInfo>(Collections.singletonMap("*", serviceInfo))){

                public List<MetadataInfo.ServiceInfo> getMatchedServiceInfos(ProtocolServiceKey consumerProtocolServiceKey) {
                    this.getServices().putIfAbsent(consumerProtocolServiceKey.getServiceKeyString(), new MetadataInfo.ServiceInfo(consumerProtocolServiceKey.getInterfaceName(), consumerProtocolServiceKey.getGroup(), consumerProtocolServiceKey.getVersion(), consumerProtocolServiceKey.getProtocol(), instance.getPort(), consumerProtocolServiceKey.getInterfaceName(), new HashMap()));
                    return super.getMatchedServiceInfos(consumerProtocolServiceKey);
                }
            };
            instance.setServiceMetadata(metadataInfo);
        }
    }
}

