/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.migration;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.registry.client.migration.MigrationAddressComparator;
import org.apache.dubbo.registry.client.migration.model.MigrationRule;
import org.apache.dubbo.rpc.cluster.ClusterInvoker;
import org.apache.dubbo.rpc.model.ScopeModel;

public class DefaultMigrationAddressComparator
implements MigrationAddressComparator {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(DefaultMigrationAddressComparator.class);
    private static final String MIGRATION_THRESHOLD = "dubbo.application.migration.threshold";
    private static final String DEFAULT_THRESHOLD_STRING = "0.0";
    private static final float DEFAULT_THREAD = 0.0f;
    public static final String OLD_ADDRESS_SIZE = "OLD_ADDRESS_SIZE";
    public static final String NEW_ADDRESS_SIZE = "NEW_ADDRESS_SIZE";
    private Map<String, Map<String, Integer>> serviceMigrationData = new ConcurrentHashMap<String, Map<String, Integer>>();

    @Override
    public <T> boolean shouldMigrate(ClusterInvoker<T> newInvoker, ClusterInvoker<T> oldInvoker, MigrationRule rule) {
        float threshold;
        Float configuredThreshold;
        Map migrationData = this.serviceMigrationData.computeIfAbsent(oldInvoker.getUrl().getDisplayServiceKey(), _k -> new ConcurrentHashMap());
        if (!newInvoker.hasProxyInvokers()) {
            migrationData.put(OLD_ADDRESS_SIZE, this.getAddressSize(oldInvoker));
            migrationData.put(NEW_ADDRESS_SIZE, -1);
            logger.info("No " + this.getInvokerType(newInvoker) + " address available, stop compare.");
            return false;
        }
        if (!oldInvoker.hasProxyInvokers()) {
            migrationData.put(OLD_ADDRESS_SIZE, -1);
            migrationData.put(NEW_ADDRESS_SIZE, this.getAddressSize(newInvoker));
            logger.info("No " + this.getInvokerType(oldInvoker) + " address available, stop compare.");
            return true;
        }
        int newAddressSize = this.getAddressSize(newInvoker);
        int oldAddressSize = this.getAddressSize(oldInvoker);
        migrationData.put(OLD_ADDRESS_SIZE, oldAddressSize);
        migrationData.put(NEW_ADDRESS_SIZE, newAddressSize);
        String rawThreshold = null;
        Float f = configuredThreshold = rule == null ? null : Float.valueOf(rule.getThreshold(oldInvoker.getUrl()));
        if (configuredThreshold != null && configuredThreshold.floatValue() >= 0.0f) {
            rawThreshold = String.valueOf(configuredThreshold);
        }
        rawThreshold = StringUtils.isNotEmpty(rawThreshold) ? rawThreshold : ConfigurationUtils.getCachedDynamicProperty((ScopeModel)newInvoker.getUrl().getScopeModel(), (String)MIGRATION_THRESHOLD, (String)DEFAULT_THRESHOLD_STRING);
        try {
            threshold = Float.parseFloat(rawThreshold);
        }
        catch (Exception e) {
            logger.error("Invalid migration threshold " + rawThreshold);
            threshold = 0.0f;
        }
        logger.info("serviceKey:" + oldInvoker.getUrl().getServiceKey() + " Instance address size " + newAddressSize + ", interface address size " + oldAddressSize + ", threshold " + threshold);
        if (newAddressSize != 0 && oldAddressSize == 0) {
            return true;
        }
        if (newAddressSize == 0 && oldAddressSize == 0) {
            return false;
        }
        return (float)newAddressSize / (float)oldAddressSize >= threshold;
    }

    private <T> int getAddressSize(ClusterInvoker<T> invoker) {
        if (invoker == null) {
            return -1;
        }
        List invokers = invoker.getDirectory().getAllInvokers();
        return CollectionUtils.isNotEmpty((Collection)invokers) ? invokers.size() : 0;
    }

    @Override
    public Map<String, Integer> getAddressSize(String displayServiceKey) {
        return this.serviceMigrationData.get(displayServiceKey);
    }

    private String getInvokerType(ClusterInvoker<?> invoker) {
        if (invoker.isServiceDiscovery()) {
            return "instance";
        }
        return "interface";
    }
}

