/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.common.infra.InfraAdapter;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.ServiceInstanceCustomizer;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ServiceInstanceMetadataCustomizer
implements ServiceInstanceCustomizer {
    @Override
    public void customize(ServiceInstance serviceInstance, ApplicationModel applicationModel) {
        MetadataInfo metadataInfo = serviceInstance.getServiceMetadata();
        if (metadataInfo == null || CollectionUtils.isEmptyMap((Map)metadataInfo.getServices())) {
            return;
        }
        Map extraParameters = Collections.emptyMap();
        Set adapters = applicationModel.getExtensionLoader(InfraAdapter.class).getSupportedExtensionInstances();
        if (CollectionUtils.isNotEmpty((Collection)adapters)) {
            HashMap<String, String> inputParameters = new HashMap<String, String>();
            inputParameters.put("application", applicationModel.getApplicationName());
            for (InfraAdapter adapter : adapters) {
                extraParameters = adapter.getExtraAttributes(inputParameters);
            }
        }
        serviceInstance.getMetadata().putAll(extraParameters);
        if (CollectionUtils.isNotEmptyMap((Map)metadataInfo.getInstanceParams())) {
            serviceInstance.getMetadata().putAll(metadataInfo.getInstanceParams());
        }
    }
}

