/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.nacos;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ListView;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.function.ThrowableConsumer;
import org.apache.dubbo.common.function.ThrowableFunction;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.registry.client.AbstractServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.event.listener.ServiceInstancesChangedListener;
import org.apache.dubbo.registry.nacos.util.NacosNamingServiceUtils;

public class NacosServiceDiscovery
extends AbstractServiceDiscovery {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private String group;
    private NamingService namingService;
    private URL registryURL;

    public void initialize(URL registryURL) throws Exception {
        this.namingService = NacosNamingServiceUtils.createNamingService(registryURL);
        this.group = NacosNamingServiceUtils.getGroup(registryURL);
        this.registryURL = registryURL;
    }

    public void destroy() {
        this.namingService = null;
    }

    public void register(ServiceInstance serviceInstance) throws RuntimeException {
        super.register(serviceInstance);
        ThrowableConsumer.execute((Object)this.namingService, service -> {
            Instance instance = NacosNamingServiceUtils.toInstance(serviceInstance);
            service.registerInstance(instance.getServiceName(), this.group, instance);
        });
    }

    public void update(ServiceInstance serviceInstance) throws RuntimeException {
        super.update(serviceInstance);
        this.unregister(serviceInstance);
        this.register(serviceInstance);
    }

    public void unregister(ServiceInstance serviceInstance) throws RuntimeException {
        ThrowableConsumer.execute((Object)this.namingService, service -> {
            Instance instance = NacosNamingServiceUtils.toInstance(serviceInstance);
            service.deregisterInstance(instance.getServiceName(), this.group, instance);
        });
    }

    public Set<String> getServices() {
        return (Set)ThrowableFunction.execute((Object)this.namingService, service -> {
            ListView view = service.getServicesOfServer(0, Integer.MAX_VALUE, this.group);
            return new LinkedHashSet(view.getData());
        });
    }

    public List<ServiceInstance> getInstances(String serviceName) throws NullPointerException {
        return (List)ThrowableFunction.execute((Object)this.namingService, service -> service.selectInstances(serviceName, true).stream().map(NacosNamingServiceUtils::toServiceInstance).collect(Collectors.toList()));
    }

    public void addServiceInstancesChangedListener(ServiceInstancesChangedListener listener) throws NullPointerException, IllegalArgumentException {
        ThrowableConsumer.execute((Object)this.namingService, service -> listener.getServiceNames().forEach(serviceName -> {
            try {
                service.subscribe(serviceName, e -> {
                    if (e instanceof NamingEvent) {
                        NamingEvent event = (NamingEvent)e;
                        this.handleEvent(event, listener);
                    }
                });
            }
            catch (NacosException e2) {
                e2.printStackTrace();
            }
        }));
    }

    public URL getUrl() {
        return this.registryURL;
    }

    public ServiceInstance getLocalInstance() {
        return null;
    }

    private void handleEvent(NamingEvent event, ServiceInstancesChangedListener listener) {
        String serviceName = event.getServiceName();
        List serviceInstances = event.getInstances().stream().map(NacosNamingServiceUtils::toServiceInstance).collect(Collectors.toList());
        this.dispatchServiceInstancesChangedEvent(serviceName, serviceInstances);
    }
}

