/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.nacos;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ListView;
import java.util.List;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.registry.nacos.function.NacosConsumer;
import org.apache.dubbo.registry.nacos.function.NacosFunction;

public class NacosNamingServiceWrapper {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(NacosNamingServiceWrapper.class);
    private static final String INNERCLASS_SYMBOL = "$";
    private static final String INNERCLASS_COMPATIBLE_SYMBOL = "___";
    private final NamingService namingService;
    private final int retryTimes;
    private final int sleepMsBetweenRetries;

    public NacosNamingServiceWrapper(NamingService namingService, int retryTimes, int sleepMsBetweenRetries) {
        this.namingService = namingService;
        this.retryTimes = Math.max(retryTimes, 0);
        this.sleepMsBetweenRetries = sleepMsBetweenRetries;
    }

    public String getServerStatus() {
        return this.namingService.getServerStatus();
    }

    public void subscribe(String serviceName, String group, EventListener eventListener) throws NacosException {
        this.accept(naming -> naming.subscribe(this.handleInnerSymbol(serviceName), group, eventListener));
    }

    public void unsubscribe(String serviceName, String group, EventListener eventListener) throws NacosException {
        this.accept(naming -> naming.unsubscribe(this.handleInnerSymbol(serviceName), group, eventListener));
    }

    public List<Instance> getAllInstances(String serviceName, String group) throws NacosException {
        return this.apply(naming -> naming.getAllInstances(this.handleInnerSymbol(serviceName), group));
    }

    public void registerInstance(String serviceName, String group, Instance instance) throws NacosException {
        this.accept(naming -> naming.registerInstance(this.handleInnerSymbol(serviceName), group, instance));
    }

    public void deregisterInstance(String serviceName, String group, String ip, int port) throws NacosException {
        this.accept(naming -> naming.deregisterInstance(this.handleInnerSymbol(serviceName), group, ip, port));
    }

    public void deregisterInstance(String serviceName, String group, Instance instance) throws NacosException {
        this.accept(naming -> naming.deregisterInstance(this.handleInnerSymbol(serviceName), group, instance));
    }

    public ListView<String> getServicesOfServer(int pageNo, int pageSize, String group) throws NacosException {
        return this.apply(naming -> naming.getServicesOfServer(pageNo, pageSize, group));
    }

    public List<Instance> selectInstances(String serviceName, String group, boolean healthy) throws NacosException {
        return this.apply(naming -> naming.selectInstances(this.handleInnerSymbol(serviceName), group, healthy));
    }

    public void shutdown() throws NacosException {
        this.namingService.shutDown();
    }

    private String handleInnerSymbol(String serviceName) {
        if (StringUtils.isEmpty((String)serviceName)) {
            return null;
        }
        return serviceName.replace(INNERCLASS_SYMBOL, INNERCLASS_COMPATIBLE_SYMBOL);
    }

    private <R> R apply(NacosFunction<NamingService, R> command) throws NacosException {
        int times;
        NacosException le = null;
        R result = null;
        for (times = 0; times < this.retryTimes + 1; ++times) {
            try {
                result = command.apply(this.namingService);
                le = null;
                break;
            }
            catch (NacosException e) {
                le = e;
                logger.warn("1-37", "", "", "Failed to request nacos naming server. " + (times < this.retryTimes ? "Dubbo will try to retry in " + this.sleepMsBetweenRetries + ". " : "Exceed retry max times.") + "Try times: " + (times + 1), (Throwable)e);
                if (times >= this.retryTimes) continue;
                try {
                    Thread.sleep(this.sleepMsBetweenRetries);
                }
                catch (InterruptedException ex) {
                    logger.warn("99-1", "", "", "Interrupted when waiting to retry.", (Throwable)ex);
                    Thread.currentThread().interrupt();
                }
                continue;
            }
        }
        if (le != null) {
            throw le;
        }
        if (times > 1) {
            logger.info("Failed to request nacos naming server for " + (times - 1) + " times and finally success. This may caused by high stress of nacos server.");
        }
        return result;
    }

    private void accept(NacosConsumer<NamingService> command) throws NacosException {
        int times;
        NacosException le = null;
        for (times = 0; times < this.retryTimes + 1; ++times) {
            try {
                command.accept(this.namingService);
                le = null;
                break;
            }
            catch (NacosException e) {
                le = e;
                logger.warn("1-37", "", "", "Failed to request nacos naming server. " + (times < this.retryTimes ? "Dubbo will try to retry in " + this.sleepMsBetweenRetries + ". " : "Exceed retry max times.") + "Try times: " + (times + 1), (Throwable)e);
                if (times >= this.retryTimes) continue;
                try {
                    Thread.sleep(this.sleepMsBetweenRetries);
                }
                catch (InterruptedException ex) {
                    logger.warn("99-1", "", "", "Interrupted when waiting to retry.", (Throwable)ex);
                    Thread.currentThread().interrupt();
                }
                continue;
            }
        }
        if (le != null) {
            throw le;
        }
        if (times > 1) {
            logger.info("Failed to request nacos naming server for " + (times - 1) + " times and finally success. This may caused by high stress of nacos server.");
        }
    }
}

