/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.exchange.support;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.ThreadlessExecutor;
import org.apache.dubbo.common.timer.HashedWheelTimer;
import org.apache.dubbo.common.timer.Timeout;
import org.apache.dubbo.common.timer.Timer;
import org.apache.dubbo.common.timer.TimerTask;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.TimeoutException;
import org.apache.dubbo.remoting.exchange.Request;
import org.apache.dubbo.remoting.exchange.Response;

public class DefaultFuture
extends CompletableFuture<Object> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultFuture.class);
    private static final Map<Long, Channel> CHANNELS = new ConcurrentHashMap<Long, Channel>();
    private static final Map<Long, DefaultFuture> FUTURES = new ConcurrentHashMap<Long, DefaultFuture>();
    public static final Timer TIME_OUT_TIMER = new HashedWheelTimer((ThreadFactory)new NamedThreadFactory("dubbo-future-timeout", true), 30L, TimeUnit.MILLISECONDS);
    private final Long id;
    private final Channel channel;
    private final Request request;
    private final int timeout;
    private final long start = System.currentTimeMillis();
    private volatile long sent;
    private Timeout timeoutCheckTask;
    private ExecutorService executor;

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    private DefaultFuture(Channel channel, Request request, int timeout) {
        this.channel = channel;
        this.request = request;
        this.id = request.getId();
        this.timeout = timeout > 0 ? timeout : channel.getUrl().getPositiveParameter("timeout", 1000);
        FUTURES.put(this.id, this);
        CHANNELS.put(this.id, channel);
    }

    private static void timeoutCheck(DefaultFuture future) {
        TimeoutCheckTask task = new TimeoutCheckTask(future.getId());
        future.timeoutCheckTask = TIME_OUT_TIMER.newTimeout((TimerTask)task, (long)future.getTimeout(), TimeUnit.MILLISECONDS);
    }

    public static DefaultFuture newFuture(Channel channel, Request request, int timeout, ExecutorService executor) {
        DefaultFuture future = new DefaultFuture(channel, request, timeout);
        future.setExecutor(executor);
        if (executor instanceof ThreadlessExecutor) {
            ((ThreadlessExecutor)executor).setWaitingFuture((CompletableFuture)future);
        }
        DefaultFuture.timeoutCheck(future);
        return future;
    }

    public static DefaultFuture getFuture(long id) {
        return FUTURES.get(id);
    }

    public static boolean hasFuture(Channel channel) {
        return CHANNELS.containsValue(channel);
    }

    public static void sent(Channel channel, Request request) {
        DefaultFuture future = FUTURES.get(request.getId());
        if (future != null) {
            future.doSent();
        }
    }

    public static void closeChannel(Channel channel) {
        for (Map.Entry<Long, Channel> entry : CHANNELS.entrySet()) {
            DefaultFuture future;
            if (!channel.equals(entry.getValue()) || (future = DefaultFuture.getFuture(entry.getKey())) == null || future.isDone()) continue;
            Response disconnectResponse = new Response(future.getId());
            disconnectResponse.setStatus((byte)35);
            disconnectResponse.setErrorMessage("Channel " + channel + " is inactive. Directly return the unFinished request : " + future.getRequest());
            DefaultFuture.received(channel, disconnectResponse);
        }
    }

    public static void received(Channel channel, Response response) {
        DefaultFuture.received(channel, response, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void received(Channel channel, Response response, boolean timeout) {
        try {
            DefaultFuture future = FUTURES.remove(response.getId());
            if (future != null) {
                Timeout t = future.timeoutCheckTask;
                if (!timeout) {
                    t.cancel();
                }
                future.doReceived(response);
            } else {
                logger.warn("The timeout response finally returned at " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()) + ", response status is " + response.getStatus() + (channel == null ? "" : ", channel: " + channel.getLocalAddress() + " -> " + channel.getRemoteAddress()) + ", please check provider side for detailed result.");
            }
        }
        finally {
            CHANNELS.remove(response.getId());
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Response errorResult = new Response(this.id);
        errorResult.setStatus((byte)90);
        errorResult.setErrorMessage("request future has been canceled.");
        this.doReceived(errorResult);
        FUTURES.remove(this.id);
        CHANNELS.remove(this.id);
        return true;
    }

    public void cancel() {
        this.cancel(true);
    }

    private void doReceived(Response res) {
        ThreadlessExecutor threadlessExecutor;
        if (res == null) {
            throw new IllegalStateException("response cannot be null");
        }
        if (res.getStatus() == 20) {
            this.complete(res.getResult());
        } else if (res.getStatus() == 30 || res.getStatus() == 31) {
            this.completeExceptionally(new TimeoutException(res.getStatus() == 31, this.channel, res.getErrorMessage()));
        } else {
            this.completeExceptionally(new RemotingException(this.channel, res.getErrorMessage()));
        }
        if (this.executor != null && this.executor instanceof ThreadlessExecutor && (threadlessExecutor = (ThreadlessExecutor)this.executor).isWaiting()) {
            threadlessExecutor.notifyReturn((Throwable)new IllegalStateException("The result has returned, but the biz thread is still waiting which is not an expected state, interrupt the thread manually by returning an exception."));
        }
    }

    private long getId() {
        return this.id;
    }

    private Channel getChannel() {
        return this.channel;
    }

    private boolean isSent() {
        return this.sent > 0L;
    }

    public Request getRequest() {
        return this.request;
    }

    private int getTimeout() {
        return this.timeout;
    }

    private void doSent() {
        this.sent = System.currentTimeMillis();
    }

    private String getTimeoutMessage(boolean scan) {
        long nowTimestamp = System.currentTimeMillis();
        return (this.sent > 0L ? "Waiting server-side response timeout" : "Sending request timeout in client-side") + (scan ? " by scan timer" : "") + ". start time: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date(this.start)) + ", end time: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date(nowTimestamp)) + "," + (this.sent > 0L ? " client elapsed: " + (this.sent - this.start) + " ms, server elapsed: " + (nowTimestamp - this.sent) : " elapsed: " + (nowTimestamp - this.start)) + " ms, timeout: " + this.timeout + " ms, request: " + (logger.isDebugEnabled() ? this.request : this.getRequestWithoutData()) + ", channel: " + this.channel.getLocalAddress() + " -> " + this.channel.getRemoteAddress();
    }

    private Request getRequestWithoutData() {
        Request newRequest = this.request.copy();
        newRequest.setData(null);
        return newRequest;
    }

    private static class TimeoutCheckTask
    implements TimerTask {
        private final Long requestID;

        TimeoutCheckTask(Long requestID) {
            this.requestID = requestID;
        }

        public void run(Timeout timeout) {
            DefaultFuture future = DefaultFuture.getFuture(this.requestID);
            if (future == null || future.isDone()) {
                return;
            }
            if (future.getExecutor() != null) {
                future.getExecutor().execute(() -> this.notifyTimeout(future));
            } else {
                this.notifyTimeout(future);
            }
        }

        private void notifyTimeout(DefaultFuture future) {
            Response timeoutResponse = new Response(future.getId());
            timeoutResponse.setStatus(future.isSent() ? (byte)31 : 30);
            timeoutResponse.setErrorMessage(future.getTimeoutMessage(true));
            DefaultFuture.received(future.getChannel(), timeoutResponse, true);
        }
    }
}

