/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.api.pu;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.api.WireProtocol;
import org.apache.dubbo.remoting.transport.AbstractServer;

public abstract class AbstractPortUnificationServer
extends AbstractServer {
    private final Map<String, WireProtocol> protocols;
    private final Map<String, URL> supportedUrls = new ConcurrentHashMap<String, URL>();
    private final Map<String, ChannelHandler> supportedHandlers = new ConcurrentHashMap<String, ChannelHandler>();

    public AbstractPortUnificationServer(URL url, ChannelHandler handler) throws RemotingException {
        super(url, handler);
        ExtensionLoader extensionLoader = url.getOrDefaultFrameworkModel().getExtensionLoader(WireProtocol.class);
        this.protocols = extensionLoader.getActivateExtension(url, new String[0]).stream().collect(Collectors.toConcurrentMap(arg_0 -> ((ExtensionLoader)extensionLoader).getExtensionName(arg_0), Function.identity()));
    }

    public Map<String, WireProtocol> getProtocols() {
        return this.protocols;
    }

    public void addSupportedProtocol(URL url, ChannelHandler handler) {
        this.supportedUrls.put(url.getProtocol(), url);
        this.supportedHandlers.put(url.getProtocol(), handler);
    }

    protected Map<String, URL> getSupportedUrls() {
        return this.supportedUrls;
    }

    public Map<String, ChannelHandler> getSupportedHandlers() {
        return this.supportedHandlers;
    }
}

