/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.exchange.support.header;

import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.ExecutionException;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.exchange.ExchangeChannel;
import org.apache.dubbo.remoting.exchange.ExchangeHandler;
import org.apache.dubbo.remoting.exchange.Request;
import org.apache.dubbo.remoting.exchange.Response;
import org.apache.dubbo.remoting.exchange.support.DefaultFuture;
import org.apache.dubbo.remoting.exchange.support.MultiMessage;
import org.apache.dubbo.remoting.exchange.support.header.HeaderExchangeChannel;
import org.apache.dubbo.remoting.transport.ChannelHandlerDelegate;
import org.apache.dubbo.rpc.model.ScopeModel;

public class HeaderExchangeHandler
implements ChannelHandlerDelegate {
    protected static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(HeaderExchangeHandler.class);
    private final ExchangeHandler handler;

    public HeaderExchangeHandler(ExchangeHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("handler == null");
        }
        this.handler = handler;
    }

    static void handleResponse(Channel channel, Response response) throws RemotingException {
        if (response != null && !response.isHeartbeat()) {
            DefaultFuture.received(channel, response);
        }
    }

    private static boolean isClientSide(Channel channel) {
        InetSocketAddress address = channel.getRemoteAddress();
        URL url = channel.getUrl();
        return url.getPort() == address.getPort() && NetUtils.filterLocalHost((String)url.getIp()).equals(NetUtils.filterLocalHost((String)address.getAddress().getHostAddress()));
    }

    void handlerEvent(Channel channel, Request req) throws RemotingException {
        if (req.getData() != null && req.getData().equals("R")) {
            channel.setAttribute("channel.readonly", Boolean.TRUE);
            logger.info("ChannelReadOnly set true for channel: " + channel);
        }
        if (req.getData() != null && req.getData().equals("W")) {
            channel.removeAttribute("channel.readonly");
            logger.info("ChannelReadOnly set false for channel: " + channel);
        }
    }

    void handleRequest(ExchangeChannel channel, Request req) throws RemotingException {
        Response res = new Response(req.getId(), req.getVersion());
        if (req.isBroken()) {
            Object data = req.getData();
            String msg = data == null ? null : (data instanceof Throwable ? StringUtils.toString((Throwable)((Throwable)data)) : data.toString());
            res.setErrorMessage("Fail to decode request due to: " + msg);
            res.setStatus((byte)40);
            channel.send(res);
            return;
        }
        Object msg = req.getData();
        try {
            CompletableFuture<Object> future = this.handler.reply(channel, msg);
            future.whenComplete((appResult, t) -> {
                try {
                    if (t == null) {
                        res.setStatus((byte)20);
                        res.setResult(appResult);
                    } else {
                        res.setStatus((byte)70);
                        res.setErrorMessage(StringUtils.toString((Throwable)t));
                    }
                    channel.send(res);
                }
                catch (RemotingException e) {
                    logger.warn("6-14", "", "", "Send result to consumer failed, channel is " + channel + ", msg is " + e);
                }
            });
        }
        catch (Throwable e) {
            res.setStatus((byte)70);
            res.setErrorMessage(StringUtils.toString((Throwable)e));
            channel.send(res);
        }
    }

    @Override
    public void connected(Channel channel) throws RemotingException {
        HeaderExchangeChannel exchangeChannel = HeaderExchangeChannel.getOrAddChannel(channel);
        this.handler.connected(exchangeChannel);
        channel.setAttribute("channel.shutdown.timeout", ConfigurationUtils.getServerShutdownTimeout((ScopeModel)channel.getUrl().getOrDefaultApplicationModel()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnected(Channel channel) throws RemotingException {
        HeaderExchangeChannel exchangeChannel = HeaderExchangeChannel.getOrAddChannel(channel);
        try {
            this.handler.disconnected(exchangeChannel);
        }
        finally {
            int shutdownTimeout = 0;
            Object timeoutObj = channel.getAttribute("channel.shutdown.timeout");
            if (timeoutObj instanceof Integer) {
                shutdownTimeout = (Integer)timeoutObj;
            }
            DefaultFuture.closeChannel(channel, shutdownTimeout);
            HeaderExchangeChannel.removeChannel(channel);
        }
    }

    @Override
    public void sent(Channel channel, Object message) throws RemotingException {
        Throwable exception = null;
        try {
            HeaderExchangeChannel exchangeChannel = HeaderExchangeChannel.getOrAddChannel(channel);
            this.handler.sent(exchangeChannel, message);
        }
        catch (Throwable t) {
            exception = t;
            HeaderExchangeChannel.removeChannelIfDisconnected(channel);
        }
        if (message instanceof Request) {
            Request request = (Request)message;
            DefaultFuture.sent(channel, request);
        }
        if (message instanceof MultiMessage) {
            MultiMessage multiMessage = (MultiMessage)message;
            for (Object single : multiMessage) {
                if (!(single instanceof Request)) continue;
                DefaultFuture.sent(channel, (Request)single);
            }
        }
        if (exception != null) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof RemotingException) {
                throw (RemotingException)exception;
            }
            throw new RemotingException(channel.getLocalAddress(), channel.getRemoteAddress(), exception.getMessage(), exception);
        }
    }

    @Override
    public void received(Channel channel, Object message) throws RemotingException {
        HeaderExchangeChannel exchangeChannel = HeaderExchangeChannel.getOrAddChannel(channel);
        if (message instanceof Request) {
            Request request = (Request)message;
            if (request.isEvent()) {
                this.handlerEvent(channel, request);
            } else if (request.isTwoWay()) {
                this.handleRequest(exchangeChannel, request);
            } else {
                this.handler.received(exchangeChannel, request.getData());
            }
        } else if (message instanceof Response) {
            HeaderExchangeHandler.handleResponse(channel, (Response)message);
        } else if (message instanceof String) {
            if (HeaderExchangeHandler.isClientSide(channel)) {
                Exception e = new Exception("Dubbo client can not supported string message: " + message + " in channel: " + channel + ", url: " + channel.getUrl());
                logger.error("6-6", "", "", e.getMessage(), (Throwable)e);
            } else {
                String echo = this.handler.telnet(channel, (String)message);
                if (StringUtils.isNotEmpty((String)echo)) {
                    channel.send(echo);
                }
            }
        } else {
            this.handler.received(exchangeChannel, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void caught(Channel channel, Throwable exception) throws RemotingException {
        Request req;
        ExecutionException e;
        Object msg;
        if (exception instanceof ExecutionException && (msg = (e = (ExecutionException)exception).getRequest()) instanceof Request && (req = (Request)msg).isTwoWay() && !req.isHeartbeat()) {
            Response res = new Response(req.getId(), req.getVersion());
            res.setStatus((byte)80);
            res.setErrorMessage(StringUtils.toString((Throwable)e));
            channel.send(res);
            return;
        }
        HeaderExchangeChannel exchangeChannel = HeaderExchangeChannel.getOrAddChannel(channel);
        try {
            this.handler.caught(exchangeChannel, exception);
        }
        finally {
            HeaderExchangeChannel.removeChannelIfDisconnected(channel);
        }
    }

    @Override
    public ChannelHandler getHandler() {
        if (this.handler instanceof ChannelHandlerDelegate) {
            return ((ChannelHandlerDelegate)((Object)this.handler)).getHandler();
        }
        return this.handler;
    }
}

