/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.exchange;

import java.security.SecureRandom;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.common.utils.SystemPropertyConfigUtils;

public class Request {
    private static final AtomicLong INVOKE_ID;
    private final long mId;
    private String mVersion;
    private boolean mTwoWay = true;
    private boolean mEvent = false;
    private boolean mBroken = false;
    private int mPayload;
    private Object mData;

    public Request() {
        this.mId = Request.newId();
    }

    public Request(long id) {
        this.mId = id;
    }

    private static long newId() {
        return INVOKE_ID.getAndIncrement();
    }

    private static String safeToString(Object data) {
        if (data == null) {
            return null;
        }
        try {
            return data.toString();
        }
        catch (Exception e) {
            return "<Fail toString of " + data.getClass() + ", cause: " + StringUtils.toString((Throwable)e) + ">";
        }
    }

    public long getId() {
        return this.mId;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public void setVersion(String version) {
        this.mVersion = version;
    }

    public boolean isTwoWay() {
        return this.mTwoWay;
    }

    public void setTwoWay(boolean twoWay) {
        this.mTwoWay = twoWay;
    }

    public boolean isEvent() {
        return this.mEvent;
    }

    public void setEvent(String event) {
        this.mEvent = true;
        this.mData = event;
    }

    public void setEvent(boolean mEvent) {
        this.mEvent = mEvent;
    }

    public boolean isBroken() {
        return this.mBroken;
    }

    public void setBroken(boolean mBroken) {
        this.mBroken = mBroken;
    }

    public int getPayload() {
        return this.mPayload;
    }

    public void setPayload(int mPayload) {
        this.mPayload = mPayload;
    }

    public Object getData() {
        return this.mData;
    }

    public void setData(Object msg) {
        this.mData = msg;
    }

    public boolean isHeartbeat() {
        return this.mEvent && CommonConstants.HEARTBEAT_EVENT == this.mData;
    }

    public void setHeartbeat(boolean isHeartbeat) {
        if (isHeartbeat) {
            this.setEvent(CommonConstants.HEARTBEAT_EVENT);
        }
    }

    public Request copy() {
        Request copy = new Request(this.mId);
        copy.mVersion = this.mVersion;
        copy.mTwoWay = this.mTwoWay;
        copy.mEvent = this.mEvent;
        copy.mBroken = this.mBroken;
        copy.mPayload = this.mPayload;
        copy.mData = this.mData;
        return copy;
    }

    public Request copyWithoutData() {
        Request copy = new Request(this.mId);
        copy.mVersion = this.mVersion;
        copy.mTwoWay = this.mTwoWay;
        copy.mEvent = this.mEvent;
        copy.mBroken = this.mBroken;
        copy.mPayload = this.mPayload;
        return copy;
    }

    public String toString() {
        return "Request [id=" + this.mId + ", version=" + this.mVersion + ", twoWay=" + this.mTwoWay + ", event=" + this.mEvent + ", broken=" + this.mBroken + ", mPayload=" + this.mPayload + ", data=" + (this.mData == this ? "this" : Request.safeToString(this.mData)) + "]";
    }

    static {
        long startID = ThreadLocalRandom.current().nextLong();
        if (Boolean.parseBoolean(SystemPropertyConfigUtils.getSystemProperty((String)"dubbo.application.use-secure-random-request-id", (String)"false"))) {
            try {
                SecureRandom rand = new SecureRandom(SecureRandom.getSeed(20));
                startID = rand.nextLong();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        INVOKE_ID = new AtomicLong(startID);
    }
}

