/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.rpc.Exporter;

public class DelegateExporterMap {
    protected final Map<String, Exporter<?>> exporterMap = new ConcurrentHashMap();

    public boolean isEmpty() {
        return CollectionUtils.isEmptyMap(this.exporterMap);
    }

    public Exporter<?> getExport(String key) {
        return this.exporterMap.get(key);
    }

    public void addExportMap(String key, Exporter<?> exporter) {
        this.exporterMap.put(key, exporter);
    }

    public boolean removeExportMap(String key, Exporter<?> exporter) {
        Exporter<?> findExporter = this.exporterMap.get(key);
        if (findExporter == exporter) {
            this.exporterMap.remove(key);
            return true;
        }
        return false;
    }

    public Map<String, Exporter<?>> getExporterMap() {
        return this.exporterMap;
    }

    public Collection<Exporter<?>> getExporters() {
        return Collections.unmodifiableCollection(this.exporterMap.values());
    }
}

