/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.boot.context.event;

import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.dubbo.config.ApplicationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;

public class DubboConfigBeanDefinitionConflictApplicationListener
implements ApplicationListener<ContextRefreshedEvent>,
Ordered {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void onApplicationEvent(ContextRefreshedEvent event) {
        ApplicationContext applicationContext = event.getApplicationContext();
        BeanDefinitionRegistry registry = this.getBeanDefinitionRegistry(applicationContext);
        this.resolveUniqueApplicationConfigBean(registry, (ListableBeanFactory)applicationContext);
    }

    private BeanDefinitionRegistry getBeanDefinitionRegistry(ApplicationContext applicationContext) {
        AutowireCapableBeanFactory beanFactory = applicationContext.getAutowireCapableBeanFactory();
        if (beanFactory instanceof BeanDefinitionRegistry) {
            return (BeanDefinitionRegistry)beanFactory;
        }
        throw new IllegalStateException("The BeanFactory in the ApplicationContext must bea subclass of BeanDefinitionRegistry");
    }

    private void resolveUniqueApplicationConfigBean(BeanDefinitionRegistry registry, ListableBeanFactory beanFactory) {
        String[] beansNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, ApplicationConfig.class);
        if (beansNames.length < 2) {
            return;
        }
        Environment environment = (Environment)beanFactory.getBean("environment", Environment.class);
        Stream.of(beansNames).filter(beansName -> this.isConfiguredApplicationConfigBeanName(environment, (String)beansName)).forEach(arg_0 -> ((BeanDefinitionRegistry)registry).removeBeanDefinition(arg_0));
        beansNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, ApplicationConfig.class);
        if (beansNames.length > 1) {
            Object[] objectArray = new Object[2];
            objectArray[0] = ApplicationConfig.class.getSimpleName();
            objectArray[1] = Stream.of(beansNames).map(arg_0 -> ((BeanDefinitionRegistry)registry).getBeanDefinition(arg_0)).collect(Collectors.toList());
            throw new IllegalStateException(String.format("There are more than one instances of %s, whose bean definitions : %s", objectArray));
        }
    }

    private boolean isConfiguredApplicationConfigBeanName(Environment environment, String beanName) {
        boolean removed;
        boolean bl = removed = BeanFactoryUtils.isGeneratedBeanName((String)beanName) || Objects.equals(beanName, environment.getProperty("dubbo.application.id"));
        if (removed && this.logger.isDebugEnabled()) {
            this.logger.debug("The {} bean [ name : {} ] has been removed!", (Object)ApplicationConfig.class.getSimpleName(), (Object)beanName);
        }
        return removed;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

