/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.xds.util.protocol.delta;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.registry.xds.util.protocol.DeltaResource;
import org.apache.dubbo.registry.xds.util.protocol.message.ListenerResult;

public class DeltaListener
implements DeltaResource<ListenerResult> {
    private final Map<String, Set<String>> data = new ConcurrentHashMap<String, Set<String>>();

    public void addResource(String resourceName, Set<String> listeners) {
        this.data.put(resourceName, listeners);
    }

    public void removeResource(Collection<String> resourceName) {
        if (CollectionUtils.isNotEmpty(resourceName)) {
            resourceName.forEach(this.data::remove);
        }
    }

    @Override
    public ListenerResult getResource() {
        Set<String> set = this.data.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        return new ListenerResult(set);
    }
}

