/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.store.redis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.configcenter.ConfigItem;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.MappingChangedEvent;
import org.apache.dubbo.metadata.MappingListener;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.metadata.ServiceNameMapping;
import org.apache.dubbo.metadata.report.identifier.BaseMetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.KeyTypeEnum;
import org.apache.dubbo.metadata.report.identifier.MetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.ServiceMetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.SubscriberMetadataIdentifier;
import org.apache.dubbo.metadata.report.support.AbstractMetadataReport;
import org.apache.dubbo.metadata.report.support.Constants;
import org.apache.dubbo.rpc.RpcException;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.params.SetParams;
import redis.clients.jedis.util.JedisClusterCRC16;

public class RedisMetadataReport
extends AbstractMetadataReport {
    private static final int ONE_DAY_IN_MILLISECONDS = 86400000;
    private static final String REDIS_DATABASE_KEY = "database";
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(RedisMetadataReport.class);
    protected JedisPool pool;
    private Set<HostAndPort> jedisClusterNodes;
    private int timeout;
    private String password;
    private final String root;
    private final ConcurrentHashMap<String, MappingDataListener> mappingDataListenerMap = new ConcurrentHashMap();
    private SetParams jedisParams = SetParams.setParams();

    public RedisMetadataReport(URL url) {
        super(url);
        this.timeout = url.getParameter("timeout", 1000);
        this.password = url.getPassword();
        this.root = url.getGroup("dubbo");
        if (url.getParameter("cycle-report", Constants.DEFAULT_METADATA_REPORT_CYCLE_REPORT.booleanValue())) {
            this.jedisParams.ex(172800000L);
        }
        if (url.getParameter("cluster", false)) {
            this.jedisClusterNodes = new HashSet<HostAndPort>();
            List urls = url.getBackupUrls();
            for (URL tmpUrl : urls) {
                this.jedisClusterNodes.add(new HostAndPort(tmpUrl.getHost(), tmpUrl.getPort()));
            }
        } else {
            int database = url.getParameter(REDIS_DATABASE_KEY, 0);
            this.pool = new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), url.getHost(), url.getPort(), this.timeout, this.password, database);
        }
    }

    protected void doStoreProviderMetadata(MetadataIdentifier providerMetadataIdentifier, String serviceDefinitions) {
        this.storeMetadata((BaseMetadataIdentifier)providerMetadataIdentifier, serviceDefinitions);
    }

    protected void doStoreConsumerMetadata(MetadataIdentifier consumerMetadataIdentifier, String value) {
        this.storeMetadata((BaseMetadataIdentifier)consumerMetadataIdentifier, value);
    }

    protected void doSaveMetadata(ServiceMetadataIdentifier serviceMetadataIdentifier, URL url) {
        this.storeMetadata((BaseMetadataIdentifier)serviceMetadataIdentifier, URL.encode((String)url.toFullString()));
    }

    protected void doRemoveMetadata(ServiceMetadataIdentifier serviceMetadataIdentifier) {
        this.deleteMetadata((BaseMetadataIdentifier)serviceMetadataIdentifier);
    }

    protected List<String> doGetExportedURLs(ServiceMetadataIdentifier metadataIdentifier) {
        String content = this.getMetadata((BaseMetadataIdentifier)metadataIdentifier);
        if (StringUtils.isEmpty((String)content)) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(Arrays.asList(URL.decode((String)content)));
    }

    protected void doSaveSubscriberData(SubscriberMetadataIdentifier subscriberMetadataIdentifier, String urlListStr) {
        this.storeMetadata((BaseMetadataIdentifier)subscriberMetadataIdentifier, urlListStr);
    }

    protected String doGetSubscribedURLs(SubscriberMetadataIdentifier subscriberMetadataIdentifier) {
        return this.getMetadata((BaseMetadataIdentifier)subscriberMetadataIdentifier);
    }

    public String getServiceDefinition(MetadataIdentifier metadataIdentifier) {
        return this.getMetadata((BaseMetadataIdentifier)metadataIdentifier);
    }

    private void storeMetadata(BaseMetadataIdentifier metadataIdentifier, String v) {
        if (this.pool != null) {
            this.storeMetadataStandalone(metadataIdentifier, v);
        } else {
            this.storeMetadataInCluster(metadataIdentifier, v);
        }
    }

    private void storeMetadataInCluster(BaseMetadataIdentifier metadataIdentifier, String v) {
        try (JedisCluster jedisCluster = new JedisCluster(this.jedisClusterNodes, this.timeout, this.timeout, 2, this.password, new GenericObjectPoolConfig());){
            jedisCluster.set(metadataIdentifier.getIdentifierKey() + ".metaData", v, this.jedisParams);
        }
        catch (Throwable e) {
            String msg = "Failed to put " + metadataIdentifier + " to redis cluster " + v + ", cause: " + e.getMessage();
            logger.error("6-14", "", "", msg, e);
            throw new RpcException(msg, e);
        }
    }

    private void storeMetadataStandalone(BaseMetadataIdentifier metadataIdentifier, String v) {
        try (Jedis jedis = this.pool.getResource();){
            jedis.set(metadataIdentifier.getUniqueKey(KeyTypeEnum.UNIQUE_KEY), v, this.jedisParams);
        }
        catch (Throwable e) {
            String msg = "Failed to put " + metadataIdentifier + " to redis " + v + ", cause: " + e.getMessage();
            logger.error("6-14", "", "", msg, e);
            throw new RpcException(msg, e);
        }
    }

    private void deleteMetadata(BaseMetadataIdentifier metadataIdentifier) {
        if (this.pool != null) {
            this.deleteMetadataStandalone(metadataIdentifier);
        } else {
            this.deleteMetadataInCluster(metadataIdentifier);
        }
    }

    private void deleteMetadataInCluster(BaseMetadataIdentifier metadataIdentifier) {
        try (JedisCluster jedisCluster = new JedisCluster(this.jedisClusterNodes, this.timeout, this.timeout, 2, this.password, new GenericObjectPoolConfig());){
            jedisCluster.del(metadataIdentifier.getIdentifierKey() + ".metaData");
        }
        catch (Throwable e) {
            String msg = "Failed to delete " + metadataIdentifier + " from redis cluster , cause: " + e.getMessage();
            logger.error("6-14", "", "", msg, e);
            throw new RpcException(msg, e);
        }
    }

    private void deleteMetadataStandalone(BaseMetadataIdentifier metadataIdentifier) {
        try (Jedis jedis = this.pool.getResource();){
            jedis.del(metadataIdentifier.getUniqueKey(KeyTypeEnum.UNIQUE_KEY));
        }
        catch (Throwable e) {
            String msg = "Failed to delete " + metadataIdentifier + " from redis , cause: " + e.getMessage();
            logger.error("6-14", "", "", msg, e);
            throw new RpcException(msg, e);
        }
    }

    private String getMetadata(BaseMetadataIdentifier metadataIdentifier) {
        if (this.pool != null) {
            return this.getMetadataStandalone(metadataIdentifier);
        }
        return this.getMetadataInCluster(metadataIdentifier);
    }

    private String getMetadataInCluster(BaseMetadataIdentifier metadataIdentifier) {
        String string;
        JedisCluster jedisCluster = new JedisCluster(this.jedisClusterNodes, this.timeout, this.timeout, 2, this.password, new GenericObjectPoolConfig());
        try {
            string = jedisCluster.get(metadataIdentifier.getIdentifierKey() + ".metaData");
        }
        catch (Throwable throwable) {
            try {
                try {
                    jedisCluster.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable e) {
                String msg = "Failed to get " + metadataIdentifier + " from redis cluster , cause: " + e.getMessage();
                logger.error("6-14", "", "", msg, e);
                throw new RpcException(msg, e);
            }
        }
        jedisCluster.close();
        return string;
    }

    private String getMetadataStandalone(BaseMetadataIdentifier metadataIdentifier) {
        String string;
        block8: {
            Jedis jedis = this.pool.getResource();
            try {
                string = jedis.get(metadataIdentifier.getUniqueKey(KeyTypeEnum.UNIQUE_KEY));
                if (jedis == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jedis != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    String msg = "Failed to get " + metadataIdentifier + " from redis , cause: " + e.getMessage();
                    logger.error("6-14", "", "", msg, e);
                    throw new RpcException(msg, e);
                }
            }
            jedis.close();
        }
        return string;
    }

    public boolean registerServiceAppMapping(String serviceInterface, String defaultMappingGroup, String newConfigContent, Object ticket) {
        try {
            if (null != ticket && !(ticket instanceof String)) {
                throw new IllegalArgumentException("redis publishConfigCas requires stat type ticket");
            }
            String pathKey = this.buildMappingKey(defaultMappingGroup);
            return this.storeMapping(pathKey, serviceInterface, newConfigContent, (String)ticket);
        }
        catch (Exception e) {
            logger.warn("6-14", "", "", "redis publishConfigCas failed.", (Throwable)e);
            return false;
        }
    }

    private boolean storeMapping(String key, String field, String value, String ticket) {
        if (this.pool != null) {
            return this.storeMappingStandalone(key, field, value, ticket);
        }
        return this.storeMappingInCluster(key, field, value, ticket);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean storeMappingInCluster(String key, String field, String value, String ticket) {
        try (JedisCluster jedisCluster = new JedisCluster(this.jedisClusterNodes, this.timeout, this.timeout, 2, this.password, new GenericObjectPoolConfig());){
            Jedis jedis = new Jedis(jedisCluster.getConnectionFromSlot(JedisClusterCRC16.getSlot((String)key)));
            jedis.watch(new String[]{key});
            String oldValue = jedis.hget(key, field);
            if (null == oldValue || null == ticket || oldValue.equals(ticket)) {
                Transaction transaction = jedis.multi();
                transaction.hset(key, field, value);
                List result = transaction.exec();
                if (null != result) {
                    jedisCluster.publish(this.buildPubSubKey(), field);
                    boolean bl = true;
                    return bl;
                }
            } else {
                jedis.unwatch();
            }
            jedis.close();
            return false;
        }
        catch (Throwable e) {
            String msg = "Failed to put " + key + ":" + field + " to redis " + value + ", cause: " + e.getMessage();
            logger.error("6-14", "", "", msg, e);
            throw new RpcException(msg, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean storeMappingStandalone(String key, String field, String value, String ticket) {
        try (Jedis jedis = this.pool.getResource();){
            jedis.watch(new String[]{key});
            String oldValue = jedis.hget(key, field);
            if (null == oldValue || null == ticket || oldValue.equals(ticket)) {
                Transaction transaction = jedis.multi();
                transaction.hset(key, field, value);
                List result = transaction.exec();
                if (null != result) {
                    jedis.publish(this.buildPubSubKey(), field);
                    boolean bl = true;
                    return bl;
                }
            }
            jedis.unwatch();
            return false;
        }
        catch (Throwable e) {
            String msg = "Failed to put " + key + ":" + field + " to redis " + value + ", cause: " + e.getMessage();
            logger.error("6-14", "", "", msg, e);
            throw new RpcException(msg, e);
        }
    }

    private String buildMappingKey(String defaultMappingGroup) {
        return this.root + ":" + defaultMappingGroup;
    }

    private String buildPubSubKey() {
        return this.buildMappingKey("mapping") + ":" + "queues";
    }

    public ConfigItem getConfigItem(String serviceKey, String group) {
        String key = this.buildMappingKey(group);
        String content = this.getMappingData(key, serviceKey);
        return new ConfigItem(content, (Object)content);
    }

    private String getMappingData(String key, String field) {
        if (this.pool != null) {
            return this.getMappingDataStandalone(key, field);
        }
        return this.getMappingDataInCluster(key, field);
    }

    private String getMappingDataInCluster(String key, String field) {
        String string;
        JedisCluster jedisCluster = new JedisCluster(this.jedisClusterNodes, this.timeout, this.timeout, 2, this.password, new GenericObjectPoolConfig());
        try {
            string = jedisCluster.hget(key, field);
        }
        catch (Throwable throwable) {
            try {
                try {
                    jedisCluster.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable e) {
                String msg = "Failed to get " + key + ":" + field + " from redis cluster , cause: " + e.getMessage();
                logger.error("6-14", "", "", msg, e);
                throw new RpcException(msg, e);
            }
        }
        jedisCluster.close();
        return string;
    }

    private String getMappingDataStandalone(String key, String field) {
        String string;
        block8: {
            Jedis jedis = this.pool.getResource();
            try {
                string = jedis.hget(key, field);
                if (jedis == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jedis != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    String msg = "Failed to get " + key + ":" + field + " from redis , cause: " + e.getMessage();
                    logger.error("6-14", "", "", msg, e);
                    throw new RpcException(msg, e);
                }
            }
            jedis.close();
        }
        return string;
    }

    public void removeServiceAppMappingListener(String serviceKey, MappingListener listener) {
        MappingDataListener mappingDataListener = this.mappingDataListenerMap.get(this.buildPubSubKey());
        if (null != mappingDataListener) {
            NotifySub notifySub = mappingDataListener.getNotifySub();
            notifySub.removeListener(serviceKey, listener);
            if (notifySub.isEmpty().booleanValue()) {
                mappingDataListener.shutdown();
            }
        }
    }

    public Set<String> getServiceAppMapping(String serviceKey, MappingListener listener, URL url) {
        MappingDataListener mappingDataListener = (MappingDataListener)ConcurrentHashMapUtils.computeIfAbsent(this.mappingDataListenerMap, (Object)this.buildPubSubKey(), k -> {
            MappingDataListener dataListener = new MappingDataListener(this.buildPubSubKey());
            dataListener.start();
            return dataListener;
        });
        mappingDataListener.getNotifySub().addListener(serviceKey, listener);
        return this.getServiceAppMapping(serviceKey, url);
    }

    public Set<String> getServiceAppMapping(String serviceKey, URL url) {
        String key = this.buildMappingKey("mapping");
        return ServiceNameMapping.getAppNames((String)this.getMappingData(key, serviceKey));
    }

    public MetadataInfo getAppMetadata(SubscriberMetadataIdentifier identifier, Map<String, String> instanceMetadata) {
        String content = this.getMetadata((BaseMetadataIdentifier)identifier);
        return (MetadataInfo)JsonUtils.toJavaObject((String)content, MetadataInfo.class);
    }

    public void publishAppMetadata(SubscriberMetadataIdentifier identifier, MetadataInfo metadataInfo) {
        this.storeMetadata((BaseMetadataIdentifier)identifier, metadataInfo.getContent());
    }

    public void unPublishAppMetadata(SubscriberMetadataIdentifier identifier, MetadataInfo metadataInfo) {
        this.deleteMetadata((BaseMetadataIdentifier)identifier);
    }

    public MappingDataListener getMappingDataListener() {
        return this.mappingDataListenerMap.get(this.buildPubSubKey());
    }

    class MappingDataListener
    extends Thread {
        private String path;
        private final NotifySub notifySub;
        protected volatile boolean running;

        public MappingDataListener(String path) {
            this.notifySub = new NotifySub();
            this.running = true;
            this.path = path;
        }

        public NotifySub getNotifySub() {
            return this.notifySub;
        }

        @Override
        public void run() {
            while (this.running) {
                if (RedisMetadataReport.this.pool != null) {
                    try {
                        Jedis jedis = RedisMetadataReport.this.pool.getResource();
                        try {
                            jedis.subscribe((JedisPubSub)this.notifySub, new String[]{this.path});
                            continue;
                        }
                        finally {
                            if (jedis == null) continue;
                            jedis.close();
                            continue;
                        }
                    }
                    catch (Throwable e) {
                        String msg = "Failed to subscribe " + this.path + ", cause: " + e.getMessage();
                        logger.error("6-14", "", "", msg, e);
                        throw new RpcException(msg, e);
                    }
                }
                try (JedisCluster jedisCluster = new JedisCluster(RedisMetadataReport.this.jedisClusterNodes, RedisMetadataReport.this.timeout, RedisMetadataReport.this.timeout, 2, RedisMetadataReport.this.password, new GenericObjectPoolConfig());){
                    jedisCluster.subscribe((JedisPubSub)this.notifySub, new String[]{this.path});
                }
                catch (Throwable e) {
                    String msg = "Failed to subscribe " + this.path + ", cause: " + e.getMessage();
                    logger.error("6-14", "", "", msg, e);
                    throw new RpcException(msg, e);
                }
            }
        }

        public void shutdown() {
            try {
                this.running = false;
                this.notifySub.unsubscribe(new String[]{this.path});
            }
            catch (Throwable e) {
                String msg = "Failed to unsubscribe " + this.path + ", cause: " + e.getMessage();
                logger.error("6-14", "", "", msg, e);
            }
        }
    }

    class NotifySub
    extends JedisPubSub {
        private final Map<String, Set<MappingListener>> listeners = new ConcurrentHashMap<String, Set<MappingListener>>();

        NotifySub() {
        }

        public void addListener(String key, MappingListener listener) {
            Set listenerSet = this.listeners.computeIfAbsent(key, k -> new ConcurrentHashSet());
            listenerSet.add(listener);
        }

        public void removeListener(String serviceKey, MappingListener listener) {
            Set<MappingListener> listenerSet = this.listeners.get(serviceKey);
            if (listenerSet != null) {
                listenerSet.remove(listener);
                if (listenerSet.isEmpty()) {
                    this.listeners.remove(serviceKey);
                }
            }
        }

        public Boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void onMessage(String key, String msg) {
            logger.info("sub from redis:" + key + " message:" + msg);
            String applicationNames = RedisMetadataReport.this.getMappingData(RedisMetadataReport.this.buildMappingKey("mapping"), msg);
            MappingChangedEvent mappingChangedEvent = new MappingChangedEvent(msg, ServiceNameMapping.getAppNames((String)applicationNames));
            if (!CollectionUtils.isEmpty((Collection)this.listeners.get(msg))) {
                for (MappingListener mappingListener : this.listeners.get(msg)) {
                    mappingListener.onEvent(mappingChangedEvent);
                }
            }
        }

        public void onPMessage(String pattern, String key, String msg) {
            this.onMessage(key, msg);
        }

        public void onPSubscribe(String pattern, int subscribedChannels) {
            super.onPSubscribe((Object)pattern, subscribedChannels);
        }
    }
}

