/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.com.caucho.hessian.io.socket;

import com.alibaba.com.caucho.hessian.HessianException;
import com.alibaba.com.caucho.hessian.io.AbstractHessianOutput;
import com.alibaba.com.caucho.hessian.io.AbstractSerializer;
import com.alibaba.com.caucho.hessian.io.HessianFieldException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;

public class UnixDomainSocketAddressSerializer
extends AbstractSerializer {
    private static Method getHostAddressMethod = null;

    @Override
    public void writeObject(Object obj, AbstractHessianOutput out) throws IOException {
        String replacedClName = "java.net.UnixDomainSocketAddress$Ser";
        int ref = out.writeObjectBegin(replacedClName);
        if (ref < -1) {
            out.writeString("pathname");
            this.writeUnixDomainSocketAddressPath(obj, out);
            out.writeMapEnd();
        } else {
            if (ref == -1) {
                out.writeClassFieldLength(1);
                out.writeString("pathname");
                out.writeObjectBegin(replacedClName);
            }
            this.writeUnixDomainSocketAddressPath(obj, out);
        }
    }

    private void writeUnixDomainSocketAddressPath(Object obj, AbstractHessianOutput out) throws IOException {
        Path path;
        if (getHostAddressMethod != null) {
            try {
                path = (Path)getHostAddressMethod.invoke(obj, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new HessianFieldException(e);
            }
        } else {
            throw new HessianException("Unable to invoke UnixDomainSocketAddress.getPath() method.");
        }
        out.writeString(path.toString());
    }

    static {
        try {
            Class<?> cl = Class.forName("java.net.UnixDomainSocketAddress");
            getHostAddressMethod = cl.getMethod("getPath", new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

