/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundleplugin.baseline;

import aQute.bnd.differ.Baseline;
import aQute.bnd.differ.DiffPluginImpl;
import aQute.bnd.osgi.Instructions;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Processor;
import aQute.bnd.service.diff.Delta;
import aQute.bnd.service.diff.Diff;
import aQute.bnd.service.diff.Differ;
import aQute.bnd.version.Version;
import aQute.service.reporter.Reporter;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.bundleplugin.baseline.DiffMessage;
import org.apache.felix.bundleplugin.baseline.InfoComparator;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractBaselinePlugin
extends AbstractMojo {
    protected boolean skip;
    protected boolean failOnError;
    protected boolean failOnWarning;
    protected MavenProject project;
    private File buildDirectory;
    private String finalName;
    protected ArtifactResolver resolver;
    protected ArtifactFactory factory;
    protected ArtifactRepository localRepository;
    private ArtifactMetadataSource metadataSource;
    protected String comparisonVersion;
    protected String comparisonClassifier;
    private String[] filters;
    protected List supportedProjectTypes = Arrays.asList("jar", "bundle");

    AbstractBaselinePlugin() {
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping Baseline execution");
            return;
        }
        if (!this.supportedProjectTypes.contains(this.project.getArtifact().getType())) {
            this.getLog().info((CharSequence)("Skipping Baseline (project type " + this.project.getArtifact().getType() + " not supported)"));
            return;
        }
        Jar currentBundle = this.getCurrentBundle();
        if (currentBundle == null) {
            this.getLog().info((CharSequence)"Not generating Baseline report as there is no bundle generated by the project");
            return;
        }
        Jar previousBundle = this.getPreviousBundle();
        if (previousBundle == null) {
            this.getLog().info((CharSequence)"Not generating Baseline report as there is no previous version of the library to compare against");
            return;
        }
        Instructions packageFilters = this.filters == null || this.filters.length == 0 ? new Instructions() : new Instructions(Arrays.asList(this.filters));
        this.init();
        String generationDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'").format(new Date());
        Processor reporter = new Processor();
        try {
            Set infoSet = new Baseline((Reporter)reporter, (Differ)new DiffPluginImpl()).baseline(currentBundle, previousBundle, packageFilters);
            this.startBaseline(generationDate, this.project.getArtifactId(), this.project.getVersion(), this.comparisonVersion);
            Baseline.Info[] infos = infoSet.toArray(new Baseline.Info[infoSet.size()]);
            Arrays.sort(infos, new InfoComparator());
            for (Baseline.Info info : infos) {
                DiffMessage diffMessage = null;
                Version newerVersion = info.newerVersion;
                Version suggestedVersion = info.suggestedVersion;
                if (suggestedVersion != null) {
                    if (newerVersion.compareTo(suggestedVersion) > 0) {
                        diffMessage = new DiffMessage("Excessive version increase", DiffMessage.Type.warning);
                        reporter.warning("%s: %s; detected %s, suggested %s", new Object[]{info.packageName, diffMessage, info.newerVersion, info.suggestedVersion});
                    } else if (newerVersion.compareTo(suggestedVersion) < 0) {
                        diffMessage = new DiffMessage("Version increase required", DiffMessage.Type.error);
                        reporter.error("%s: %s; detected %s, suggested %s", new Object[]{info.packageName, diffMessage, info.newerVersion, info.suggestedVersion});
                    }
                }
                Diff packageDiff = info.packageDiff;
                Delta delta = packageDiff.getDelta();
                switch (delta) {
                    case UNCHANGED: {
                        if (suggestedVersion.getMajor() == newerVersion.getMajor() && suggestedVersion.getMicro() == newerVersion.getMicro() && suggestedVersion.getMinor() == newerVersion.getMinor()) break;
                        diffMessage = new DiffMessage("Version has been increased but analysis detected no changes", DiffMessage.Type.warning);
                        reporter.warning("%s: %s; detected %s, suggested %s", new Object[]{info.packageName, diffMessage, info.newerVersion, info.suggestedVersion});
                        break;
                    }
                    case REMOVED: {
                        diffMessage = new DiffMessage("Package removed", DiffMessage.Type.info);
                        reporter.trace("%s: %s ", new Object[]{info.packageName, diffMessage});
                        break;
                    }
                }
                boolean mismatch = info.mismatch;
                String packageName = info.packageName;
                String shortDelta = AbstractBaselinePlugin.getShortDelta(info.packageDiff.getDelta());
                String deltaString = StringUtils.lowerCase((String)String.valueOf(info.packageDiff.getDelta()));
                String newerVersionString = String.valueOf(info.newerVersion);
                String olderVersionString = String.valueOf(info.olderVersion);
                String suggestedVersionString = String.valueOf(info.suggestedVersion == null ? "-" : info.suggestedVersion);
                Map attributes = info.attributes;
                this.startPackage(mismatch, packageName, shortDelta, deltaString, newerVersionString, olderVersionString, suggestedVersionString, diffMessage, attributes);
                if (Delta.REMOVED != delta) {
                    this.doPackageDiff(packageDiff);
                }
                this.endPackage();
            }
            this.endBaseline();
        }
        catch (Exception e) {
            try {
                throw new MojoExecutionException("Impossible to calculate the baseline", e);
            }
            catch (Throwable throwable) {
                AbstractBaselinePlugin.closeJars(currentBundle, previousBundle);
                throw throwable;
            }
        }
        AbstractBaselinePlugin.closeJars(currentBundle, previousBundle);
        boolean fail = false;
        if (!reporter.isOk()) {
            for (String errorMessage : reporter.getErrors()) {
                this.getLog().error((CharSequence)errorMessage);
            }
            if (this.failOnError) {
                fail = true;
            }
        }
        if (!reporter.getWarnings().isEmpty()) {
            for (String warningMessage : reporter.getWarnings()) {
                this.getLog().warn((CharSequence)warningMessage);
            }
            if (this.failOnWarning) {
                fail = true;
            }
        }
        this.getLog().info((CharSequence)String.format("Baseline analysis complete, %s error(s), %s warning(s)", reporter.getErrors().size(), reporter.getWarnings().size()));
        if (fail) {
            throw new MojoFailureException("Baseline failed, see generated report");
        }
    }

    private void doPackageDiff(Diff diff) {
        int depth = 1;
        for (Diff curDiff : diff.getChildren()) {
            if (Delta.UNCHANGED == curDiff.getDelta()) continue;
            this.doDiff(curDiff, depth);
        }
    }

    private void doDiff(Diff diff, int depth) {
        String type = StringUtils.lowerCase((String)String.valueOf(diff.getType()));
        String shortDelta = AbstractBaselinePlugin.getShortDelta(diff.getDelta());
        String delta = StringUtils.lowerCase((String)String.valueOf(diff.getDelta()));
        String name = diff.getName();
        this.startDiff(depth, type, name, delta, shortDelta);
        for (Diff curDiff : diff.getChildren()) {
            if (Delta.UNCHANGED == curDiff.getDelta()) continue;
            this.doDiff(curDiff, depth + 1);
        }
        this.endDiff(depth);
    }

    protected abstract void init();

    protected abstract void startBaseline(String var1, String var2, String var3, String var4);

    protected abstract void startPackage(boolean var1, String var2, String var3, String var4, String var5, String var6, String var7, DiffMessage var8, Map<String, String> var9);

    protected abstract void startDiff(int var1, String var2, String var3, String var4, String var5);

    protected abstract void endDiff(int var1);

    protected abstract void endPackage();

    protected abstract void endBaseline();

    private Jar getCurrentBundle() throws MojoExecutionException {
        File currentBundle = new File(this.buildDirectory, this.getBundleName());
        if (!currentBundle.exists()) {
            this.getLog().debug((CharSequence)("Produced bundle not found: " + currentBundle));
            return null;
        }
        return AbstractBaselinePlugin.openJar(currentBundle);
    }

    private Jar getPreviousBundle() throws MojoFailureException, MojoExecutionException {
        Artifact previousArtifact;
        VersionRange range;
        try {
            range = VersionRange.createFromVersionSpec((String)this.comparisonVersion);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoFailureException("Invalid comparison version: " + e.getMessage());
        }
        try {
            previousArtifact = this.factory.createDependencyArtifact(this.project.getGroupId(), this.project.getArtifactId(), range, this.project.getPackaging(), this.comparisonClassifier, "compile");
            if (!previousArtifact.getVersionRange().isSelectedVersionKnown(previousArtifact)) {
                this.getLog().debug((CharSequence)("Searching for versions in range: " + previousArtifact.getVersionRange()));
                List availableVersions = this.metadataSource.retrieveAvailableVersions(previousArtifact, this.localRepository, this.project.getRemoteArtifactRepositories());
                this.filterSnapshots(availableVersions);
                ArtifactVersion version = range.matchVersion(availableVersions);
                if (version != null) {
                    previousArtifact.selectVersion(version.toString());
                }
            }
        }
        catch (OverConstrainedVersionException ocve) {
            throw new MojoFailureException("Invalid comparison version: " + ocve.getMessage());
        }
        catch (ArtifactMetadataRetrievalException amre) {
            throw new MojoExecutionException("Error determining previous version: " + amre.getMessage(), (Exception)((Object)amre));
        }
        if (previousArtifact.getVersion() == null) {
            this.getLog().info((CharSequence)"Unable to find a previous version of the project in the repository");
            return null;
        }
        try {
            this.resolver.resolve(previousArtifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
        }
        catch (ArtifactResolutionException are) {
            throw new MojoExecutionException("Artifact " + previousArtifact + " cannot be resolved", (Exception)((Object)are));
        }
        catch (ArtifactNotFoundException anfe) {
            throw new MojoExecutionException("Artifact " + previousArtifact + " does not exist on local/remote repositories", (Exception)((Object)anfe));
        }
        return AbstractBaselinePlugin.openJar(previousArtifact.getFile());
    }

    private void filterSnapshots(List<ArtifactVersion> versions) {
        Iterator<ArtifactVersion> versionIterator = versions.iterator();
        while (versionIterator.hasNext()) {
            ArtifactVersion version = versionIterator.next();
            if (!"SNAPSHOT".equals(version.getQualifier())) continue;
            versionIterator.remove();
        }
    }

    private static Jar openJar(File file) throws MojoExecutionException {
        try {
            return new Jar(file);
        }
        catch (IOException e) {
            throw new MojoExecutionException("An error occurred while opening JAR directory: " + file, (Exception)e);
        }
    }

    private static void closeJars(Jar ... jars) {
        for (Jar jar : jars) {
            jar.close();
        }
    }

    private String getBundleName() {
        String classifier;
        String extension;
        try {
            extension = this.project.getArtifact().getArtifactHandler().getExtension();
        }
        catch (Throwable e) {
            extension = this.project.getArtifact().getType();
        }
        if (StringUtils.isEmpty((String)extension) || "bundle".equals(extension) || "pom".equals(extension)) {
            extension = "jar";
        }
        String string = classifier = this.comparisonClassifier != null ? this.comparisonClassifier : this.project.getArtifact().getClassifier();
        if (null != classifier && classifier.trim().length() > 0) {
            return this.finalName + '-' + classifier + '.' + extension;
        }
        return this.finalName + '.' + extension;
    }

    private static String getShortDelta(Delta delta) {
        switch (delta) {
            case ADDED: {
                return "+";
            }
            case CHANGED: {
                return "~";
            }
            case MAJOR: {
                return ">";
            }
            case MICRO: {
                return "0xB5";
            }
            case MINOR: {
                return "<";
            }
            case REMOVED: {
                return "-";
            }
            case UNCHANGED: {
                return " ";
            }
        }
        String deltaString = delta.toString();
        return String.valueOf(deltaString.charAt(0));
    }
}

