/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.obrplugin;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.UnsupportedProtocolException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.WagonException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;

public class RemoteFileManager {
    private Wagon m_wagon;
    private WagonManager m_wagonManager;
    private Settings m_settings;
    private Log m_log;

    public RemoteFileManager(WagonManager wm, Settings settings, Log log) {
        this.m_wagonManager = wm;
        this.m_settings = settings;
        this.m_log = log;
        this.m_wagon = null;
    }

    public void disconnect() {
        try {
            if (this.m_wagon != null) {
                this.m_wagon.disconnect();
            }
        }
        catch (ConnectionException e) {
            this.m_log.error((CharSequence)"Error disconnecting Wagon", (Throwable)e);
        }
    }

    public void connect(String id, String url) throws MojoExecutionException {
        Repository repository = new Repository(id, url);
        try {
            this.m_wagon = this.m_wagonManager.getWagon(repository);
        }
        catch (UnsupportedProtocolException e) {
            throw new MojoExecutionException("Unsupported protocol: '" + repository.getProtocol() + "'", (Exception)((Object)e));
        }
        catch (WagonException e) {
            throw new MojoExecutionException("Unable to configure Wagon: '" + repository.getProtocol() + "'", (Exception)((Object)e));
        }
        try {
            ProxyInfo proxyInfo = RemoteFileManager.getProxyInfo(this.m_settings);
            if (proxyInfo != null) {
                this.m_wagon.connect(repository, this.m_wagonManager.getAuthenticationInfo(id), proxyInfo);
            } else {
                this.m_wagon.connect(repository, this.m_wagonManager.getAuthenticationInfo(id));
            }
        }
        catch (ConnectionException e) {
            throw new MojoExecutionException("Connection failed", (Exception)((Object)e));
        }
        catch (AuthenticationException e) {
            throw new MojoExecutionException("Authentication failed", (Exception)((Object)e));
        }
    }

    public File get(String url, String suffix) throws MojoExecutionException {
        if (this.m_wagon == null) {
            this.m_log.error((CharSequence)"must be connected first!");
            return null;
        }
        File file = null;
        try {
            file = File.createTempFile(String.valueOf(System.currentTimeMillis()), suffix);
        }
        catch (IOException e) {
            throw new MojoExecutionException("I/O problem", (Exception)e);
        }
        try {
            this.m_wagon.get(url, file);
        }
        catch (TransferFailedException e) {
            file.delete();
            throw new MojoExecutionException("Transfer failed", (Exception)((Object)e));
        }
        catch (AuthorizationException e) {
            file.delete();
            throw new MojoExecutionException("Authorization failed", (Exception)((Object)e));
        }
        catch (ResourceDoesNotExistException e) {
            file.delete();
        }
        return file;
    }

    public void put(File file, String url) throws MojoExecutionException {
        if (this.m_wagon == null) {
            this.m_log.error((CharSequence)"must be connected first!");
            return;
        }
        try {
            this.m_wagon.put(file, url);
        }
        catch (TransferFailedException e) {
            throw new MojoExecutionException("Transfer failed", (Exception)((Object)e));
        }
        catch (AuthorizationException e) {
            throw new MojoExecutionException("Authorization failed", (Exception)((Object)e));
        }
        catch (ResourceDoesNotExistException e) {
            throw new MojoExecutionException("Resource does not exist:" + file, (Exception)((Object)e));
        }
    }

    public static ProxyInfo getProxyInfo(Settings settings) {
        ProxyInfo proxyInfo = null;
        if (settings != null && settings.getActiveProxy() != null) {
            Proxy settingsProxy = settings.getActiveProxy();
            proxyInfo = new ProxyInfo();
            proxyInfo.setHost(settingsProxy.getHost());
            proxyInfo.setType(settingsProxy.getProtocol());
            proxyInfo.setPort(settingsProxy.getPort());
            proxyInfo.setNonProxyHosts(settingsProxy.getNonProxyHosts());
            proxyInfo.setUserName(settingsProxy.getUsername());
            proxyInfo.setPassword(settingsProxy.getPassword());
        }
        return proxyInfo;
    }

    public void lockFile(String fileName, boolean ignoreLock) throws MojoExecutionException {
        if (!ignoreLock) {
            int countError = 0;
            while (this.isLockedFile(fileName) && countError < 2) {
                ++countError;
                this.m_log.warn((CharSequence)"File is currently locked, retry in 10s");
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    this.m_log.warn((CharSequence)"Sleep interrupted");
                }
            }
            if (countError == 2) {
                this.m_log.error((CharSequence)("File " + fileName + " is locked. Use -DignoreLock to force uploading"));
                throw new MojoExecutionException("Remote file locked");
            }
        }
        File file = null;
        try {
            file = File.createTempFile(String.valueOf(System.currentTimeMillis()), ".lock");
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            writer.write("LOCKED");
            ((Writer)writer).close();
            this.put(file, fileName + ".lock");
        }
        catch (IOException e) {
            throw new MojoExecutionException("I/O problem", (Exception)e);
        }
        finally {
            if (null != file) {
                file.delete();
            }
        }
    }

    public void unlockFile(String fileName) throws MojoExecutionException {
        File file = null;
        try {
            file = File.createTempFile(String.valueOf(System.currentTimeMillis()), ".lock");
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            writer.write(" ");
            ((Writer)writer).close();
            this.put(file, fileName + ".lock");
        }
        catch (IOException e) {
            throw new MojoExecutionException("I/O problem", (Exception)e);
        }
        finally {
            if (null != file) {
                file.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLockedFile(String fileName) throws MojoExecutionException {
        File file = null;
        try {
            file = this.get(fileName + ".lock", ".lock");
            if (null != file && file.length() <= 2L) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (null != file) {
                file.delete();
            }
        }
        return true;
    }

    public String toString() {
        return this.m_wagon.getRepository().getUrl();
    }
}

