/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.conf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flume.Context;
import org.apache.flume.conf.ComponentConfiguration;
import org.apache.flume.conf.ComponentConfigurationFactory;
import org.apache.flume.conf.ComponentWithClassName;
import org.apache.flume.conf.ConfigFilterFactory;
import org.apache.flume.conf.ConfigurationException;
import org.apache.flume.conf.FlumeConfigurationError;
import org.apache.flume.conf.FlumeConfigurationErrorType;
import org.apache.flume.conf.LogPrivacyUtil;
import org.apache.flume.conf.channel.ChannelConfiguration;
import org.apache.flume.conf.channel.ChannelType;
import org.apache.flume.conf.configfilter.ConfigFilterConfiguration;
import org.apache.flume.conf.configfilter.ConfigFilterType;
import org.apache.flume.conf.sink.SinkConfiguration;
import org.apache.flume.conf.sink.SinkGroupConfiguration;
import org.apache.flume.conf.sink.SinkType;
import org.apache.flume.conf.source.SourceConfiguration;
import org.apache.flume.conf.source.SourceType;
import org.apache.flume.configfilter.ConfigFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlumeConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlumeConfiguration.class);
    private final Map<String, AgentConfiguration> agentConfigMap = new HashMap<String, AgentConfiguration>();
    private final LinkedList<FlumeConfigurationError> errors = new LinkedList();
    public static final String NEWLINE = System.getProperty("line.separator", "\n");
    public static final String INDENTSTEP = "  ";

    @Deprecated
    public FlumeConfiguration(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (this.addRawProperty(entry.getKey().toString(), entry.getValue().toString())) continue;
            LOGGER.warn("Configuration property ignored: {} = {}", entry.getKey(), entry.getValue());
        }
        this.validateConfiguration();
    }

    public FlumeConfiguration(Map<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (this.addRawProperty(entry.getKey(), entry.getValue())) continue;
            LOGGER.warn("Configuration property ignored: {} = {}", (Object)entry.getKey(), (Object)entry.getValue());
        }
        this.validateConfiguration();
    }

    public List<FlumeConfigurationError> getConfigurationErrors() {
        return this.errors;
    }

    public AgentConfiguration getConfigurationFor(String hostname) {
        return this.agentConfigMap.get(hostname);
    }

    private void validateConfiguration() {
        Set<Map.Entry<String, AgentConfiguration>> entries = this.agentConfigMap.entrySet();
        Iterator<Map.Entry<String, AgentConfiguration>> it = entries.iterator();
        while (it.hasNext()) {
            Map.Entry<String, AgentConfiguration> next = it.next();
            String agentName = next.getKey();
            AgentConfiguration aconf = next.getValue();
            if (!aconf.isValid()) {
                LOGGER.warn("Agent configuration invalid for agent '{}'. It will be removed.", (Object)agentName);
                this.addError(agentName, FlumeConfigurationErrorType.AGENT_CONFIGURATION_INVALID, FlumeConfigurationError.ErrorOrWarning.ERROR);
                it.remove();
            }
            LOGGER.debug("Channels:{}\n", (Object)aconf.channels);
            LOGGER.debug("Sinks {}\n", (Object)aconf.sinks);
            LOGGER.debug("Sources {}\n", (Object)aconf.sources);
        }
        LOGGER.info("Post-validation flume configuration contains configuration for agents: {}", this.agentConfigMap.keySet());
    }

    private boolean addRawProperty(String rawName, String rawValue) {
        if (rawName == null || rawValue == null) {
            this.addError("", FlumeConfigurationErrorType.AGENT_NAME_MISSING, FlumeConfigurationError.ErrorOrWarning.ERROR);
            return false;
        }
        String name = rawName.trim();
        String value = rawValue.trim();
        if (value.isEmpty()) {
            this.addError(name, FlumeConfigurationErrorType.PROPERTY_VALUE_NULL, FlumeConfigurationError.ErrorOrWarning.ERROR);
            return false;
        }
        int index = name.indexOf(46);
        if (index == -1) {
            this.addError(name, FlumeConfigurationErrorType.AGENT_NAME_MISSING, FlumeConfigurationError.ErrorOrWarning.ERROR);
            return false;
        }
        String agentName = name.substring(0, index);
        if (agentName.isEmpty()) {
            this.addError(name, FlumeConfigurationErrorType.AGENT_NAME_MISSING, FlumeConfigurationError.ErrorOrWarning.ERROR);
            return false;
        }
        String configKey = name.substring(index + 1);
        if (configKey.isEmpty()) {
            this.addError(name, FlumeConfigurationErrorType.PROPERTY_NAME_NULL, FlumeConfigurationError.ErrorOrWarning.ERROR);
            return false;
        }
        AgentConfiguration aconf = this.agentConfigMap.get(agentName);
        if (aconf == null) {
            aconf = new AgentConfiguration(agentName, this.errors);
            this.agentConfigMap.put(agentName, aconf);
        }
        return aconf.addProperty(configKey, value);
    }

    private void addError(String component, FlumeConfigurationErrorType errorType, FlumeConfigurationError.ErrorOrWarning level) {
        this.errors.add(new FlumeConfigurationError(component, "", errorType, level));
    }

    public static class ComponentNameAndConfigKey {
        private final String componentName;
        private final String configKey;

        private ComponentNameAndConfigKey(String name, String configKey) {
            this.componentName = name;
            this.configKey = configKey;
        }

        public String getComponentName() {
            return this.componentName;
        }

        public String getConfigKey() {
            return this.configKey;
        }
    }

    public static class AgentConfiguration {
        private final String agentName;
        private String configFilters;
        private String sources;
        private String sinks;
        private String channels;
        private String sinkgroups;
        private final Map<String, ComponentConfiguration> sourceConfigMap;
        private final Map<String, ComponentConfiguration> sinkConfigMap;
        private final Map<String, ComponentConfiguration> channelConfigMap;
        private final Map<String, ComponentConfiguration> sinkgroupConfigMap;
        private final Map<String, ComponentConfiguration> configFilterConfigMap;
        private Map<String, Context> configFilterContextMap;
        private Map<String, Context> sourceContextMap;
        private Map<String, Context> sinkContextMap;
        private Map<String, Context> channelContextMap;
        private Map<String, Context> sinkGroupContextMap;
        private Set<String> sinkSet;
        private Set<String> configFilterSet;
        private Set<String> sourceSet;
        private Set<String> channelSet;
        private Set<String> sinkgroupSet;
        private final List<FlumeConfigurationError> errorList;
        private List<ConfigFilter> configFiltersInstances;
        private Map<String, Pattern> configFilterPatternCache;

        private AgentConfiguration(String agentName, List<FlumeConfigurationError> errorList) {
            this.agentName = agentName;
            this.errorList = errorList;
            this.configFilterConfigMap = new HashMap<String, ComponentConfiguration>();
            this.sourceConfigMap = new HashMap<String, ComponentConfiguration>();
            this.sinkConfigMap = new HashMap<String, ComponentConfiguration>();
            this.channelConfigMap = new HashMap<String, ComponentConfiguration>();
            this.sinkgroupConfigMap = new HashMap<String, ComponentConfiguration>();
            this.configFilterContextMap = new HashMap<String, Context>();
            this.sourceContextMap = new HashMap<String, Context>();
            this.sinkContextMap = new HashMap<String, Context>();
            this.channelContextMap = new HashMap<String, Context>();
            this.sinkGroupContextMap = new HashMap<String, Context>();
            this.configFiltersInstances = new ArrayList<ConfigFilter>();
            this.configFilterPatternCache = new HashMap<String, Pattern>();
        }

        public Map<String, ComponentConfiguration> getChannelConfigMap() {
            return this.channelConfigMap;
        }

        public Map<String, ComponentConfiguration> getSourceConfigMap() {
            return this.sourceConfigMap;
        }

        public Map<String, ComponentConfiguration> getConfigFilterConfigMap() {
            return this.configFilterConfigMap;
        }

        public Map<String, ComponentConfiguration> getSinkConfigMap() {
            return this.sinkConfigMap;
        }

        public Map<String, ComponentConfiguration> getSinkGroupConfigMap() {
            return this.sinkgroupConfigMap;
        }

        public Map<String, Context> getConfigFilterContext() {
            return this.configFilterContextMap;
        }

        public Map<String, Context> getSourceContext() {
            return this.sourceContextMap;
        }

        public Map<String, Context> getSinkContext() {
            return this.sinkContextMap;
        }

        public Map<String, Context> getChannelContext() {
            return this.channelContextMap;
        }

        public Set<String> getSinkSet() {
            return this.sinkSet;
        }

        public Set<String> getConfigFilterSet() {
            return this.configFilterSet;
        }

        public Set<String> getSourceSet() {
            return this.sourceSet;
        }

        public Set<String> getChannelSet() {
            return this.channelSet;
        }

        public Set<String> getSinkgroupSet() {
            return this.sinkgroupSet;
        }

        private boolean isValid() {
            LOGGER.debug("Starting validation of configuration for agent: {}", (Object)this.agentName);
            if (LOGGER.isDebugEnabled() && LogPrivacyUtil.allowLogPrintConfig()) {
                LOGGER.debug("Initial configuration: {}", (Object)this.getPrevalidationConfig());
            }
            this.configFilterSet = this.validateConfigFilterSet();
            this.createConfigFilters();
            this.runFiltersThroughConfigs();
            if (this.channels == null || this.channels.trim().isEmpty()) {
                LOGGER.warn("Agent configuration for '{}' does not contain any channels. Marking it as invalid.", (Object)this.agentName);
                this.addError("channels", FlumeConfigurationErrorType.PROPERTY_VALUE_NULL, FlumeConfigurationError.ErrorOrWarning.ERROR);
                return false;
            }
            this.channelSet = new HashSet<String>(Arrays.asList(this.channels.split("\\s+")));
            this.channelSet = this.validateChannels(this.channelSet);
            if (this.channelSet.isEmpty()) {
                LOGGER.warn("Agent configuration for '{}' does not contain any valid channels. Marking it as invalid.", (Object)this.agentName);
                this.addError("channels", FlumeConfigurationErrorType.PROPERTY_VALUE_NULL, FlumeConfigurationError.ErrorOrWarning.ERROR);
                return false;
            }
            this.sourceSet = this.validateSources(this.channelSet);
            this.sinkSet = this.validateSinks(this.channelSet);
            this.sinkgroupSet = this.validateGroups(this.sinkSet);
            if (this.sourceSet.isEmpty() && this.sinkSet.isEmpty()) {
                LOGGER.warn("Agent configuration for '{}' has no sources or sinks. Will be marked invalid.", (Object)this.agentName);
                this.addError("sources", FlumeConfigurationErrorType.PROPERTY_VALUE_NULL, FlumeConfigurationError.ErrorOrWarning.ERROR);
                this.addError("sinks", FlumeConfigurationErrorType.PROPERTY_VALUE_NULL, FlumeConfigurationError.ErrorOrWarning.ERROR);
                return false;
            }
            this.configFilters = this.getSpaceDelimitedList(this.configFilterSet);
            this.sources = this.getSpaceDelimitedList(this.sourceSet);
            this.channels = this.getSpaceDelimitedList(this.channelSet);
            this.sinks = this.getSpaceDelimitedList(this.sinkSet);
            this.sinkgroups = this.getSpaceDelimitedList(this.sinkgroupSet);
            if (LOGGER.isDebugEnabled() && LogPrivacyUtil.allowLogPrintConfig()) {
                LOGGER.debug("Post validation configuration for {}", (Object)this.agentName);
                LOGGER.debug(this.getPostvalidationConfig());
            }
            return true;
        }

        private void runFiltersThroughConfigs() {
            this.runFiltersOnContextMaps(this.sourceContextMap, this.channelContextMap, this.sinkContextMap, this.sinkGroupContextMap);
        }

        private void runFiltersOnContextMaps(Map<String, Context> ... maps) {
            for (Map<String, Context> map : maps) {
                for (Context context : map.values()) {
                    for (String key : context.getParameters().keySet()) {
                        this.filterValue(context, key);
                    }
                }
            }
        }

        private void createConfigFilters() {
            for (String name : this.configFilterSet) {
                Context context = this.configFilterContextMap.get(name);
                ComponentConfiguration componentConfiguration = this.configFilterConfigMap.get(name);
                try {
                    ConfigFilter configFilter;
                    if (context != null) {
                        configFilter = ConfigFilterFactory.create(name, context.getString("type"));
                        configFilter.initializeWithConfiguration(context.getParameters());
                        this.configFiltersInstances.add(configFilter);
                        this.configFilterPatternCache.put(configFilter.getName(), this.createConfigFilterPattern(configFilter));
                        continue;
                    }
                    if (componentConfiguration == null) continue;
                    configFilter = ConfigFilterFactory.create(componentConfiguration.getComponentName(), componentConfiguration.getType());
                    this.configFiltersInstances.add(configFilter);
                    this.configFilterPatternCache.put(configFilter.getName(), this.createConfigFilterPattern(configFilter));
                }
                catch (Exception e) {
                    LOGGER.error("Error while creating config filter {}", (Object)name, (Object)e);
                }
            }
        }

        private Pattern createConfigFilterPattern(ConfigFilter configFilter) {
            return Pattern.compile("\\$\\{" + Pattern.quote(configFilter.getName()) + "\\[(|'|\")(?<key>[-_a-zA-Z0-9]+)\\1\\]\\}");
        }

        private void filterValue(Context c, String contextKey) {
            for (ConfigFilter configFilter : this.configFiltersInstances) {
                try {
                    Pattern pattern = this.configFilterPatternCache.get(configFilter.getName());
                    String currentValue = c.getString(contextKey);
                    Matcher matcher = pattern.matcher(currentValue);
                    String filteredValue = currentValue;
                    while (matcher.find()) {
                        String key = matcher.group("key");
                        LOGGER.debug("Replacing {} from config filter {}", (Object)key, (Object)configFilter.getName());
                        String filtered = configFilter.filter(key);
                        if (filtered == null) continue;
                        String fullMatch = matcher.group();
                        filteredValue = filteredValue.replace(fullMatch, filtered);
                    }
                    c.put(contextKey, filteredValue);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOGGER.error("Error while matching and filtering configFilter: {} and key: {}", new Object[]{configFilter.getName(), contextKey, e});
                }
            }
        }

        private void addError(String key, FlumeConfigurationErrorType errorType, FlumeConfigurationError.ErrorOrWarning level) {
            this.errorList.add(new FlumeConfigurationError(this.agentName, key, errorType, level));
        }

        private ChannelType getKnownChannel(String type) {
            return (ChannelType)this.getKnownComponent(type, ChannelType.values());
        }

        private SinkType getKnownSink(String type) {
            return (SinkType)this.getKnownComponent(type, SinkType.values());
        }

        private SourceType getKnownSource(String type) {
            return (SourceType)this.getKnownComponent(type, SourceType.values());
        }

        private ConfigFilterType getKnownConfigFilter(String type) {
            return (ConfigFilterType)this.getKnownComponent(type, ConfigFilterType.values());
        }

        private <T extends ComponentWithClassName> T getKnownComponent(String type, T[] values) {
            for (T value : values) {
                if (value.toString().equalsIgnoreCase(type)) {
                    return value;
                }
                String src = value.getClassName();
                if (src == null || !src.equalsIgnoreCase(type)) continue;
                return value;
            }
            return null;
        }

        private Set<String> validateChannels(Set<String> channelSet) {
            Iterator<String> iter = channelSet.iterator();
            HashMap<String, Context> newContextMap = new HashMap<String, Context>();
            ChannelConfiguration conf = null;
            while (iter.hasNext()) {
                String channelName = iter.next();
                Context channelContext = this.channelContextMap.get(channelName);
                if (channelContext != null) {
                    ChannelType chType = this.getKnownChannel(channelContext.getString("type"));
                    boolean configSpecified = false;
                    String config = null;
                    if (chType == null) {
                        config = channelContext.getString("config");
                        if (config == null || config.isEmpty()) {
                            config = "OTHER";
                        } else {
                            configSpecified = true;
                        }
                    } else {
                        config = chType.toString().toUpperCase(Locale.ENGLISH);
                        configSpecified = true;
                    }
                    try {
                        conf = (ChannelConfiguration)ComponentConfigurationFactory.create(channelName, config, ComponentConfiguration.ComponentType.CHANNEL);
                        LOGGER.debug("Created channel {}", (Object)channelName);
                        if (conf != null) {
                            conf.configure(channelContext);
                        }
                        if (configSpecified && conf.isNotFoundConfigClass() || !configSpecified) {
                            newContextMap.put(channelName, channelContext);
                        } else if (configSpecified) {
                            this.channelConfigMap.put(channelName, conf);
                        }
                        if (conf == null) continue;
                        this.errorList.addAll(conf.getErrors());
                    }
                    catch (ConfigurationException e) {
                        if (conf != null) {
                            this.errorList.addAll(conf.getErrors());
                        }
                        iter.remove();
                        LOGGER.warn("Could not configure channel {} due to: {}", new Object[]{channelName, e.getMessage(), e});
                    }
                    continue;
                }
                iter.remove();
                this.addError(channelName, FlumeConfigurationErrorType.CONFIG_ERROR, FlumeConfigurationError.ErrorOrWarning.ERROR);
            }
            this.channelContextMap = newContextMap;
            HashSet<String> tempchannelSet = new HashSet<String>();
            tempchannelSet.addAll(this.channelConfigMap.keySet());
            tempchannelSet.addAll(this.channelContextMap.keySet());
            channelSet.retainAll(tempchannelSet);
            return channelSet;
        }

        private Set<String> validateConfigFilterSet() {
            if (this.configFilters == null || this.configFilters.isEmpty()) {
                LOGGER.warn("Agent configuration for '{}' has no configfilters.", (Object)this.agentName);
                return new HashSet<String>();
            }
            HashSet<String> configFilterSet = new HashSet<String>(Arrays.asList(this.configFilters.split("\\s+")));
            HashMap<String, Context> newContextMap = new HashMap<String, Context>();
            Iterator iter = configFilterSet.iterator();
            ConfigFilterConfiguration conf = null;
            while (iter.hasNext()) {
                String configFilterName = (String)iter.next();
                Context configFilterContext = this.configFilterContextMap.get(configFilterName);
                if (configFilterContext != null) {
                    ConfigFilterType chType = this.getKnownConfigFilter(configFilterContext.getString("type"));
                    boolean configSpecified = false;
                    String config = null;
                    if (chType == null) {
                        config = configFilterContext.getString("config");
                        if (config == null || config.isEmpty()) {
                            config = "OTHER";
                        } else {
                            configSpecified = true;
                        }
                    } else {
                        config = chType.toString().toUpperCase(Locale.ENGLISH);
                        configSpecified = true;
                    }
                    try {
                        conf = (ConfigFilterConfiguration)ComponentConfigurationFactory.create(configFilterName, config, ComponentConfiguration.ComponentType.CONFIG_FILTER);
                        LOGGER.debug("Created configfilter {}", (Object)configFilterName);
                        if (conf != null) {
                            conf.configure(configFilterContext);
                        }
                        if (configSpecified && conf.isNotFoundConfigClass() || !configSpecified) {
                            newContextMap.put(configFilterName, configFilterContext);
                        } else if (configSpecified) {
                            this.configFilterConfigMap.put(configFilterName, conf);
                        }
                        if (conf == null) continue;
                        this.errorList.addAll(conf.getErrors());
                    }
                    catch (ConfigurationException e) {
                        if (conf != null) {
                            this.errorList.addAll(conf.getErrors());
                        }
                        iter.remove();
                        LOGGER.warn("Could not configure configfilter {} due to: {}", new Object[]{configFilterName, e.getMessage(), e});
                    }
                    continue;
                }
                iter.remove();
                this.addError(configFilterName, FlumeConfigurationErrorType.CONFIG_ERROR, FlumeConfigurationError.ErrorOrWarning.ERROR);
                LOGGER.warn("Configuration empty for: {}. Removed.", (Object)configFilterName);
            }
            this.configFilterContextMap = newContextMap;
            HashSet<String> tempchannelSet = new HashSet<String>();
            tempchannelSet.addAll(this.configFilterConfigMap.keySet());
            tempchannelSet.addAll(this.configFilterContextMap.keySet());
            configFilterSet.retainAll(tempchannelSet);
            return configFilterSet;
        }

        private Set<String> validateSources(Set<String> channelSet) {
            if (this.sources == null || this.sources.isEmpty()) {
                LOGGER.warn("Agent configuration for '{}' has no sources.", (Object)this.agentName);
                this.addError("sources", FlumeConfigurationErrorType.PROPERTY_VALUE_NULL, FlumeConfigurationError.ErrorOrWarning.WARNING);
                return new HashSet<String>();
            }
            HashSet<String> sourceSet = new HashSet<String>(Arrays.asList(this.sources.split("\\s+")));
            HashMap<String, Context> newContextMap = new HashMap<String, Context>();
            Iterator iter = sourceSet.iterator();
            SourceConfiguration srcConf = null;
            while (iter.hasNext()) {
                String sourceName = (String)iter.next();
                Context srcContext = this.sourceContextMap.get(sourceName);
                String config = null;
                boolean configSpecified = false;
                if (srcContext != null) {
                    SourceType srcType = this.getKnownSource(srcContext.getString("type"));
                    if (srcType == null) {
                        config = srcContext.getString("config");
                        if (config == null || config.isEmpty()) {
                            config = "OTHER";
                        } else {
                            configSpecified = true;
                        }
                    } else {
                        config = srcType.toString().toUpperCase(Locale.ENGLISH);
                        configSpecified = true;
                    }
                    try {
                        srcConf = (SourceConfiguration)ComponentConfigurationFactory.create(sourceName, config, ComponentConfiguration.ComponentType.SOURCE);
                        if (srcConf != null) {
                            srcConf.configure(srcContext);
                            HashSet<String> channels = new HashSet<String>();
                            if (srcConf.getChannels() != null) {
                                channels.addAll(srcConf.getChannels());
                            }
                            channels.retainAll(channelSet);
                            if (channels.isEmpty()) {
                                throw new ConfigurationException("No Channels configured for " + sourceName);
                            }
                            srcContext.put("channels", this.getSpaceDelimitedList(channels));
                        }
                        if (configSpecified && srcConf.isNotFoundConfigClass() || !configSpecified) {
                            newContextMap.put(sourceName, srcContext);
                        } else if (configSpecified) {
                            this.sourceConfigMap.put(sourceName, srcConf);
                        }
                        if (srcConf == null) continue;
                        this.errorList.addAll(srcConf.getErrors());
                    }
                    catch (ConfigurationException e) {
                        if (srcConf != null) {
                            this.errorList.addAll(srcConf.getErrors());
                        }
                        iter.remove();
                        LOGGER.warn("Could not configure source  {} due to: {}", new Object[]{sourceName, e.getMessage(), e});
                    }
                    continue;
                }
                iter.remove();
                this.addError(sourceName, FlumeConfigurationErrorType.CONFIG_ERROR, FlumeConfigurationError.ErrorOrWarning.ERROR);
                LOGGER.warn("Configuration empty for: {}.Removed.", (Object)sourceName);
            }
            this.sourceContextMap = newContextMap;
            HashSet<String> tempsourceSet = new HashSet<String>();
            tempsourceSet.addAll(this.sourceContextMap.keySet());
            tempsourceSet.addAll(this.sourceConfigMap.keySet());
            sourceSet.retainAll(tempsourceSet);
            return sourceSet;
        }

        private Set<String> validateSinks(Set<String> channelSet) {
            HashMap<String, Context> newContextMap = new HashMap<String, Context>();
            ComponentConfiguration sinkConf = null;
            if (this.sinks == null || this.sinks.isEmpty()) {
                LOGGER.warn("Agent configuration for '{}' has no sinks.", (Object)this.agentName);
                this.addError("sinks", FlumeConfigurationErrorType.PROPERTY_VALUE_NULL, FlumeConfigurationError.ErrorOrWarning.WARNING);
                return new HashSet<String>();
            }
            HashSet<String> sinkSet = new HashSet<String>(Arrays.asList(this.sinks.split("\\s+")));
            Iterator iter = sinkSet.iterator();
            while (iter.hasNext()) {
                String sinkName = (String)iter.next();
                Context sinkContext = this.sinkContextMap.get(sinkName.trim());
                if (sinkContext == null) {
                    iter.remove();
                    LOGGER.warn("no context for sink{}", (Object)sinkName);
                    this.addError(sinkName, FlumeConfigurationErrorType.CONFIG_ERROR, FlumeConfigurationError.ErrorOrWarning.ERROR);
                    continue;
                }
                String config = null;
                boolean configSpecified = false;
                SinkType sinkType = this.getKnownSink(sinkContext.getString("type"));
                if (sinkType == null) {
                    config = sinkContext.getString("config");
                    if (config == null || config.isEmpty()) {
                        config = "OTHER";
                    } else {
                        configSpecified = true;
                    }
                } else {
                    config = sinkType.toString().toUpperCase(Locale.ENGLISH);
                    configSpecified = true;
                }
                try {
                    LOGGER.debug("Creating sink: {} using {}", (Object)sinkName, (Object)config);
                    sinkConf = (SinkConfiguration)ComponentConfigurationFactory.create(sinkName, config, ComponentConfiguration.ComponentType.SINK);
                    if (sinkConf != null) {
                        ((SinkConfiguration)sinkConf).configure(sinkContext);
                    }
                    if (!channelSet.contains(((SinkConfiguration)sinkConf).getChannel())) {
                        throw new ConfigurationException("Channel " + ((SinkConfiguration)sinkConf).getChannel() + " not in active set.");
                    }
                    if (configSpecified && sinkConf.isNotFoundConfigClass() || !configSpecified) {
                        newContextMap.put(sinkName, sinkContext);
                    } else if (configSpecified) {
                        this.sinkConfigMap.put(sinkName, sinkConf);
                    }
                    if (sinkConf == null) continue;
                    this.errorList.addAll(sinkConf.getErrors());
                }
                catch (ConfigurationException e) {
                    iter.remove();
                    if (sinkConf != null) {
                        this.errorList.addAll(sinkConf.getErrors());
                    }
                    LOGGER.warn("Could not configure sink  {} due to: {}", new Object[]{sinkName, e.getMessage(), e});
                }
            }
            this.sinkContextMap = newContextMap;
            HashSet<String> tempSinkset = new HashSet<String>();
            tempSinkset.addAll(this.sinkConfigMap.keySet());
            tempSinkset.addAll(this.sinkContextMap.keySet());
            sinkSet.retainAll(tempSinkset);
            return sinkSet;
        }

        private Set<String> validateGroups(Set<String> sinkSet) {
            Set<String> sinkgroupSet = AgentConfiguration.stringToSet(this.sinkgroups, " ");
            HashMap<String, String> usedSinks = new HashMap<String, String>();
            Iterator<String> iter = sinkgroupSet.iterator();
            while (iter.hasNext()) {
                String sinkgroupName = iter.next();
                Context context = this.sinkGroupContextMap.get(sinkgroupName);
                if (context != null) {
                    try {
                        SinkGroupConfiguration conf = (SinkGroupConfiguration)ComponentConfigurationFactory.create(sinkgroupName, "sinkgroup", ComponentConfiguration.ComponentType.SINKGROUP);
                        conf.configure(context);
                        Set<String> groupSinks = this.validGroupSinks(sinkSet, usedSinks, conf);
                        if (conf != null) {
                            this.errorList.addAll(conf.getErrors());
                        }
                        if (groupSinks != null && !groupSinks.isEmpty()) {
                            ArrayList<String> sinkArray = new ArrayList<String>();
                            sinkArray.addAll(groupSinks);
                            conf.setSinks(sinkArray);
                            this.sinkgroupConfigMap.put(sinkgroupName, conf);
                            continue;
                        }
                        this.addError(sinkgroupName, FlumeConfigurationErrorType.CONFIG_ERROR, FlumeConfigurationError.ErrorOrWarning.ERROR);
                        if (conf != null) {
                            this.errorList.addAll(conf.getErrors());
                        }
                        throw new ConfigurationException("No available sinks for sinkgroup: " + sinkgroupName + ". Sinkgroup will be removed");
                    }
                    catch (ConfigurationException e) {
                        iter.remove();
                        this.addError(sinkgroupName, FlumeConfigurationErrorType.CONFIG_ERROR, FlumeConfigurationError.ErrorOrWarning.ERROR);
                        LOGGER.warn("Could not configure sink group {} due to: {}", new Object[]{sinkgroupName, e.getMessage(), e});
                        continue;
                    }
                }
                iter.remove();
                this.addError(sinkgroupName, FlumeConfigurationErrorType.CONFIG_ERROR, FlumeConfigurationError.ErrorOrWarning.ERROR);
                LOGGER.warn("Configuration error for: {}.Removed.", (Object)sinkgroupName);
            }
            sinkgroupSet.retainAll(this.sinkgroupConfigMap.keySet());
            return sinkgroupSet;
        }

        private Set<String> validGroupSinks(Set<String> sinkSet, Map<String, String> usedSinks, SinkGroupConfiguration groupConf) {
            Set<String> groupSinks = Collections.synchronizedSet(new HashSet<String>(groupConf.getSinks()));
            if (groupSinks.isEmpty()) {
                return null;
            }
            Iterator<String> sinkIt = groupSinks.iterator();
            while (sinkIt.hasNext()) {
                String curSink = sinkIt.next();
                if (usedSinks.containsKey(curSink)) {
                    LOGGER.warn("Agent configuration for '{}' sinkgroup '{}' sink '{}' in use by another group: '{}', sink not added", new Object[]{this.agentName, groupConf.getComponentName(), curSink, usedSinks.get(curSink)});
                    this.addError(groupConf.getComponentName(), FlumeConfigurationErrorType.PROPERTY_PART_OF_ANOTHER_GROUP, FlumeConfigurationError.ErrorOrWarning.ERROR);
                    sinkIt.remove();
                    continue;
                }
                if (!sinkSet.contains(curSink)) {
                    LOGGER.warn("Agent configuration for '{}' sinkgroup '{}' sink not found: '{}',  sink not added", new Object[]{this.agentName, groupConf.getComponentName(), curSink});
                    this.addError(curSink, FlumeConfigurationErrorType.INVALID_PROPERTY, FlumeConfigurationError.ErrorOrWarning.ERROR);
                    sinkIt.remove();
                    continue;
                }
                usedSinks.put(curSink, groupConf.getComponentName());
            }
            return groupSinks;
        }

        private String getSpaceDelimitedList(Set<String> entries) {
            if (entries.isEmpty()) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            for (String entry : entries) {
                sb.append(" ").append(entry);
            }
            return sb.toString().trim();
        }

        private static Set<String> stringToSet(String target, String delim) {
            HashSet<String> out = new HashSet<String>();
            if (target == null || target.trim().length() == 0) {
                return out;
            }
            StringTokenizer t = new StringTokenizer(target, delim);
            while (t.hasMoreTokens()) {
                out.add(t.nextToken());
            }
            return out;
        }

        public String getPrevalidationConfig() {
            StringBuilder sb = new StringBuilder("AgentConfiguration[");
            sb.append(this.agentName).append("]").append(NEWLINE);
            sb.append("CONFIG_FILTERS: ").append(this.configFilterContextMap).append(NEWLINE);
            sb.append("SOURCES: ").append(this.sourceContextMap).append(NEWLINE);
            sb.append("CHANNELS: ").append(this.channelContextMap).append(NEWLINE);
            sb.append("SINKS: ").append(this.sinkContextMap).append(NEWLINE);
            return sb.toString();
        }

        public String getPostvalidationConfig() {
            StringBuilder sb = new StringBuilder("AgentConfiguration created without Configuration stubs for which only basic syntactical validation was performed[");
            sb.append(this.agentName).append("]").append(NEWLINE);
            if (!(this.sourceContextMap.isEmpty() && this.sinkContextMap.isEmpty() && this.channelContextMap.isEmpty())) {
                if (!this.sourceContextMap.isEmpty()) {
                    sb.append("SOURCES: ").append(this.sourceContextMap).append(NEWLINE);
                }
                if (!this.channelContextMap.isEmpty()) {
                    sb.append("CHANNELS: ").append(this.channelContextMap).append(NEWLINE);
                }
                if (!this.sinkContextMap.isEmpty()) {
                    sb.append("SINKS: ").append(this.sinkContextMap).append(NEWLINE);
                }
            }
            if (!(this.sourceConfigMap.isEmpty() && this.sinkConfigMap.isEmpty() && this.channelConfigMap.isEmpty())) {
                sb.append("AgentConfiguration created with Configuration stubs for which full validation was performed[");
                sb.append(this.agentName).append("]").append(NEWLINE);
                if (!this.sourceConfigMap.isEmpty()) {
                    sb.append("SOURCES: ").append(this.sourceConfigMap).append(NEWLINE);
                }
                if (!this.channelConfigMap.isEmpty()) {
                    sb.append("CHANNELS: ").append(this.channelConfigMap).append(NEWLINE);
                }
                if (!this.sinkConfigMap.isEmpty()) {
                    sb.append("SINKS: ").append(this.sinkConfigMap).append(NEWLINE);
                }
            }
            return sb.toString();
        }

        private boolean addProperty(String key, String value) {
            if ("configfilters".equals(key)) {
                if (this.configFilters == null) {
                    this.configFilters = value;
                    return true;
                }
                LOGGER.warn("Duplicate configfilter list specified for agent: {}", (Object)this.agentName);
                this.addError("configfilters", FlumeConfigurationErrorType.DUPLICATE_PROPERTY, FlumeConfigurationError.ErrorOrWarning.ERROR);
                return false;
            }
            if ("sources".equals(key)) {
                if (this.sources == null) {
                    this.sources = value;
                    return true;
                }
                LOGGER.warn("Duplicate source list specified for agent: {}", (Object)this.agentName);
                this.addError("sources", FlumeConfigurationErrorType.DUPLICATE_PROPERTY, FlumeConfigurationError.ErrorOrWarning.ERROR);
                return false;
            }
            if ("sinks".equals(key)) {
                if (this.sinks == null) {
                    this.sinks = value;
                    LOGGER.info("Added sinks: {} Agent: {}", (Object)this.sinks, (Object)this.agentName);
                    return true;
                }
                LOGGER.warn("Duplicate sink list specfied for agent: {}", (Object)this.agentName);
                this.addError("sinks", FlumeConfigurationErrorType.DUPLICATE_PROPERTY, FlumeConfigurationError.ErrorOrWarning.ERROR);
                return false;
            }
            if ("channels".equals(key)) {
                if (this.channels == null) {
                    this.channels = value;
                    return true;
                }
                LOGGER.warn("Duplicate channel list specified for agent: {}", (Object)this.agentName);
                this.addError("channels", FlumeConfigurationErrorType.DUPLICATE_PROPERTY, FlumeConfigurationError.ErrorOrWarning.ERROR);
                return false;
            }
            if ("sinkgroups".equals(key)) {
                if (this.sinkgroups == null) {
                    this.sinkgroups = value;
                    return true;
                }
                LOGGER.warn("Duplicate sinkgroup list specfied for agent: {}", (Object)this.agentName);
                this.addError("sinkgroups", FlumeConfigurationErrorType.DUPLICATE_PROPERTY, FlumeConfigurationError.ErrorOrWarning.ERROR);
                return false;
            }
            if (this.addAsSourceConfig(key, value) || this.addAsChannelValue(key, value) || this.addAsSinkConfig(key, value) || this.addAsSinkGroupConfig(key, value) || this.addAsConfigFilterConfig(key, value)) {
                return true;
            }
            LOGGER.warn("Invalid property specified: {}", (Object)key);
            this.addError(key, FlumeConfigurationErrorType.INVALID_PROPERTY, FlumeConfigurationError.ErrorOrWarning.ERROR);
            return false;
        }

        private boolean addAsConfigFilterConfig(String key, String value) {
            return this.addComponentConfig(key, value, "configfilters.", this.configFilterContextMap);
        }

        private boolean addAsSinkGroupConfig(String key, String value) {
            return this.addComponentConfig(key, value, "sinkgroups.", this.sinkGroupContextMap);
        }

        private boolean addAsSinkConfig(String key, String value) {
            return this.addComponentConfig(key, value, "sinks.", this.sinkContextMap);
        }

        private boolean addAsChannelValue(String key, String value) {
            return this.addComponentConfig(key, value, "channels.", this.channelContextMap);
        }

        private boolean addAsSourceConfig(String key, String value) {
            return this.addComponentConfig(key, value, "sources.", this.sourceContextMap);
        }

        private boolean addComponentConfig(String key, String value, String configPrefix, Map<String, Context> contextMap) {
            ComponentNameAndConfigKey parsed = this.parseConfigKey(key, configPrefix);
            if (parsed != null) {
                String name = parsed.getComponentName().trim();
                LOGGER.info("Processing:{}", (Object)name);
                Context context = contextMap.get(name);
                if (context == null) {
                    LOGGER.debug("Created context for {}: {}", (Object)name, (Object)parsed.getConfigKey());
                    context = new Context();
                    contextMap.put(name, context);
                }
                context.put(parsed.getConfigKey(), value);
                return true;
            }
            return false;
        }

        private ComponentNameAndConfigKey parseConfigKey(String key, String prefix) {
            if (!key.startsWith(prefix)) {
                return null;
            }
            int index = key.indexOf(46, prefix.length() + 1);
            if (index == -1) {
                return null;
            }
            String name = key.substring(prefix.length(), index);
            String configKey = key.substring(prefix.length() + name.length() + 1);
            if (name.isEmpty() || configKey.isEmpty()) {
                return null;
            }
            return new ComponentNameAndConfigKey(name, configKey);
        }
    }
}

