/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authorize;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.ImpersonationProvider;
import org.apache.hadoop.util.MachineList;

public class DefaultImpersonationProvider
implements ImpersonationProvider {
    private static final String CONF_HOSTS = ".hosts";
    private static final String CONF_USERS = ".users";
    private static final String CONF_GROUPS = ".groups";
    private static final String CONF_HADOOP_PROXYUSER = "hadoop.proxyuser.";
    private static final String CONF_HADOOP_PROXYUSER_RE = "hadoop\\.proxyuser\\.";
    private static final String CONF_HADOOP_PROXYUSER_RE_USERS_GROUPS = "hadoop\\.proxyuser\\.[^.]*(" + Pattern.quote(".users") + "|" + Pattern.quote(".groups") + ")";
    private static final String CONF_HADOOP_PROXYUSER_RE_HOSTS = "hadoop\\.proxyuser\\.[^.]*" + Pattern.quote(".hosts");
    private Map<String, AccessControlList> proxyUserAcl = new HashMap<String, AccessControlList>();
    private static Map<String, MachineList> proxyHosts = new HashMap<String, MachineList>();
    private Configuration conf;

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
        Map<String, String> allMatchKeys = conf.getValByRegex(CONF_HADOOP_PROXYUSER_RE_USERS_GROUPS);
        for (Map.Entry<String, String> entry : allMatchKeys.entrySet()) {
            String aclKey = this.getAclKey(entry.getKey());
            if (this.proxyUserAcl.containsKey(aclKey)) continue;
            this.proxyUserAcl.put(aclKey, new AccessControlList(allMatchKeys.get(aclKey + CONF_USERS), allMatchKeys.get(aclKey + CONF_GROUPS)));
        }
        allMatchKeys = conf.getValByRegex(CONF_HADOOP_PROXYUSER_RE_HOSTS);
        for (Map.Entry<String, String> entry : allMatchKeys.entrySet()) {
            proxyHosts.put(entry.getKey(), new MachineList(entry.getValue()));
        }
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void authorize(UserGroupInformation user, String remoteAddress) throws AuthorizationException {
        UserGroupInformation realUser = user.getRealUser();
        if (realUser == null) {
            return;
        }
        AccessControlList acl = this.proxyUserAcl.get(CONF_HADOOP_PROXYUSER + realUser.getShortUserName());
        if (acl == null || !acl.isUserAllowed(user)) {
            throw new AuthorizationException("User: " + realUser.getUserName() + " is not allowed to impersonate " + user.getUserName());
        }
        MachineList MachineList2 = proxyHosts.get(DefaultImpersonationProvider.getProxySuperuserIpConfKey(realUser.getShortUserName()));
        if (!MachineList2.includes(remoteAddress)) {
            throw new AuthorizationException("Unauthorized connection for super-user: " + realUser.getUserName() + " from IP " + remoteAddress);
        }
    }

    private String getAclKey(String key) {
        int endIndex = key.lastIndexOf(".");
        if (endIndex != -1) {
            return key.substring(0, endIndex);
        }
        return key;
    }

    public static String getProxySuperuserUserConfKey(String userName) {
        return CONF_HADOOP_PROXYUSER + userName + CONF_USERS;
    }

    public static String getProxySuperuserGroupConfKey(String userName) {
        return CONF_HADOOP_PROXYUSER + userName + CONF_GROUPS;
    }

    public static String getProxySuperuserIpConfKey(String userName) {
        return CONF_HADOOP_PROXYUSER + userName + CONF_HOSTS;
    }

    @VisibleForTesting
    public Map<String, Collection<String>> getProxyGroups() {
        HashMap<String, Collection<String>> proxyGroups = new HashMap<String, Collection<String>>();
        for (Map.Entry<String, AccessControlList> entry : this.proxyUserAcl.entrySet()) {
            proxyGroups.put(entry.getKey() + CONF_GROUPS, entry.getValue().getGroups());
        }
        return proxyGroups;
    }

    @VisibleForTesting
    public Map<String, Collection<String>> getProxyHosts() {
        HashMap<String, Collection<String>> tmpProxyHosts = new HashMap<String, Collection<String>>();
        for (Map.Entry<String, MachineList> proxyHostEntry : proxyHosts.entrySet()) {
            tmpProxyHosts.put(proxyHostEntry.getKey(), proxyHostEntry.getValue().getCollection());
        }
        return tmpProxyHosts;
    }
}

