/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockType;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockIdManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.util.StripedBlockUtil;

@InterfaceAudience.Private
public class BlockInfoStriped
extends BlockInfo {
    private final ErasureCodingPolicy ecPolicy;
    private byte[] indices;

    public BlockInfoStriped(Block blk, ErasureCodingPolicy ecPolicy) {
        super(blk, (short)(ecPolicy.getNumDataUnits() + ecPolicy.getNumParityUnits()));
        this.indices = new byte[ecPolicy.getNumDataUnits() + ecPolicy.getNumParityUnits()];
        this.initIndices();
        this.ecPolicy = ecPolicy;
    }

    public short getTotalBlockNum() {
        return (short)(this.ecPolicy.getNumDataUnits() + this.ecPolicy.getNumParityUnits());
    }

    public short getDataBlockNum() {
        return (short)this.ecPolicy.getNumDataUnits();
    }

    public short getParityBlockNum() {
        return (short)this.ecPolicy.getNumParityUnits();
    }

    public int getCellSize() {
        return this.ecPolicy.getCellSize();
    }

    public short getRealDataBlockNum() {
        if (this.isComplete() || this.getBlockUCState() == HdfsServerConstants.BlockUCState.COMMITTED) {
            return (short)Math.min((long)this.getDataBlockNum(), (this.getNumBytes() - 1L) / (long)this.ecPolicy.getCellSize() + 1L);
        }
        return this.getDataBlockNum();
    }

    public short getRealTotalBlockNum() {
        return (short)(this.getRealDataBlockNum() + this.getParityBlockNum());
    }

    public ErasureCodingPolicy getErasureCodingPolicy() {
        return this.ecPolicy;
    }

    private void initIndices() {
        for (int i = 0; i < this.indices.length; ++i) {
            this.indices[i] = -1;
        }
    }

    private int findSlot() {
        int i;
        for (i = this.getTotalBlockNum(); i < this.getCapacity(); ++i) {
            if (this.getStorageInfo(i) != null) continue;
            return i;
        }
        this.ensureCapacity(i + 1, true);
        return i;
    }

    @Override
    boolean addStorage(DatanodeStorageInfo storage, Block reportedBlock) {
        int blockIndex;
        Preconditions.checkArgument((boolean)BlockIdManager.isStripedBlockID(reportedBlock.getBlockId()), (Object)"reportedBlock is not striped");
        Preconditions.checkArgument((BlockIdManager.convertToStripedID(reportedBlock.getBlockId()) == this.getBlockId() ? 1 : 0) != 0, (String)"reported blk_%s does not belong to the group of stored blk_%s", (long)reportedBlock.getBlockId(), (long)this.getBlockId());
        int index = blockIndex = BlockIdManager.getBlockIndex(reportedBlock);
        DatanodeStorageInfo old = this.getStorageInfo(index);
        if (old != null && !old.equals(storage)) {
            int i = this.findStorageInfo(storage);
            if (i == -1) {
                index = this.findSlot();
            } else {
                return true;
            }
        }
        this.addStorage(storage, index, blockIndex);
        return true;
    }

    private void addStorage(DatanodeStorageInfo storage, int index, int blockIndex) {
        this.setStorageInfo(index, storage);
        this.setNext(index, null);
        this.setPrevious(index, null);
        this.indices[index] = (byte)blockIndex;
    }

    private int findStorageInfoFromEnd(DatanodeStorageInfo storage) {
        int len = this.getCapacity();
        for (int idx = len - 1; idx >= 0; --idx) {
            DatanodeStorageInfo cur = this.getStorageInfo(idx);
            if (!storage.equals(cur)) continue;
            return idx;
        }
        return -1;
    }

    @VisibleForTesting
    public byte getStorageBlockIndex(DatanodeStorageInfo storage) {
        int i = this.findStorageInfo(storage);
        return i == -1 ? (byte)-1 : this.indices[i];
    }

    Block getBlockOnStorage(DatanodeStorageInfo storage) {
        byte index = this.getStorageBlockIndex(storage);
        if (index < 0) {
            return null;
        }
        Block block = new Block((Block)this);
        block.setBlockId(this.getBlockId() + (long)index);
        return block;
    }

    @Override
    boolean removeStorage(DatanodeStorageInfo storage) {
        int dnIndex = this.findStorageInfoFromEnd(storage);
        if (dnIndex < 0) {
            return false;
        }
        assert (this.getPrevious(dnIndex) == null && this.getNext(dnIndex) == null) : "Block is still in the list and must be removed first.";
        this.setStorageInfo(dnIndex, null);
        this.setNext(dnIndex, null);
        this.setPrevious(dnIndex, null);
        this.indices[dnIndex] = -1;
        return true;
    }

    private void ensureCapacity(int totalSize, boolean keepOld) {
        if (this.getCapacity() < totalSize) {
            Object[] old = this.triplets;
            byte[] oldIndices = this.indices;
            this.triplets = new Object[totalSize * 3];
            this.indices = new byte[totalSize];
            this.initIndices();
            if (keepOld) {
                System.arraycopy(old, 0, this.triplets, 0, old.length);
                System.arraycopy(oldIndices, 0, this.indices, 0, oldIndices.length);
            }
        }
    }

    public long spaceConsumed() {
        return StripedBlockUtil.spaceConsumedByStripedBlock((long)this.getNumBytes(), (int)this.ecPolicy.getNumDataUnits(), (int)this.ecPolicy.getNumParityUnits(), (int)this.ecPolicy.getCellSize());
    }

    @Override
    public final boolean isStriped() {
        return true;
    }

    @Override
    public BlockType getBlockType() {
        return BlockType.STRIPED;
    }

    @Override
    public int numNodes() {
        assert (this.triplets != null) : "BlockInfo is not initialized";
        assert (this.triplets.length % 3 == 0) : "Malformed BlockInfo";
        int num = 0;
        for (int idx = this.getCapacity() - 1; idx >= 0; --idx) {
            if (this.getStorageInfo(idx) == null) continue;
            ++num;
        }
        return num;
    }

    @Override
    final boolean hasNoStorage() {
        int len = this.getCapacity();
        for (int idx = 0; idx < len; ++idx) {
            if (this.getStorageInfo(idx) == null) continue;
            return false;
        }
        return true;
    }

    public Iterable<StorageAndBlockIndex> getStorageAndIndexInfos() {
        return new Iterable<StorageAndBlockIndex>(){

            @Override
            public Iterator<StorageAndBlockIndex> iterator() {
                return new Iterator<StorageAndBlockIndex>(){
                    private int index = 0;

                    @Override
                    public boolean hasNext() {
                        while (this.index < BlockInfoStriped.this.getCapacity() && BlockInfoStriped.this.getStorageInfo(this.index) == null) {
                            ++this.index;
                        }
                        return this.index < BlockInfoStriped.this.getCapacity();
                    }

                    @Override
                    public StorageAndBlockIndex next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        int i = this.index++;
                        return new StorageAndBlockIndex((DatanodeStorageInfo)BlockInfoStriped.this.triplets[i * 3], BlockInfoStriped.this.indices[i]);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Remove is not supported");
                    }
                };
            }
        };
    }

    public static class StorageAndBlockIndex {
        private final DatanodeStorageInfo storage;
        private final byte blockIndex;

        StorageAndBlockIndex(DatanodeStorageInfo storage, byte blockIndex) {
            this.storage = storage;
            this.blockIndex = blockIndex;
        }

        public DatanodeStorageInfo getStorage() {
            return this.storage;
        }

        public byte getBlockIndex() {
            return this.blockIndex;
        }
    }
}

