/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.RetryingCallable;
import org.apache.hadoop.hbase.exceptions.RegionMovedException;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;

@InterfaceAudience.Private
public abstract class RegionAdminServiceCallable<T>
implements RetryingCallable<T> {
    protected final ClusterConnection connection;
    protected AdminProtos.AdminService.BlockingInterface stub;
    protected HRegionLocation location;
    protected final TableName tableName;
    protected final byte[] row;
    protected static final int MIN_WAIT_DEAD_SERVER = 10000;

    public RegionAdminServiceCallable(ClusterConnection connection, TableName tableName, byte[] row) {
        this(connection, null, tableName, row);
    }

    public RegionAdminServiceCallable(ClusterConnection connection, HRegionLocation location, TableName tableName, byte[] row) {
        this.connection = connection;
        this.location = location;
        this.tableName = tableName;
        this.row = row;
    }

    @Override
    public void prepare(boolean reload) throws IOException {
        if (Thread.interrupted()) {
            throw new InterruptedIOException();
        }
        if (reload || this.location == null) {
            this.location = this.getLocation(!reload);
        }
        if (this.location == null) {
            throw new HBaseIOException(this.getExceptionMessage());
        }
        this.setStub(this.connection.getAdmin(this.location.getServerName()));
    }

    protected void setStub(AdminProtos.AdminService.BlockingInterface stub) {
        this.stub = stub;
    }

    public abstract HRegionLocation getLocation(boolean var1) throws IOException;

    @Override
    public void throwable(Throwable t, boolean retrying) {
        if (t instanceof SocketTimeoutException || t instanceof ConnectException || t instanceof RetriesExhaustedException || this.location != null && this.getConnection().isDeadServer(this.location.getServerName())) {
            if (this.location != null) {
                this.getConnection().clearCaches(this.location.getServerName());
            }
        } else if (t instanceof RegionMovedException) {
            this.getConnection().updateCachedLocations(this.tableName, this.row, (Object)t, this.location);
        } else if (t instanceof NotServingRegionException) {
            this.getConnection().deleteCachedRegionLocation(this.location);
        }
    }

    HConnection getConnection() {
        return this.connection;
    }

    protected String getExceptionMessage() {
        return "There is no location";
    }

    @Override
    public String getExceptionMessageAdditionalDetail() {
        return null;
    }

    @Override
    public long sleep(long pause, int tries) {
        long sleep = ConnectionUtils.getPauseTime(pause, tries + 1);
        if (sleep < 10000L && (this.location == null || this.connection.isDeadServer(this.location.getServerName()))) {
            sleep = ConnectionUtils.addJitter(10000L, 0.1f);
        }
        return sleep;
    }
}

