/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.AsyncProcess;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionConfiguration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class BufferedMutatorImpl
implements BufferedMutator {
    private static final Log LOG = LogFactory.getLog(BufferedMutatorImpl.class);
    private final BufferedMutator.ExceptionListener listener;
    protected ClusterConnection connection;
    private final TableName tableName;
    private volatile Configuration conf;
    @VisibleForTesting
    final ConcurrentLinkedQueue<Mutation> writeAsyncBuffer = new ConcurrentLinkedQueue();
    @VisibleForTesting
    AtomicLong currentWriteBufferSize = new AtomicLong(0L);
    private long writeBufferSize;
    private final int maxKeyValueSize;
    private boolean closed = false;
    private final ExecutorService pool;
    private int rpcTimeout;
    private int operationTimeout;
    @VisibleForTesting
    protected AsyncProcess ap;

    BufferedMutatorImpl(ClusterConnection conn, RpcRetryingCallerFactory rpcCallerFactory, RpcControllerFactory rpcFactory, BufferedMutatorParams params) {
        if (conn == null || conn.isClosed()) {
            throw new IllegalArgumentException("Connection is null or closed.");
        }
        this.tableName = params.getTableName();
        this.connection = conn;
        this.conf = this.connection.getConfiguration();
        this.pool = params.getPool();
        this.listener = params.getListener();
        ConnectionConfiguration tableConf = new ConnectionConfiguration(this.conf);
        this.writeBufferSize = params.getWriteBufferSize() != -1L ? params.getWriteBufferSize() : tableConf.getWriteBufferSize();
        this.maxKeyValueSize = params.getMaxKeyValueSize() != -1 ? params.getMaxKeyValueSize() : tableConf.getMaxKeyValueSize();
        this.rpcTimeout = conn.getConfiguration().getInt("hbase.rpc.timeout", 60000);
        this.operationTimeout = conn.getConfiguration().getInt("hbase.client.operation.timeout", 1200000);
        this.ap = new AsyncProcess(this.connection, this.conf, this.pool, rpcCallerFactory, true, rpcFactory, this.rpcTimeout);
    }

    @Override
    public TableName getName() {
        return this.tableName;
    }

    @Override
    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    public void mutate(Mutation m) throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        this.mutate(Arrays.asList(m));
    }

    @Override
    public void mutate(List<? extends Mutation> ms) throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        if (this.closed) {
            throw new IllegalStateException("Cannot put when the BufferedMutator is closed.");
        }
        long toAddSize = 0L;
        for (Mutation mutation : ms) {
            if (mutation instanceof Put) {
                this.validatePut((Put)mutation);
            }
            toAddSize += mutation.heapSize();
        }
        if (this.ap.hasError()) {
            this.currentWriteBufferSize.addAndGet(toAddSize);
            this.writeAsyncBuffer.addAll(ms);
            this.backgroundFlushCommits(true);
        } else {
            this.currentWriteBufferSize.addAndGet(toAddSize);
            this.writeAsyncBuffer.addAll(ms);
        }
        while (this.currentWriteBufferSize.get() > this.writeBufferSize) {
            this.backgroundFlushCommits(false);
        }
    }

    public void validatePut(Put put) throws IllegalArgumentException {
        HTable.validatePut(put, this.maxKeyValueSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        try {
            boolean terminated;
            if (this.closed) {
                return;
            }
            this.backgroundFlushCommits(true);
            this.pool.shutdown();
            int loopCnt = 0;
            do {
                terminated = this.pool.awaitTermination(60L, TimeUnit.SECONDS);
                if (++loopCnt < 10) continue;
                LOG.warn((Object)"close() failed to terminate pool after 10 minutes. Abandoning pool.");
                break;
            } while (!terminated);
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"waitForTermination interrupted");
        }
        finally {
            this.closed = true;
        }
    }

    @Override
    public synchronized void flush() throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        this.backgroundFlushCommits(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backgroundFlushCommits(boolean synchronous) throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        LinkedList<Mutation> buffer = new LinkedList<Mutation>();
        try {
            Mutation m;
            long dequeuedSize;
            long size;
            for (dequeuedSize = 0L; (this.writeBufferSize <= 0L || dequeuedSize < this.writeBufferSize * 2L || synchronous) && (m = this.writeAsyncBuffer.poll()) != null; dequeuedSize += size) {
                buffer.add(m);
                size = m.heapSize();
                this.currentWriteBufferSize.addAndGet(-size);
            }
            if (!synchronous && dequeuedSize == 0L) {
                return;
            }
            if (!synchronous) {
                this.ap.submit(this.tableName, buffer, true, null, false);
                if (this.ap.hasError()) {
                    LOG.debug((Object)(this.tableName + ": One or more of the operations have failed -" + " waiting for all operation in progress to finish (successfully or not)"));
                }
            }
            if (synchronous || this.ap.hasError()) {
                while (!buffer.isEmpty()) {
                    this.ap.submit(this.tableName, buffer, true, null, false);
                }
                RetriesExhaustedWithDetailsException error = this.ap.waitForAllPreviousOpsAndReset(null, this.tableName.getNameAsString());
                if (error != null) {
                    if (this.listener == null) {
                        throw error;
                    }
                    this.listener.onException(error, this);
                }
            }
        }
        finally {
            for (Mutation mut : buffer) {
                long size = mut.heapSize();
                this.currentWriteBufferSize.addAndGet(size);
                dequeuedSize -= size;
                this.writeAsyncBuffer.add(mut);
            }
        }
    }

    @Deprecated
    public void setWriteBufferSize(long writeBufferSize) throws RetriesExhaustedWithDetailsException, InterruptedIOException {
        this.writeBufferSize = writeBufferSize;
        if (this.currentWriteBufferSize.get() > writeBufferSize) {
            this.flush();
        }
    }

    @Override
    public long getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public void setRpcTimeout(int rpcTimeout) {
        this.rpcTimeout = rpcTimeout;
        this.ap.setRpcTimeout(rpcTimeout);
    }

    public void setOperationTimeout(int operationTimeout) {
        this.operationTimeout = operationTimeout;
        this.ap.setOperationTimeout(operationTimeout);
    }

    @Deprecated
    public List<Row> getWriteBuffer() {
        return Arrays.asList(this.writeAsyncBuffer.toArray(new Row[0]));
    }
}

