/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.commons.lang.mutable.MutableBoolean;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.FailureInfo;
import org.apache.hadoop.hbase.client.RegionServerCallable;
import org.apache.hadoop.hbase.client.RetryingCallable;
import org.apache.hadoop.hbase.client.RetryingCallerInterceptorContext;

@InterfaceAudience.Private
class FastFailInterceptorContext
extends RetryingCallerInterceptorContext {
    private MutableBoolean couldNotCommunicateWithServer = new MutableBoolean(false);
    private MutableBoolean guaranteedClientSideOnly = new MutableBoolean(false);
    private boolean didTry = false;
    private FailureInfo fInfo = null;
    private boolean retryDespiteFastFailMode = false;
    private ServerName server;
    private int tries;

    FastFailInterceptorContext() {
    }

    public MutableBoolean getCouldNotCommunicateWithServer() {
        return this.couldNotCommunicateWithServer;
    }

    public MutableBoolean getGuaranteedClientSideOnly() {
        return this.guaranteedClientSideOnly;
    }

    public FailureInfo getFailureInfo() {
        return this.fInfo;
    }

    public ServerName getServer() {
        return this.server;
    }

    public int getTries() {
        return this.tries;
    }

    public boolean didTry() {
        return this.didTry;
    }

    public boolean isRetryDespiteFastFailMode() {
        return this.retryDespiteFastFailMode;
    }

    public void setCouldNotCommunicateWithServer(MutableBoolean couldNotCommunicateWithServer) {
        this.couldNotCommunicateWithServer = couldNotCommunicateWithServer;
    }

    public void setGuaranteedClientSideOnly(MutableBoolean guaranteedClientSideOnly) {
        this.guaranteedClientSideOnly = guaranteedClientSideOnly;
    }

    public void setDidTry(boolean didTry) {
        this.didTry = didTry;
    }

    public void setFailureInfo(FailureInfo fInfo) {
        this.fInfo = fInfo;
    }

    public void setRetryDespiteFastFailMode(boolean retryDespiteFastFailMode) {
        this.retryDespiteFastFailMode = retryDespiteFastFailMode;
    }

    public void setServer(ServerName server) {
        this.server = server;
    }

    public void setTries(int tries) {
        this.tries = tries;
    }

    @Override
    public void clear() {
        this.server = null;
        this.fInfo = null;
        this.didTry = false;
        this.couldNotCommunicateWithServer.setValue(false);
        this.guaranteedClientSideOnly.setValue(false);
        this.retryDespiteFastFailMode = false;
        this.tries = 0;
    }

    @Override
    public FastFailInterceptorContext prepare(RetryingCallable<?> callable) {
        return this.prepare((RetryingCallable)callable, 0);
    }

    @Override
    public FastFailInterceptorContext prepare(RetryingCallable<?> callable, int tries) {
        if (callable instanceof RegionServerCallable) {
            RegionServerCallable retryingCallable = (RegionServerCallable)callable;
            this.server = retryingCallable.getLocation().getServerName();
        }
        this.tries = tries;
        return this;
    }
}

