/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.executor;

import org.apache.hadoop.hbase.executor.ExecutorType;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public enum EventType {
    RS_ZK_REGION_CLOSED(2, ExecutorType.MASTER_CLOSE_REGION),
    RS_ZK_REGION_OPENING(3, null),
    RS_ZK_REGION_OPENED(4, ExecutorType.MASTER_OPEN_REGION),
    RS_ZK_REGION_SPLITTING(5, null),
    RS_ZK_REGION_SPLIT(6, ExecutorType.MASTER_SERVER_OPERATIONS),
    RS_ZK_REGION_FAILED_OPEN(7, ExecutorType.MASTER_CLOSE_REGION),
    RS_ZK_REGION_MERGING(8, null),
    RS_ZK_REGION_MERGED(9, ExecutorType.MASTER_SERVER_OPERATIONS),
    RS_ZK_REQUEST_REGION_SPLIT(10, null),
    RS_ZK_REQUEST_REGION_MERGE(11, null),
    M_RS_OPEN_REGION(20, ExecutorType.RS_OPEN_REGION),
    M_RS_OPEN_ROOT(21, ExecutorType.RS_OPEN_ROOT),
    M_RS_OPEN_META(22, ExecutorType.RS_OPEN_META),
    M_RS_CLOSE_REGION(23, ExecutorType.RS_CLOSE_REGION),
    M_RS_CLOSE_ROOT(24, ExecutorType.RS_CLOSE_ROOT),
    M_RS_CLOSE_META(25, ExecutorType.RS_CLOSE_META),
    M_RS_OPEN_PRIORITY_REGION(26, ExecutorType.RS_OPEN_PRIORITY_REGION),
    C_M_MERGE_REGION(30, ExecutorType.MASTER_TABLE_OPERATIONS),
    C_M_DELETE_TABLE(40, ExecutorType.MASTER_TABLE_OPERATIONS),
    C_M_DISABLE_TABLE(41, ExecutorType.MASTER_TABLE_OPERATIONS),
    C_M_ENABLE_TABLE(42, ExecutorType.MASTER_TABLE_OPERATIONS),
    C_M_MODIFY_TABLE(43, ExecutorType.MASTER_TABLE_OPERATIONS),
    C_M_ADD_FAMILY(44, null),
    C_M_DELETE_FAMILY(45, null),
    C_M_MODIFY_FAMILY(46, null),
    C_M_CREATE_TABLE(47, ExecutorType.MASTER_TABLE_OPERATIONS),
    C_M_SNAPSHOT_TABLE(48, ExecutorType.MASTER_TABLE_OPERATIONS),
    C_M_RESTORE_SNAPSHOT(49, ExecutorType.MASTER_TABLE_OPERATIONS),
    M_ZK_REGION_OFFLINE(50, null),
    M_ZK_REGION_CLOSING(51, null),
    M_SERVER_SHUTDOWN(70, ExecutorType.MASTER_SERVER_OPERATIONS),
    M_META_SERVER_SHUTDOWN(72, ExecutorType.MASTER_META_SERVER_OPERATIONS),
    M_MASTER_RECOVERY(73, ExecutorType.MASTER_SERVER_OPERATIONS),
    M_LOG_REPLAY(74, ExecutorType.M_LOG_REPLAY_OPS),
    RS_PARALLEL_SEEK(80, ExecutorType.RS_PARALLEL_SEEK),
    RS_LOG_REPLAY(81, ExecutorType.RS_LOG_REPLAY_OPS),
    RS_REGION_REPLICA_FLUSH(82, ExecutorType.RS_REGION_REPLICA_FLUSH_OPS),
    RS_COMPACTED_FILES_DISCHARGER(83, ExecutorType.RS_COMPACTED_FILES_DISCHARGER);

    private final int code;
    private final ExecutorType executor;

    private EventType(int code, ExecutorType executor) {
        this.code = code;
        this.executor = executor;
    }

    public int getCode() {
        return this.code;
    }

    public static EventType get(int code) {
        for (EventType et : EventType.values()) {
            if (et.getCode() != code) continue;
            return et;
        }
        throw new IllegalArgumentException("Unknown code " + code);
    }

    public boolean isOnlineSchemaChangeSupported() {
        return this.equals((Object)C_M_ADD_FAMILY) || this.equals((Object)C_M_DELETE_FAMILY) || this.equals((Object)C_M_MODIFY_FAMILY) || this.equals((Object)C_M_MODIFY_TABLE);
    }

    ExecutorType getExecutorServiceType() {
        return this.executor;
    }
}

