/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class FailedServers {
    private final Map<String, Long> failedServers = new HashMap<String, Long>();
    private long latestExpiry = 0L;
    private final int recheckServersTimeout;
    private static final Log LOG = LogFactory.getLog(FailedServers.class);

    public FailedServers(Configuration conf) {
        this.recheckServersTimeout = conf.getInt("hbase.ipc.client.failed.servers.expiry", 2000);
    }

    public synchronized void addToFailedServers(InetSocketAddress address, Throwable throwable) {
        long expiry = EnvironmentEdgeManager.currentTime() + (long)this.recheckServersTimeout;
        this.failedServers.put(address.toString(), expiry);
        this.latestExpiry = expiry;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Added failed server with address " + address.toString() + " to list caused by " + throwable.toString()));
        }
    }

    public synchronized boolean isFailedServer(InetSocketAddress address) {
        if (this.failedServers.isEmpty()) {
            return false;
        }
        long now = EnvironmentEdgeManager.currentTime();
        if (now > this.latestExpiry) {
            this.failedServers.clear();
            return false;
        }
        String key = address.toString();
        Long expiry = this.failedServers.get(key);
        if (expiry == null) {
            return false;
        }
        if (expiry >= now) {
            return true;
        }
        this.failedServers.remove(key);
        return false;
    }
}

