/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.io.IOException;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.security.AuthMethod;
import org.apache.hadoop.hbase.security.SaslUtil;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class AbstractHBaseSaslRpcClient {
    private static final Log LOG = LogFactory.getLog(AbstractHBaseSaslRpcClient.class);
    private static final byte[] EMPTY_TOKEN = new byte[0];
    protected final SaslClient saslClient;
    protected final boolean fallbackAllowed;
    protected final Map<String, String> saslProps;

    protected AbstractHBaseSaslRpcClient(AuthMethod method, Token<? extends TokenIdentifier> token, String serverPrincipal, boolean fallbackAllowed) throws IOException {
        this(method, token, serverPrincipal, fallbackAllowed, "authentication");
    }

    protected AbstractHBaseSaslRpcClient(AuthMethod method, Token<? extends TokenIdentifier> token, String serverPrincipal, boolean fallbackAllowed, String rpcProtection) throws IOException {
        this.fallbackAllowed = fallbackAllowed;
        this.saslProps = SaslUtil.initSaslProperties(rpcProtection);
        switch (method) {
            case DIGEST: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Creating SASL " + AuthMethod.DIGEST.getMechanismName() + " client to authenticate to service at " + token.getService()));
                }
                this.saslClient = this.createDigestSaslClient(new String[]{AuthMethod.DIGEST.getMechanismName()}, "default", new SaslClientCallbackHandler(token));
                break;
            }
            case KERBEROS: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Creating SASL " + AuthMethod.KERBEROS.getMechanismName() + " client. Server's Kerberos principal name is " + serverPrincipal));
                }
                if (serverPrincipal == null || serverPrincipal.length() == 0) {
                    throw new IOException("Failed to specify server's Kerberos principal name");
                }
                String[] names = SaslUtil.splitKerberosName(serverPrincipal);
                if (names.length != 3) {
                    throw new IOException("Kerberos principal does not have the expected format: " + serverPrincipal);
                }
                this.saslClient = this.createKerberosSaslClient(new String[]{AuthMethod.KERBEROS.getMechanismName()}, names[0], names[1]);
                break;
            }
            default: {
                throw new IOException("Unknown authentication method " + (Object)((Object)method));
            }
        }
        if (this.saslClient == null) {
            throw new IOException("Unable to find SASL client implementation");
        }
    }

    protected SaslClient createDigestSaslClient(String[] mechanismNames, String saslDefaultRealm, CallbackHandler saslClientCallbackHandler) throws IOException {
        return Sasl.createSaslClient(mechanismNames, null, null, saslDefaultRealm, this.saslProps, saslClientCallbackHandler);
    }

    protected SaslClient createKerberosSaslClient(String[] mechanismNames, String userFirstPart, String userSecondPart) throws IOException {
        return Sasl.createSaslClient(mechanismNames, null, userFirstPart, userSecondPart, this.saslProps, null);
    }

    public byte[] getInitialResponse() throws SaslException {
        if (this.saslClient.hasInitialResponse()) {
            return this.saslClient.evaluateChallenge(EMPTY_TOKEN);
        }
        return EMPTY_TOKEN;
    }

    public boolean isComplete() {
        return this.saslClient.isComplete();
    }

    public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
        return this.saslClient.evaluateChallenge(challenge);
    }

    public void dispose() {
        SaslUtil.safeDispose(this.saslClient);
    }

    @VisibleForTesting
    static class SaslClientCallbackHandler
    implements CallbackHandler {
        private final String userName;
        private final char[] userPassword;

        public SaslClientCallbackHandler(Token<? extends TokenIdentifier> token) {
            this.userName = SaslUtil.encodeIdentifier(token.getIdentifier());
            this.userPassword = SaslUtil.encodePassword(token.getPassword());
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            NameCallback nc = null;
            PasswordCallback pc = null;
            TextInputCallback rc = null;
            for (Callback callback : callbacks) {
                if (callback instanceof RealmChoiceCallback) continue;
                if (callback instanceof NameCallback) {
                    nc = (NameCallback)callback;
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    pc = (PasswordCallback)callback;
                    continue;
                }
                if (callback instanceof RealmCallback) {
                    rc = (RealmCallback)callback;
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Unrecognized SASL client callback");
            }
            if (nc != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("SASL client callback: setting username: " + this.userName));
                }
                nc.setName(this.userName);
            }
            if (pc != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"SASL client callback: setting userPassword");
                }
                pc.setPassword(this.userPassword);
            }
            if (rc != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("SASL client callback: setting realm: " + rc.getDefaultText()));
                }
                rc.setText(rc.getDefaultText());
            }
        }
    }
}

