/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.util.AbstractByteRange;
import org.apache.hadoop.hbase.util.ByteRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ReadOnlyByteRangeException;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class SimpleByteRange
extends AbstractByteRange {
    public SimpleByteRange() {
    }

    public SimpleByteRange(int capacity) {
        this(new byte[capacity]);
    }

    public SimpleByteRange(byte[] bytes) {
        this.set(bytes);
    }

    public SimpleByteRange(byte[] bytes, int offset, int length) {
        this.set(bytes, offset, length);
    }

    @Override
    public ByteRange unset() {
        throw new ReadOnlyByteRangeException();
    }

    @Override
    public ByteRange set(int capacity) {
        if (this.bytes != null) {
            throw new ReadOnlyByteRangeException();
        }
        return super.set(capacity);
    }

    @Override
    public ByteRange set(byte[] bytes) {
        if (this.bytes != null) {
            throw new ReadOnlyByteRangeException();
        }
        return super.set(bytes);
    }

    @Override
    public ByteRange set(byte[] bytes, int offset, int length) {
        if (this.bytes != null) {
            throw new ReadOnlyByteRangeException();
        }
        return super.set(bytes, offset, length);
    }

    @Override
    public ByteRange put(int index, byte val) {
        throw new ReadOnlyByteRangeException();
    }

    @Override
    public ByteRange put(int index, byte[] val) {
        throw new ReadOnlyByteRangeException();
    }

    @Override
    public ByteRange put(int index, byte[] val, int offset, int length) {
        throw new ReadOnlyByteRangeException();
    }

    @Override
    public ByteRange shallowCopy() {
        SimpleByteRange clone = new SimpleByteRange(this.bytes, this.offset, this.length);
        if (this.isHashCached()) {
            clone.hash = this.hash;
        }
        return clone;
    }

    @Override
    public ByteRange shallowCopySubRange(int innerOffset, int copyLength) {
        SimpleByteRange clone = new SimpleByteRange(this.bytes, this.offset + innerOffset, copyLength);
        if (this.isHashCached()) {
            clone.hash = this.hash;
        }
        return clone;
    }

    public boolean equals(Object thatObject) {
        if (thatObject == null) {
            return false;
        }
        if (this == thatObject) {
            return true;
        }
        if (this.hashCode() != thatObject.hashCode()) {
            return false;
        }
        if (!(thatObject instanceof SimpleByteRange)) {
            return false;
        }
        SimpleByteRange that = (SimpleByteRange)thatObject;
        return Bytes.equals(this.bytes, this.offset, this.length, that.bytes, that.offset, that.length);
    }

    @Override
    public ByteRange deepCopy() {
        SimpleByteRange clone = new SimpleByteRange(this.deepCopyToNewArray());
        if (this.isHashCached()) {
            clone.hash = this.hash;
        }
        return clone;
    }

    @Override
    public ByteRange putInt(int index, int val) {
        throw new ReadOnlyByteRangeException();
    }

    @Override
    public ByteRange putLong(int index, long val) {
        throw new ReadOnlyByteRangeException();
    }

    @Override
    public ByteRange putShort(int index, short val) {
        throw new ReadOnlyByteRangeException();
    }

    @Override
    public int putVLong(int index, long val) {
        throw new ReadOnlyByteRangeException();
    }
}

