/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class VersionInfo {
    private static final Log LOG = LogFactory.getLog((String)VersionInfo.class.getName());
    private static int VERY_LARGE_NUMBER = 100000;

    public static String getVersion() {
        return "2.0.0-alpha4";
    }

    public static String getRevision() {
        return "5c4b985f89c99cc8b0f8515a4097c811a0848835";
    }

    public static String getDate() {
        return "Fri Nov  3 09:34:40 PDT 2017";
    }

    public static String getUser() {
        return "stack";
    }

    public static String getUrl() {
        return "git://ve0524/home/stack/hbase.git";
    }

    static String[] versionReport() {
        return new String[]{"HBase " + VersionInfo.getVersion(), "Source code repository " + VersionInfo.getUrl() + " revision=" + VersionInfo.getRevision(), "Compiled by " + VersionInfo.getUser() + " on " + VersionInfo.getDate(), "From source with checksum " + VersionInfo.getSrcChecksum()};
    }

    public static String getSrcChecksum() {
        return "0d703ce0225a93281dc38e2588a8b2e2";
    }

    public static void writeTo(PrintWriter out) {
        for (String line : VersionInfo.versionReport()) {
            out.println(line);
        }
    }

    public static void writeTo(PrintStream out) {
        for (String line : VersionInfo.versionReport()) {
            out.println(line);
        }
    }

    public static void logVersion() {
        for (String line : VersionInfo.versionReport()) {
            LOG.info((Object)line);
        }
    }

    public static int compareVersion(String v1, String v2) {
        int index;
        if (v1.equals(v2)) {
            return 0;
        }
        String[] s1 = v1.split("\\.|-");
        String[] s2 = v2.split("\\.|-");
        for (index = 0; index < s1.length && index < s2.length; ++index) {
            int c;
            int va = VERY_LARGE_NUMBER;
            int vb = VERY_LARGE_NUMBER;
            try {
                va = Integer.parseInt(s1[index]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                vb = Integer.parseInt(s2[index]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (va != vb) {
                return va - vb;
            }
            if (va != VERY_LARGE_NUMBER || (c = s1[index].compareTo(s2[index])) == 0) continue;
            return c;
        }
        if (index < s1.length) {
            return 1;
        }
        return -1;
    }

    public static void main(String[] args) {
        VersionInfo.writeTo(System.out);
    }
}

