/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.master.MetricsAssignmentManagerSource;
import org.apache.hadoop.hbase.master.MetricsMaster;
import org.apache.hadoop.hbase.procedure2.ProcedureMetrics;

public class MetricsAssignmentManager {
    private final MetricsAssignmentManagerSource assignmentManagerSource = (MetricsAssignmentManagerSource)CompatibilitySingletonFactory.getInstance(MetricsAssignmentManagerSource.class);
    private final ProcedureMetrics assignProcMetrics = MetricsMaster.convertToProcedureMetrics(this.assignmentManagerSource.getAssignMetrics());
    private final ProcedureMetrics unassignProcMetrics = MetricsMaster.convertToProcedureMetrics(this.assignmentManagerSource.getUnassignMetrics());
    private final ProcedureMetrics splitProcMetrics = MetricsMaster.convertToProcedureMetrics(this.assignmentManagerSource.getSplitMetrics());
    private final ProcedureMetrics mergeProcMetrics = MetricsMaster.convertToProcedureMetrics(this.assignmentManagerSource.getMergeMetrics());

    public MetricsAssignmentManagerSource getMetricsProcSource() {
        return this.assignmentManagerSource;
    }

    public void updateRITCount(int ritCount) {
        this.assignmentManagerSource.setRIT(ritCount);
    }

    public void updateRITCountOverThreshold(int ritCountOverThreshold) {
        this.assignmentManagerSource.setRITCountOverThreshold(ritCountOverThreshold);
    }

    public void updateRITOldestAge(long timestamp) {
        this.assignmentManagerSource.setRITOldestAge(timestamp);
    }

    public void updateRitDuration(long duration) {
        this.assignmentManagerSource.updateRitDuration(duration);
    }

    public void incrementOperationCounter() {
        this.assignmentManagerSource.incrementOperationCounter();
    }

    public ProcedureMetrics getAssignProcMetrics() {
        return this.assignProcMetrics;
    }

    public ProcedureMetrics getUnassignProcMetrics() {
        return this.unassignProcMetrics;
    }

    public ProcedureMetrics getSplitProcMetrics() {
        return this.splitProcMetrics;
    }

    public ProcedureMetrics getMergeProcMetrics() {
        return this.mergeProcMetrics;
    }
}

