/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.ScriptBasedMapping;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RackManager {
    private static final Log LOG = LogFactory.getLog(RackManager.class);
    public static final String UNKNOWN_RACK = "Unknown Rack";
    private DNSToSwitchMapping switchMapping;

    public RackManager() {
    }

    public RackManager(Configuration conf) {
        this.switchMapping = (DNSToSwitchMapping)ReflectionUtils.instantiateWithCustomCtor((String)conf.getClass("hbase.util.ip.to.rack.determiner", ScriptBasedMapping.class, DNSToSwitchMapping.class).getName(), (Class[])new Class[]{Configuration.class}, (Object[])new Object[]{conf});
    }

    public String getRack(ServerName server) {
        if (server == null) {
            return UNKNOWN_RACK;
        }
        List racks = this.switchMapping.resolve(Collections.singletonList(server.getHostname()));
        if (racks != null && !racks.isEmpty()) {
            return (String)racks.get(0);
        }
        return UNKNOWN_RACK;
    }

    public List<String> getRack(List<ServerName> servers) {
        ArrayList<String> serversAsString = new ArrayList<String>(servers.size());
        for (ServerName server : servers) {
            serversAsString.add(server.getHostname());
        }
        List racks = this.switchMapping.resolve(serversAsString);
        return racks;
    }
}

