/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.MasterWalManager;
import org.apache.hadoop.hbase.master.assignment.AssignProcedure;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.RegionTransitionProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.RecoverMetaProcedure;
import org.apache.hadoop.hbase.master.procedure.ServerCrashException;
import org.apache.hadoop.hbase.master.procedure.ServerProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureMetrics;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Message;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;

public class ServerCrashProcedure
extends StateMachineProcedure<MasterProcedureEnv, MasterProcedureProtos.ServerCrashState>
implements ServerProcedureInterface {
    private static final Log LOG = LogFactory.getLog(ServerCrashProcedure.class);
    private ServerName serverName;
    private boolean notifiedDeadServer = false;
    private List<RegionInfo> regionsOnCrashedServer;
    private boolean carryingMeta = false;
    private boolean shouldSplitWal;

    public ServerCrashProcedure(MasterProcedureEnv env, ServerName serverName, boolean shouldSplitWal, boolean carryingMeta) {
        this.serverName = serverName;
        this.shouldSplitWal = shouldSplitWal;
        this.carryingMeta = carryingMeta;
        this.setOwner(env.getRequestUser());
    }

    public ServerCrashProcedure() {
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.ServerCrashState state) throws ProcedureSuspendedException, ProcedureYieldException {
        MasterServices services = env.getMasterServices();
        if (!this.notifiedDeadServer) {
            services.getServerManager().getDeadServers().notifyServer(this.serverName);
            this.notifiedDeadServer = true;
        }
        try {
            switch (state) {
                case SERVER_CRASH_START: {
                    LOG.info((Object)("Start " + this));
                    if (this.carryingMeta) {
                        this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_PROCESS_META);
                        break;
                    }
                    this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_GET_REGIONS);
                    break;
                }
                case SERVER_CRASH_GET_REGIONS: {
                    if (env.getAssignmentManager().waitMetaLoaded((Procedure)this)) {
                        throw new ProcedureSuspendedException();
                    }
                    this.regionsOnCrashedServer = services.getAssignmentManager().getRegionStates().getServerRegionInfoSet(this.serverName);
                    if (!this.shouldSplitWal) {
                        this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_ASSIGN);
                        break;
                    }
                    this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_SPLIT_LOGS);
                    break;
                }
                case SERVER_CRASH_PROCESS_META: {
                    this.processMeta(env);
                    this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_GET_REGIONS);
                    break;
                }
                case SERVER_CRASH_SPLIT_LOGS: {
                    this.splitLogs(env);
                    this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_ASSIGN);
                    break;
                }
                case SERVER_CRASH_ASSIGN: {
                    if (this.filterDefaultMetaRegions(this.regionsOnCrashedServer)) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)("Assigning regions " + RegionInfo.getShortNameToLog(this.regionsOnCrashedServer) + ", " + this + "; cycles=" + this.getCycles()));
                        }
                        this.handleRIT(env, this.regionsOnCrashedServer);
                        AssignmentManager am = env.getAssignmentManager();
                        this.addChildProcedure(am.createAssignProcedures(am.getOrderedRegions(this.regionsOnCrashedServer), false));
                    }
                    this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_FINISH);
                    break;
                }
                case SERVER_CRASH_FINISH: {
                    services.getAssignmentManager().getRegionStates().removeServer(this.serverName);
                    services.getServerManager().getDeadServers().finish(this.serverName);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException("unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed state=" + state + ", retry " + this + "; cycles=" + this.getCycles()), (Throwable)e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    private void processMeta(MasterProcedureEnv env) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this + "; Processing hbase:meta that was on " + this.serverName));
        }
        AssignmentManager am = env.getMasterServices().getAssignmentManager();
        for (RegionInfo hri : am.getRegionStates().getServerRegionInfoSet(this.serverName)) {
            if (!this.isDefaultMetaRegion(hri)) continue;
            am.offlineRegion(hri);
            this.addChildProcedure(new Procedure[]{new RecoverMetaProcedure(this.serverName, this.shouldSplitWal)});
        }
    }

    private boolean filterDefaultMetaRegions(List<RegionInfo> regions) {
        if (regions == null) {
            return false;
        }
        regions.removeIf(this::isDefaultMetaRegion);
        return !regions.isEmpty();
    }

    private boolean isDefaultMetaRegion(RegionInfo hri) {
        return hri.getTable().equals((Object)TableName.META_TABLE_NAME) && RegionReplicaUtil.isDefaultReplica((RegionInfo)hri);
    }

    private void splitLogs(MasterProcedureEnv env) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Splitting WALs " + this));
        }
        MasterWalManager mwm = env.getMasterServices().getMasterWalManager();
        AssignmentManager am = env.getMasterServices().getAssignmentManager();
        mwm.splitLog(this.serverName);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Done splitting WALs " + this));
        }
        am.getRegionStates().logSplit(this.serverName);
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.ServerCrashState state) throws IOException {
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    protected MasterProcedureProtos.ServerCrashState getState(int stateId) {
        return MasterProcedureProtos.ServerCrashState.forNumber((int)stateId);
    }

    protected int getStateId(MasterProcedureProtos.ServerCrashState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.ServerCrashState getInitialState() {
        return MasterProcedureProtos.ServerCrashState.SERVER_CRASH_START;
    }

    protected boolean abort(MasterProcedureEnv env) {
        return false;
    }

    protected Procedure.LockState acquireLock(MasterProcedureEnv env) {
        if (env.waitServerCrashProcessingEnabled((Procedure)this)) {
            return Procedure.LockState.LOCK_EVENT_WAIT;
        }
        if (env.getProcedureScheduler().waitServerExclusiveLock((Procedure)this, this.getServerName())) {
            return Procedure.LockState.LOCK_EVENT_WAIT;
        }
        return Procedure.LockState.LOCK_ACQUIRED;
    }

    protected void releaseLock(MasterProcedureEnv env) {
        env.getProcedureScheduler().wakeServerExclusiveLock((Procedure)this, this.getServerName());
    }

    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" server=");
        sb.append(this.serverName);
        sb.append(", splitWal=");
        sb.append(this.shouldSplitWal);
        sb.append(", meta=");
        sb.append(this.carryingMeta);
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.ServerCrashStateData.Builder state = MasterProcedureProtos.ServerCrashStateData.newBuilder().setServerName(ProtobufUtil.toServerName((ServerName)this.serverName)).setCarryingMeta(this.carryingMeta).setShouldSplitWal(this.shouldSplitWal);
        if (this.regionsOnCrashedServer != null && !this.regionsOnCrashedServer.isEmpty()) {
            for (RegionInfo hri : this.regionsOnCrashedServer) {
                state.addRegionsOnCrashedServer(ProtobufUtil.toRegionInfo((RegionInfo)hri));
            }
        }
        serializer.serialize((Message)state.build());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.ServerCrashStateData state = (MasterProcedureProtos.ServerCrashStateData)serializer.deserialize(MasterProcedureProtos.ServerCrashStateData.class);
        this.serverName = ProtobufUtil.toServerName((HBaseProtos.ServerName)state.getServerName());
        this.carryingMeta = state.hasCarryingMeta() ? state.getCarryingMeta() : false;
        this.shouldSplitWal = state.getShouldSplitWal();
        int size = state.getRegionsOnCrashedServerCount();
        if (size > 0) {
            this.regionsOnCrashedServer = new ArrayList<RegionInfo>(size);
            for (HBaseProtos.RegionInfo ri : state.getRegionsOnCrashedServerList()) {
                this.regionsOnCrashedServer.add(ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)ri));
            }
        }
    }

    @Override
    public ServerName getServerName() {
        return this.serverName;
    }

    @Override
    public boolean hasMetaTableRegion() {
        return this.carryingMeta;
    }

    @Override
    public ServerProcedureInterface.ServerOperationType getServerOperationType() {
        return ServerProcedureInterface.ServerOperationType.CRASH_HANDLER;
    }

    protected boolean isYieldBeforeExecuteFromState(MasterProcedureEnv env, MasterProcedureProtos.ServerCrashState state) {
        return true;
    }

    protected boolean shouldWaitClientAck(MasterProcedureEnv env) {
        return false;
    }

    private void handleRIT(MasterProcedureEnv env, List<RegionInfo> regions) {
        if (regions == null) {
            return;
        }
        AssignmentManager am = env.getMasterServices().getAssignmentManager();
        Iterator<RegionInfo> it = regions.iterator();
        ServerCrashException sce = null;
        while (it.hasNext()) {
            RegionInfo hri = it.next();
            RegionTransitionProcedure rtp = am.getRegionStates().getRegionTransitionProcedure(hri);
            if (rtp == null) continue;
            ServerName rtpServerName = rtp.getServer(env);
            if (rtpServerName == null) {
                LOG.warn((Object)("RIT with ServerName null! " + rtp));
                continue;
            }
            if (!rtpServerName.equals((Object)this.serverName)) continue;
            LOG.info((Object)("pid=" + this.getProcId() + " found RIT " + rtp + "; " + rtp.getRegionState(env).toShortString()));
            if (sce == null) {
                sce = new ServerCrashException(this.getProcId(), this.getServerName());
            }
            rtp.remoteCallFailed(env, this.serverName, (IOException)((Object)sce));
            if (!(rtp instanceof AssignProcedure)) continue;
            it.remove();
        }
    }

    protected ProcedureMetrics getProcedureMetrics(MasterProcedureEnv env) {
        return env.getMasterServices().getMasterMetrics().getServerCrashProcMetrics();
    }
}

