/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.regionserver.CSLMImmutableSegment;
import org.apache.hadoop.hbase.regionserver.CompactingMemStore;
import org.apache.hadoop.hbase.regionserver.ImmutableSegment;
import org.apache.hadoop.hbase.regionserver.MemStoreSize;
import org.apache.hadoop.hbase.regionserver.MemStoreSizing;
import org.apache.hadoop.hbase.regionserver.MutableSegment;
import org.apache.hadoop.hbase.regionserver.RegionServicesForStores;
import org.apache.hadoop.hbase.regionserver.Segment;
import org.apache.hadoop.hbase.regionserver.SegmentFactory;
import org.apache.hadoop.hbase.regionserver.VersionedSegmentsList;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CompactionPipeline {
    private static final Log LOG = LogFactory.getLog(CompactionPipeline.class);
    public static final long FIXED_OVERHEAD = ClassSize.align((int)(ClassSize.OBJECT + 3 * ClassSize.REFERENCE + 8));
    public static final long DEEP_OVERHEAD = FIXED_OVERHEAD + (long)(2 * ClassSize.LINKEDLIST);
    private final RegionServicesForStores region;
    private final LinkedList<ImmutableSegment> pipeline = new LinkedList();
    private volatile LinkedList<ImmutableSegment> readOnlyCopy = new LinkedList();
    private volatile long version = 0L;

    public CompactionPipeline(RegionServicesForStores region) {
        this.region = region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pushHead(MutableSegment segment) {
        ImmutableSegment immutableSegment = SegmentFactory.instance().createImmutableSegment(segment);
        LinkedList<ImmutableSegment> linkedList = this.pipeline;
        synchronized (linkedList) {
            boolean res = this.addFirst(immutableSegment);
            this.readOnlyCopy = new LinkedList<ImmutableSegment>(this.pipeline);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionedSegmentsList getVersionedList() {
        LinkedList<ImmutableSegment> linkedList = this.pipeline;
        synchronized (linkedList) {
            return new VersionedSegmentsList(this.readOnlyCopy, this.version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionedSegmentsList getVersionedTail() {
        LinkedList<ImmutableSegment> linkedList = this.pipeline;
        synchronized (linkedList) {
            ArrayList<ImmutableSegment> segmentList = new ArrayList<ImmutableSegment>();
            if (!this.pipeline.isEmpty()) {
                segmentList.add(0, this.pipeline.getLast());
            }
            return new VersionedSegmentsList(segmentList, this.version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="Increment is done under a synchronize block so safe")
    public boolean swap(VersionedSegmentsList versionedList, ImmutableSegment segment, boolean closeSuffix, boolean updateRegionSize) {
        List<ImmutableSegment> suffix;
        if (versionedList.getVersion() != this.version) {
            return false;
        }
        LinkedList<ImmutableSegment> linkedList = this.pipeline;
        synchronized (linkedList) {
            if (versionedList.getVersion() != this.version) {
                return false;
            }
            suffix = versionedList.getStoreSegments();
            if (LOG.isDebugEnabled()) {
                int count = 0;
                if (segment != null) {
                    count = segment.getCellsCount();
                }
                LOG.debug((Object)("Swapping pipeline suffix. Just before the swap the number of segments in pipeline is:" + versionedList.getStoreSegments().size() + ", and the number of cells in new segment is:" + count));
            }
            this.swapSuffix(suffix, segment, closeSuffix);
            this.readOnlyCopy = new LinkedList<ImmutableSegment>(this.pipeline);
            ++this.version;
        }
        if (updateRegionSize && this.region != null) {
            long suffixDataSize = CompactionPipeline.getSegmentsKeySize(suffix);
            long newDataSize = 0L;
            if (segment != null) {
                newDataSize = segment.keySize();
            }
            long dataSizeDelta = suffixDataSize - newDataSize;
            long suffixHeapSize = CompactionPipeline.getSegmentsHeapSize(suffix);
            long newHeapSize = 0L;
            if (segment != null) {
                newHeapSize = segment.heapSize();
            }
            long heapSizeDelta = suffixHeapSize - newHeapSize;
            this.region.addMemStoreSize(new MemStoreSizing(-dataSizeDelta, -heapSizeDelta));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Suffix data size: " + suffixDataSize + " new segment data size: " + newDataSize + ". Suffix heap size: " + suffixHeapSize + " new segment heap size: " + newHeapSize));
            }
        }
        return true;
    }

    private static long getSegmentsHeapSize(List<? extends Segment> list) {
        long res = 0L;
        for (Segment segment : list) {
            res += segment.heapSize();
        }
        return res;
    }

    private static long getSegmentsKeySize(List<? extends Segment> list) {
        long res = 0L;
        for (Segment segment : list) {
            res += segment.keySize();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flattenOneSegment(long requesterVersion, CompactingMemStore.IndexType idxType) {
        if (requesterVersion != this.version) {
            LOG.warn((Object)("Segment flattening failed, because versions do not match. Requester version: " + requesterVersion + ", actual version: " + this.version));
            return false;
        }
        LinkedList<ImmutableSegment> linkedList = this.pipeline;
        synchronized (linkedList) {
            if (requesterVersion != this.version) {
                LOG.warn((Object)"Segment flattening failed, because versions do not match");
                return false;
            }
            int i = 0;
            for (ImmutableSegment s : this.pipeline) {
                if (s.canBeFlattened()) {
                    MemStoreSizing newMemstoreAccounting = new MemStoreSizing();
                    ImmutableSegment newS = SegmentFactory.instance().createImmutableSegmentByFlattening((CSLMImmutableSegment)s, idxType, newMemstoreAccounting);
                    this.replaceAtIndex(i, newS);
                    if (this.region != null) {
                        this.region.addMemStoreSize(new MemStoreSize(0L, newMemstoreAccounting.getHeapSize()));
                    }
                    LOG.debug((Object)("Compaction pipeline segment " + s + " was flattened"));
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isEmpty() {
        return this.readOnlyCopy.isEmpty();
    }

    public List<? extends Segment> getSegments() {
        return this.readOnlyCopy;
    }

    public long size() {
        return this.readOnlyCopy.size();
    }

    public long getMinSequenceId() {
        long minSequenceId = Long.MAX_VALUE;
        LinkedList<ImmutableSegment> localCopy = this.readOnlyCopy;
        if (!localCopy.isEmpty()) {
            minSequenceId = ((Segment)localCopy.getLast()).getMinSequenceId();
        }
        return minSequenceId;
    }

    public MemStoreSizing getTailSizing() {
        LinkedList<ImmutableSegment> localCopy = this.readOnlyCopy;
        if (localCopy.isEmpty()) {
            return new MemStoreSizing();
        }
        return new MemStoreSizing(((Segment)localCopy.peekLast()).keySize(), ((Segment)localCopy.peekLast()).heapSize());
    }

    public MemStoreSizing getPipelineSizing() {
        long keySize = 0L;
        long heapSize = 0L;
        LinkedList<ImmutableSegment> localCopy = this.readOnlyCopy;
        if (localCopy.isEmpty()) {
            return new MemStoreSizing();
        }
        for (Segment segment : localCopy) {
            keySize += segment.keySize();
            heapSize += segment.heapSize();
        }
        return new MemStoreSizing(keySize, heapSize);
    }

    private void swapSuffix(List<? extends Segment> suffix, ImmutableSegment segment, boolean closeSegmentsInSuffix) {
        this.pipeline.removeAll(suffix);
        if (segment != null) {
            this.pipeline.addLast(segment);
        }
        if (closeSegmentsInSuffix) {
            for (Segment segment2 : suffix) {
                segment2.close();
            }
        }
    }

    private void replaceAtIndex(int idx, ImmutableSegment newSegment) {
        this.pipeline.set(idx, newSegment);
        this.readOnlyCopy = new LinkedList<ImmutableSegment>(this.pipeline);
    }

    public Segment getTail() {
        List<? extends Segment> localCopy = this.getSegments();
        if (localCopy.isEmpty()) {
            return null;
        }
        return localCopy.get(localCopy.size() - 1);
    }

    private boolean addFirst(ImmutableSegment segment) {
        this.pipeline.addFirst(segment);
        return true;
    }

    private boolean validateSuffixList(LinkedList<ImmutableSegment> suffix) {
        if (suffix.isEmpty()) {
            return true;
        }
        Iterator<ImmutableSegment> pipelineBackwardIterator = this.pipeline.descendingIterator();
        Iterator<ImmutableSegment> suffixBackwardIterator = suffix.descendingIterator();
        while (suffixBackwardIterator.hasNext()) {
            ImmutableSegment pipelineCurrent;
            if (!pipelineBackwardIterator.hasNext()) {
                return false;
            }
            ImmutableSegment suffixCurrent = suffixBackwardIterator.next();
            if (suffixCurrent == (pipelineCurrent = pipelineBackwardIterator.next())) continue;
            return false;
        }
        return true;
    }
}

