/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.List;
import org.apache.hadoop.hbase.regionserver.ImmutableSegment;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class VersionedSegmentsList {
    private final List<ImmutableSegment> storeSegments;
    private final long version;

    public VersionedSegmentsList(List<ImmutableSegment> storeSegments, long version) {
        this.storeSegments = storeSegments;
        this.version = version;
    }

    public List<ImmutableSegment> getStoreSegments() {
        return this.storeSegments;
    }

    public long getVersion() {
        return this.version;
    }

    public int getNumOfCells() {
        int totalCells = 0;
        for (ImmutableSegment s : this.storeSegments) {
            totalCells += s.getCellsCount();
        }
        return totalCells;
    }

    public int getNumOfSegments() {
        return this.storeSegments.size();
    }
}

