/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.StripeMultiFileWriter;
import org.apache.hadoop.hbase.regionserver.compactions.AbstractMultiOutputCompactor;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequestImpl;
import org.apache.hadoop.hbase.regionserver.compactions.Compactor;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class StripeCompactor
extends AbstractMultiOutputCompactor<StripeMultiFileWriter> {
    private static final Log LOG = LogFactory.getLog(StripeCompactor.class);

    public StripeCompactor(Configuration conf, HStore store) {
        super(conf, store);
    }

    public List<Path> compact(CompactionRequestImpl request, final List<byte[]> targetBoundaries, final byte[] majorRangeFromRow, final byte[] majorRangeToRow, ThroughputController throughputController, User user) throws IOException {
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Executing compaction with " + targetBoundaries.size() + " boundaries:");
            for (byte[] tb : targetBoundaries) {
                sb.append(" [").append(Bytes.toString((byte[])tb)).append("]");
            }
            LOG.debug((Object)sb.toString());
        }
        return this.compact(request, new StripeInternalScannerFactory(majorRangeFromRow, majorRangeToRow), new Compactor.CellSinkFactory<StripeMultiFileWriter>(){

            @Override
            public StripeMultiFileWriter createWriter(InternalScanner scanner, Compactor.FileDetails fd, boolean shouldDropBehind) throws IOException {
                StripeMultiFileWriter.BoundaryMultiWriter writer = new StripeMultiFileWriter.BoundaryMultiWriter(StripeCompactor.this.store.getComparator(), targetBoundaries, majorRangeFromRow, majorRangeToRow);
                StripeCompactor.this.initMultiWriter(writer, scanner, fd, shouldDropBehind);
                return writer;
            }
        }, throughputController, user);
    }

    public List<Path> compact(CompactionRequestImpl request, final int targetCount, final long targetSize, final byte[] left, final byte[] right, byte[] majorRangeFromRow, byte[] majorRangeToRow, ThroughputController throughputController, User user) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Executing compaction with " + targetSize + " target file size, no more than " + targetCount + " files, in [" + Bytes.toString((byte[])left) + "] [" + Bytes.toString((byte[])right) + "] range"));
        }
        return this.compact(request, new StripeInternalScannerFactory(majorRangeFromRow, majorRangeToRow), new Compactor.CellSinkFactory<StripeMultiFileWriter>(){

            @Override
            public StripeMultiFileWriter createWriter(InternalScanner scanner, Compactor.FileDetails fd, boolean shouldDropBehind) throws IOException {
                StripeMultiFileWriter.SizeMultiWriter writer = new StripeMultiFileWriter.SizeMultiWriter(StripeCompactor.this.store.getComparator(), targetCount, targetSize, left, right);
                StripeCompactor.this.initMultiWriter(writer, scanner, fd, shouldDropBehind);
                return writer;
            }
        }, throughputController, user);
    }

    @Override
    protected List<Path> commitWriter(StripeMultiFileWriter writer, Compactor.FileDetails fd, CompactionRequestImpl request) throws IOException {
        List<Path> newFiles = writer.commitWriters(fd.maxSeqId, request.isMajor());
        assert (!newFiles.isEmpty()) : "Should have produced an empty file to preserve metadata.";
        return newFiles;
    }

    private final class StripeInternalScannerFactory
    implements Compactor.InternalScannerFactory {
        private final byte[] majorRangeFromRow;
        private final byte[] majorRangeToRow;

        public StripeInternalScannerFactory(byte[] majorRangeFromRow, byte[] majorRangeToRow) {
            this.majorRangeFromRow = majorRangeFromRow;
            this.majorRangeToRow = majorRangeToRow;
        }

        @Override
        public ScanType getScanType(CompactionRequestImpl request) {
            return ScanType.COMPACT_RETAIN_DELETES;
        }

        @Override
        public InternalScanner createScanner(ScanInfo scanInfo, List<StoreFileScanner> scanners, ScanType scanType, Compactor.FileDetails fd, long smallestReadPoint) throws IOException {
            return this.majorRangeFromRow == null ? StripeCompactor.this.createScanner(StripeCompactor.this.store, scanInfo, scanners, scanType, smallestReadPoint, fd.earliestPutTs) : StripeCompactor.this.createScanner(StripeCompactor.this.store, scanInfo, scanners, smallestReadPoint, fd.earliestPutTs, this.majorRangeFromRow, this.majorRangeToRow);
        }
    }
}

