/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.coprocessor.CoreCoprocessor;
import org.apache.hadoop.hbase.coprocessor.HasRegionServerServices;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.replication.regionserver.Replication;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@CoreCoprocessor
@InterfaceAudience.Private
public class ReplicationObserver
implements RegionCoprocessor,
RegionObserver {
    private static final Log LOG = LogFactory.getLog(ReplicationObserver.class);

    @Override
    public Optional<RegionObserver> getRegionObserver() {
        return Optional.of(this);
    }

    @Override
    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH"}, justification="NPE should never happen; if it does it is a bigger issue")
    public void preCommitStoreFile(ObserverContext<RegionCoprocessorEnvironment> ctx, byte[] family, List<Pair<Path, Path>> pairs) throws IOException {
        RegionCoprocessorEnvironment env = ctx.getEnvironment();
        Configuration c = env.getConfiguration();
        if (pairs == null || pairs.isEmpty() || !c.getBoolean("hbase.replication.bulkload.enabled", false)) {
            LOG.debug((Object)"Skipping recording bulk load entries in preCommitStoreFile for bulkloaded data replication.");
            return;
        }
        RegionServerServices rss = ((HasRegionServerServices)((Object)env)).getRegionServerServices();
        Replication rep = (Replication)((HRegionServer)rss).getReplicationSourceService();
        rep.addHFileRefsToQueue(env.getRegionInfo().getTable(), family, pairs);
    }
}

