/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.crypto.DefaultCipherProvider;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.crypto.KeyStoreKeyProvider;
import org.apache.hadoop.hbase.security.EncryptionUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
public class EncryptionTest {
    private static final Log LOG = LogFactory.getLog(EncryptionTest.class);
    static final Map<String, Boolean> keyProviderResults = new ConcurrentHashMap<String, Boolean>();
    static final Map<String, Boolean> cipherProviderResults = new ConcurrentHashMap<String, Boolean>();
    static final Map<String, Boolean> cipherResults = new ConcurrentHashMap<String, Boolean>();

    private EncryptionTest() {
    }

    public static void testKeyProvider(Configuration conf) throws IOException {
        String providerClassName = conf.get("hbase.crypto.keyprovider", KeyStoreKeyProvider.class.getName());
        Boolean result = keyProviderResults.get(providerClassName);
        if (result == null) {
            try {
                Encryption.getKeyProvider((Configuration)conf);
                keyProviderResults.put(providerClassName, true);
            }
            catch (Exception e) {
                keyProviderResults.put(providerClassName, false);
                throw new IOException("Key provider " + providerClassName + " failed test: " + e.getMessage(), e);
            }
        } else if (!result.booleanValue()) {
            throw new IOException("Key provider " + providerClassName + " previously failed test");
        }
    }

    public static void testCipherProvider(Configuration conf) throws IOException {
        String providerClassName = conf.get("hbase.crypto.cipherprovider", DefaultCipherProvider.class.getName());
        Boolean result = cipherProviderResults.get(providerClassName);
        if (result == null) {
            try {
                Encryption.getCipherProvider((Configuration)conf);
                cipherProviderResults.put(providerClassName, true);
            }
            catch (Exception e) {
                cipherProviderResults.put(providerClassName, false);
                throw new IOException("Cipher provider " + providerClassName + " failed test: " + e.getMessage(), e);
            }
        } else if (!result.booleanValue()) {
            throw new IOException("Cipher provider " + providerClassName + " previously failed test");
        }
    }

    public static void testEncryption(Configuration conf, String cipher, byte[] key) throws IOException {
        if (cipher == null) {
            return;
        }
        EncryptionTest.testKeyProvider(conf);
        EncryptionTest.testCipherProvider(conf);
        Boolean result = cipherResults.get(cipher);
        if (result == null) {
            try {
                Encryption.Context context = Encryption.newContext((Configuration)conf);
                context.setCipher(Encryption.getCipher((Configuration)conf, (String)cipher));
                if (key == null) {
                    context.setKey(context.getCipher().getRandomKey());
                } else {
                    context.setKey(EncryptionUtil.unwrapKey((Configuration)conf, (String)conf.get("hbase.crypto.master.key.name", "hbase"), (byte[])key));
                }
                byte[] iv = null;
                if (context.getCipher().getIvLength() > 0) {
                    iv = new byte[context.getCipher().getIvLength()];
                    Bytes.random((byte[])iv);
                }
                byte[] plaintext = new byte[1024];
                Bytes.random((byte[])plaintext);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                Encryption.encrypt((OutputStream)out, (InputStream)new ByteArrayInputStream(plaintext), (Encryption.Context)context, (byte[])iv);
                byte[] ciphertext = out.toByteArray();
                out.reset();
                Encryption.decrypt((OutputStream)out, (InputStream)new ByteArrayInputStream(ciphertext), (int)plaintext.length, (Encryption.Context)context, (byte[])iv);
                byte[] test = out.toByteArray();
                if (!Bytes.equals((byte[])plaintext, (byte[])test)) {
                    throw new IOException("Did not pass encrypt/decrypt test");
                }
                cipherResults.put(cipher, true);
            }
            catch (Exception e) {
                cipherResults.put(cipher, false);
                throw new IOException("Cipher " + cipher + " failed test: " + e.getMessage(), e);
            }
        } else if (!result.booleanValue()) {
            throw new IOException("Cipher " + cipher + " previously failed test");
        }
    }
}

