/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.hbase.ExtendedCell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ExtendedCellSerialization
implements Serialization<ExtendedCell> {
    public boolean accept(Class<?> c) {
        return ExtendedCell.class.isAssignableFrom(c);
    }

    public ExtendedCellDeserializer getDeserializer(Class<ExtendedCell> t) {
        return new ExtendedCellDeserializer();
    }

    public ExtendedCellSerializer getSerializer(Class<ExtendedCell> c) {
        return new ExtendedCellSerializer();
    }

    public static class ExtendedCellSerializer
    implements Serializer<ExtendedCell> {
        private DataOutputStream dos;

        public void close() throws IOException {
            this.dos.close();
        }

        public void open(OutputStream os) throws IOException {
            this.dos = new DataOutputStream(os);
        }

        public void serialize(ExtendedCell kv) throws IOException {
            this.dos.writeInt(PrivateCellUtil.estimatedSerializedSizeOf(kv) - 4);
            PrivateCellUtil.writeCell(kv, this.dos, true);
            this.dos.writeLong(kv.getSequenceId());
        }
    }

    public static class ExtendedCellDeserializer
    implements Deserializer<ExtendedCell> {
        private DataInputStream dis;

        public void close() throws IOException {
            this.dis.close();
        }

        public KeyValue deserialize(ExtendedCell ignore) throws IOException {
            KeyValue kv = KeyValueUtil.create(this.dis);
            PrivateCellUtil.setSequenceId(kv, this.dis.readLong());
            return kv;
        }

        public void open(InputStream is) throws IOException {
            this.dis = new DataInputStream(is);
        }
    }
}

