/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import org.apache.hadoop.hbase.master.balancer.AssignRegionAction;
import org.apache.hadoop.hbase.master.balancer.BalanceAction;
import org.apache.hadoop.hbase.master.balancer.BalancerClusterState;
import org.apache.hadoop.hbase.master.balancer.MoveRegionAction;
import org.apache.hadoop.hbase.master.balancer.StochasticLoadBalancer;
import org.apache.hadoop.hbase.master.balancer.SwapRegionsAction;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
abstract class CostFunction {
    public static final double COST_EPSILON = 1.0E-4;
    private float multiplier = 0.0f;
    protected BalancerClusterState cluster;

    CostFunction() {
    }

    boolean isNeeded() {
        return true;
    }

    float getMultiplier() {
        return this.multiplier;
    }

    void setMultiplier(float m3) {
        this.multiplier = m3;
    }

    void prepare(BalancerClusterState cluster) {
        this.cluster = cluster;
    }

    void postAction(BalanceAction action) {
        switch (action.getType()) {
            case NULL: {
                break;
            }
            case ASSIGN_REGION: {
                AssignRegionAction ar = (AssignRegionAction)action;
                this.regionMoved(ar.getRegion(), -1, ar.getServer());
                break;
            }
            case MOVE_REGION: {
                MoveRegionAction mra = (MoveRegionAction)action;
                this.regionMoved(mra.getRegion(), mra.getFromServer(), mra.getToServer());
                break;
            }
            case SWAP_REGIONS: {
                SwapRegionsAction a = (SwapRegionsAction)action;
                this.regionMoved(a.getFromRegion(), a.getFromServer(), a.getToServer());
                this.regionMoved(a.getToRegion(), a.getToServer(), a.getFromServer());
                break;
            }
            default: {
                throw new RuntimeException("Uknown action:" + (Object)((Object)action.getType()));
            }
        }
    }

    protected void regionMoved(int region, int oldServer, int newServer) {
    }

    protected abstract double cost();

    protected static double scale(double min2, double max, double value) {
        if (max <= min2 || value <= min2 || Math.abs(max - min2) <= 1.0E-4 || Math.abs(value - min2) <= 1.0E-4) {
            return 0.0;
        }
        if (max <= min2 || Math.abs(max - min2) <= 1.0E-4) {
            return 0.0;
        }
        return Math.max(0.0, Math.min(1.0, (value - min2) / (max - min2)));
    }

    public void updateWeight(double[] weights) {
        int n = StochasticLoadBalancer.GeneratorType.RANDOM.ordinal();
        weights[n] = weights[n] + this.cost();
    }
}

