/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.agrona.concurrent.errors;

import java.io.PrintStream;
import java.util.Objects;
import org.apache.hadoop.hbase.shaded.org.agrona.ErrorHandler;
import org.apache.hadoop.hbase.shaded.org.agrona.concurrent.errors.DistinctErrorLog;

public class LoggingErrorHandler
implements ErrorHandler,
AutoCloseable {
    private volatile boolean isClosed;
    private final DistinctErrorLog log;
    private final PrintStream errorOverflow;

    public LoggingErrorHandler(DistinctErrorLog log) {
        this(log, System.err);
    }

    public LoggingErrorHandler(DistinctErrorLog log, PrintStream errorOverflow) {
        Objects.requireNonNull(log, "log");
        Objects.requireNonNull(log, "errorOverflow");
        this.log = log;
        this.errorOverflow = errorOverflow;
    }

    @Override
    public void close() {
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public DistinctErrorLog distinctErrorLog() {
        return this.log;
    }

    public PrintStream errorOverflow() {
        return this.errorOverflow;
    }

    @Override
    public void onError(Throwable throwable) {
        if (this.isClosed) {
            this.errorOverflow.println("error log is closed");
            throwable.printStackTrace(this.errorOverflow);
        } else if (!this.log.record(throwable)) {
            this.errorOverflow.println("error log is full, consider increasing length of error buffer");
            throwable.printStackTrace(this.errorOverflow);
        }
    }
}

