/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.org.glassfish.jersey.client.innate.http;

import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import org.apache.hbase.thirdparty.org.glassfish.jersey.client.internal.LocalizationMessages;

final class SniConfigurator {
    private static final Logger LOGGER = Logger.getLogger(SniConfigurator.class.getName());
    private final String hostName;

    private SniConfigurator(String hostName) {
        this.hostName = hostName;
    }

    String getHostName() {
        return this.hostName;
    }

    static Optional<SniConfigurator> createWhenHostHeader(URI hostUri, Map<String, List<Object>> headers, boolean whenDiffer) {
        List<Object> hostHeaders = headers.get("Host");
        if (hostHeaders == null || hostHeaders.get(0) == null) {
            return Optional.empty();
        }
        String hostHeader = hostHeaders.get(0).toString();
        if (hostHeader == null) {
            return Optional.empty();
        }
        int index = hostHeader.indexOf(58);
        String trimmedHeader0 = index != -1 ? hostHeader.substring(0, index).trim() : hostHeader.trim();
        String trimmedHeader = trimmedHeader0.isEmpty() ? hostHeader : trimmedHeader0;
        String hostUriString = hostUri.getHost();
        if (!whenDiffer && hostUriString.equals(trimmedHeader)) {
            return Optional.empty();
        }
        return Optional.of(new SniConfigurator(trimmedHeader));
    }

    void setServerNames(SSLEngine sslEngine) {
        SSLParameters sslParameters = sslEngine.getSSLParameters();
        this.updateSSLParameters(sslParameters);
        sslEngine.setSSLParameters(sslParameters);
        LOGGER.fine(LocalizationMessages.SNI_ON_SSLENGINE());
    }

    void setServerNames(SSLSocket sslSocket) {
        SSLParameters sslParameters = sslSocket.getSSLParameters();
        this.updateSSLParameters(sslParameters);
        sslSocket.setSSLParameters(sslParameters);
        LOGGER.fine(LocalizationMessages.SNI_ON_SSLSOCKET());
    }

    private SSLParameters updateSSLParameters(SSLParameters sslParameters) {
        SNIHostName serverName = new SNIHostName(this.hostName);
        LinkedList<SNIServerName> serverNames = new LinkedList<SNIServerName>();
        serverNames.add(serverName);
        sslParameters.setServerNames(serverNames);
        LOGGER.finer(LocalizationMessages.SNI_UPDATE_SSLPARAMS(this.hostName));
        return sslParameters;
    }
}

