/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.io.AcidInputFormat;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.RecordReader;

class VectorizedOrcAcidRowReader
implements RecordReader<NullWritable, VectorizedRowBatch> {
    private final AcidInputFormat.RowReader<OrcStruct> innerReader;
    private final RecordIdentifier key;
    private final OrcStruct value;
    private VectorizedRowBatchCtx rbCtx;
    private Object[] partitionValues;
    private final ObjectInspector objectInspector;
    private final DataOutputBuffer buffer = new DataOutputBuffer();

    VectorizedOrcAcidRowReader(AcidInputFormat.RowReader<OrcStruct> inner, Configuration conf, VectorizedRowBatchCtx vectorizedRowBatchCtx, FileSplit split) throws IOException {
        this.innerReader = inner;
        this.key = (RecordIdentifier)inner.createKey();
        this.rbCtx = vectorizedRowBatchCtx;
        int partitionColumnCount = this.rbCtx.getPartitionColumnCount();
        if (partitionColumnCount > 0) {
            this.partitionValues = new Object[partitionColumnCount];
            VectorizedRowBatchCtx.getPartitionValues(this.rbCtx, conf, split, this.partitionValues);
        }
        this.value = (OrcStruct)inner.createValue();
        this.objectInspector = inner.getObjectInspector();
    }

    public boolean next(NullWritable nullWritable, VectorizedRowBatch vectorizedRowBatch) throws IOException {
        vectorizedRowBatch.reset();
        this.buffer.reset();
        if (!this.innerReader.next(this.key, this.value)) {
            return false;
        }
        if (this.partitionValues != null) {
            this.rbCtx.addPartitionColsToBatch(vectorizedRowBatch, this.partitionValues);
        }
        try {
            VectorizedBatchUtil.acidAddRowToBatch(this.value, (StructObjectInspector)this.objectInspector, vectorizedRowBatch.size++, vectorizedRowBatch, this.rbCtx, this.buffer);
            while (vectorizedRowBatch.size < vectorizedRowBatch.selected.length && this.innerReader.next(this.key, this.value)) {
                VectorizedBatchUtil.acidAddRowToBatch(this.value, (StructObjectInspector)this.objectInspector, vectorizedRowBatch.size++, vectorizedRowBatch, this.rbCtx, this.buffer);
            }
        }
        catch (Exception e) {
            throw new IOException("error iterating", e);
        }
        return true;
    }

    public NullWritable createKey() {
        return NullWritable.get();
    }

    public VectorizedRowBatch createValue() {
        return this.rbCtx.createVectorizedRowBatch();
    }

    public long getPos() throws IOException {
        return this.innerReader.getPos();
    }

    public void close() throws IOException {
        this.innerReader.close();
    }

    public float getProgress() throws IOException {
        return this.innerReader.getProgress();
    }
}

