/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cli;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import jline.TerminalFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapStatusOptionsProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(LlapStatusOptionsProcessor.class);
    private static final String LLAPSTATUS_CONSTANT = "llapstatus";
    private static final long FIND_YARN_APP_TIMEOUT_MS = 20000L;
    private final Options options = new Options();
    private CommandLine commandLine;

    public LlapStatusOptionsProcessor() {
        for (OptionConstants optionConstant : OptionConstants.values()) {
            OptionBuilder.hasArgs((int)optionConstant.getNumArgs());
            OptionBuilder.withArgName((String)optionConstant.getArgName());
            OptionBuilder.withLongOpt((String)optionConstant.getLongOpt());
            OptionBuilder optionBuilder = OptionBuilder.withDescription((String)optionConstant.getDescription());
            if (optionConstant.getShortOpt() == null) {
                this.options.addOption(optionBuilder.create());
                continue;
            }
            this.options.addOption(OptionBuilder.create((char)optionConstant.getShortOpt().charValue()));
        }
    }

    public LlapStatusOptions processOptions(String[] args) throws ParseException {
        this.commandLine = new GnuParser().parse(this.options, args);
        if (this.commandLine.hasOption(OptionConstants.HELP.getShortOpt().charValue())) {
            this.printUsage();
            return null;
        }
        String name = this.commandLine.getOptionValue(OptionConstants.NAME.getLongOpt());
        long findAppTimeoutMs = 20000L;
        if (this.commandLine.hasOption(OptionConstants.FIND_APP_TIMEOUT.getLongOpt())) {
            findAppTimeoutMs = TimeUnit.MILLISECONDS.convert(Long.parseLong(this.commandLine.getOptionValue(OptionConstants.FIND_APP_TIMEOUT.getLongOpt())), TimeUnit.SECONDS);
        }
        Properties hiveConf = this.commandLine.hasOption(OptionConstants.HIVECONF.getLongOpt()) ? this.commandLine.getOptionProperties(OptionConstants.HIVECONF.getLongOpt()) : new Properties();
        return new LlapStatusOptions(name, hiveConf, findAppTimeoutMs);
    }

    private void printUsage() {
        HelpFormatter hf = new HelpFormatter();
        try {
            int width = hf.getWidth();
            int jlineWidth = TerminalFactory.get().getWidth();
            width = Math.min(160, Math.max(jlineWidth, width));
            hf.setWidth(width);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        hf.printHelp(LLAPSTATUS_CONSTANT, this.options);
    }

    public static class LlapStatusOptions {
        private final String name;
        private final Properties conf;
        private final long findAppTimeoutMs;

        LlapStatusOptions(String name, Properties hiveProperties, long findAppTimeoutMs) {
            this.name = name;
            this.conf = hiveProperties;
            this.findAppTimeoutMs = findAppTimeoutMs;
        }

        public String getName() {
            return this.name;
        }

        public Properties getConf() {
            return this.conf;
        }

        public long getFindAppTimeoutMs() {
            return this.findAppTimeoutMs;
        }
    }

    static enum OptionConstants {
        NAME("name", 'n', "LLAP cluster name"),
        FIND_APP_TIMEOUT("findAppTimeout", 'f', "Amount of time(s) that the tool will sleep to wait for the YARN application to start. negative values=wait forever, 0=Do not wait. default=" + TimeUnit.SECONDS.convert(20000L, TimeUnit.MILLISECONDS) + "s"),
        HIVECONF("hiveconf", null, "Use value for given property. Overridden by explicit parameters", "property=value", 2),
        HELP("help", 'H', "Print help information");

        private final String longOpt;
        private final Character shortOpt;
        private final String description;
        private final String argName;
        private final int numArgs;

        private OptionConstants(String longOpt, char shortOpt, String description) {
            this(longOpt, Character.valueOf(shortOpt), description, longOpt, 1);
        }

        private OptionConstants(String longOpt, Character shortOpt, String description, String argName, int numArgs) {
            this.longOpt = longOpt;
            this.shortOpt = shortOpt;
            this.description = description;
            this.argName = argName;
            this.numArgs = numArgs;
        }

        public String getLongOpt() {
            return this.longOpt;
        }

        public Character getShortOpt() {
            return this.shortOpt;
        }

        public String getDescription() {
            return this.description;
        }

        public String getArgName() {
            return this.argName;
        }

        public int getNumArgs() {
            return this.numArgs;
        }
    }
}

