/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.shufflehandler;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.llap.shufflehandler.AttemptRegistrationListener;
import org.apache.hadoop.hive.llap.shufflehandler.ShuffleHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DirWatcher {
    private static final Logger LOG = LoggerFactory.getLogger(DirWatcher.class);
    private static final String OUTPUT = "output";
    private final AttemptRegistrationListener listener;
    private final WatchService watchService;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final WatcherCallable watcherCallable = new WatcherCallable();
    private final ListeningExecutorService watcherExecutorService;
    private volatile ListenableFuture<Void> watcherFuture;
    private final DelayQueue<WatchedPathInfo> watchedPathQueue = new DelayQueue();
    private final WatchExpirerCallable expirerCallable = new WatchExpirerCallable();
    private final ListeningExecutorService expirerExecutorService;
    private volatile ListenableFuture<Void> expirerFuture;
    private final ConcurrentMap<ShuffleHandler.AttemptPathIdentifier, FoundPathInfo> foundAttempts = new ConcurrentHashMap<ShuffleHandler.AttemptPathIdentifier, FoundPathInfo>();
    private final ConcurrentMap<java.nio.file.Path, WatchedPathInfo> watchedPaths = new ConcurrentHashMap<java.nio.file.Path, WatchedPathInfo>();
    private final ConcurrentMap<ShuffleHandler.AttemptPathIdentifier, List<WatchKey>> watchesPerAttempt = new ConcurrentHashMap<ShuffleHandler.AttemptPathIdentifier, List<WatchKey>>();

    DirWatcher(AttemptRegistrationListener listener) throws IOException {
        this.watchService = FileSystems.getDefault().newWatchService();
        this.listener = listener;
        ExecutorService executor1 = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("DirWatcher").build());
        this.watcherExecutorService = MoreExecutors.listeningDecorator((ExecutorService)executor1);
        ExecutorService executor2 = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("WatchExpirer").build());
        this.expirerExecutorService = MoreExecutors.listeningDecorator((ExecutorService)executor2);
    }

    void registerDagDir(String pathString, String appId, int dagIdentifier, String user, long expiry) throws IOException {
        java.nio.file.Path path = FileSystems.getDefault().getPath(pathString, new String[0]);
        WatchedPathInfo watchedPathInfo = new WatchedPathInfo(System.currentTimeMillis() + expiry, Type.BASE, appId, dagIdentifier, user);
        this.watchedPaths.put(path, watchedPathInfo);
        WatchKey watchKey = path.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE);
        watchedPathInfo.setWatchKey(watchKey);
        this.watchedPathQueue.add(watchedPathInfo);
    }

    void unregisterDagDir(String pathString, String appId, int dagIdentifier) {
    }

    void attemptInfoFound(ShuffleHandler.AttemptPathIdentifier pathIdentifier) {
        this.cancelWatchesForAttempt(pathIdentifier);
    }

    void start() {
        this.watcherFuture = this.watcherExecutorService.submit((Callable)this.watcherCallable);
        this.expirerFuture = this.expirerExecutorService.submit((Callable)this.expirerCallable);
    }

    void stop() throws IOException {
        this.shutdown.set(true);
        if (this.watcherFuture != null) {
            this.watcherFuture.cancel(true);
        }
        if (this.expirerFuture != null) {
            this.expirerFuture.cancel(true);
        }
        this.watchService.close();
        this.watcherExecutorService.shutdownNow();
        this.expirerExecutorService.shutdownNow();
    }

    private void registerDir(java.nio.file.Path path, WatchedPathInfo watchedPathInfo) {
        this.watchedPaths.put(path, watchedPathInfo);
        try {
            WatchKey watchKey = path.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE);
            watchedPathInfo.setWatchKey(watchKey);
            this.watchedPathQueue.add(watchedPathInfo);
            if (watchedPathInfo.type == Type.FINAL) {
                this.trackWatchForAttempt(watchedPathInfo, watchKey);
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to setup watch for: " + path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trackWatchForAttempt(WatchedPathInfo watchedPathInfo, WatchKey watchKey) {
        assert (watchedPathInfo.pathIdentifier != null);
        ConcurrentMap<ShuffleHandler.AttemptPathIdentifier, List<WatchKey>> concurrentMap = this.watchesPerAttempt;
        synchronized (concurrentMap) {
            LinkedList<WatchKey> list = (LinkedList<WatchKey>)this.watchesPerAttempt.get(watchedPathInfo.pathIdentifier);
            if (list == null) {
                list = new LinkedList<WatchKey>();
                this.watchesPerAttempt.put(watchedPathInfo.pathIdentifier, list);
            }
            list.add(watchKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelWatchesForAttempt(ShuffleHandler.AttemptPathIdentifier pathIdentifier) {
        ConcurrentMap<ShuffleHandler.AttemptPathIdentifier, List<WatchKey>> concurrentMap = this.watchesPerAttempt;
        synchronized (concurrentMap) {
            List list = (List)this.watchesPerAttempt.remove(pathIdentifier);
            if (list != null) {
                for (WatchKey watchKey : list) {
                    watchKey.cancel();
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void watch() {
        while (!this.shutdown.get()) {
            try {
                watchKey = this.watchService.take();
            }
            catch (InterruptedException e) {
                if (this.shutdown.get()) {
                    DirWatcher.LOG.info("Shutting down watcher");
                    break;
                }
                DirWatcher.LOG.error("Watcher interrupted before being shutdown");
                throw new RuntimeException("Watcher interrupted before being shutdown", e);
            }
            watchedPath = (java.nio.file.Path)watchKey.watchable();
            parentWatchedPathInfo = (WatchedPathInfo)this.watchedPaths.get(watchedPath);
            cancelledWatch = false;
            for (WatchEvent<?> rawEvent : watchKey.pollEvents()) {
                if (rawEvent.kind().equals(StandardWatchEventKinds.OVERFLOW)) continue;
                event = rawEvent;
                switch (1.$SwitchMap$org$apache$hadoop$hive$llap$shufflehandler$DirWatcher$Type[parentWatchedPathInfo.type.ordinal()]) {
                    case 1: {
                        if (!((java.nio.file.Path)event.context()).getFileName().toString().equals("output")) ** GOTO lbl55
                        resolvedPath = watchedPath.resolve((java.nio.file.Path)event.context());
                        watchedPathInfo = new WatchedPathInfo(parentWatchedPathInfo, Type.OUTPUT, null);
                        this.registerDir(resolvedPath, watchedPathInfo);
                        try {
                            dirStream = Files.newDirectoryStream(resolvedPath);
                            var11_14 = null;
                            try {
                                for (java.nio.file.Path path : dirStream) {
                                    if (path.toFile().isDirectory()) {
                                        watchedPathInfo = new WatchedPathInfo(parentWatchedPathInfo, Type.FINAL, path.getFileName().toString());
                                        this.registerDir(path, watchedPathInfo);
                                        this.scanForFinalFiles(watchedPathInfo, path);
                                        continue;
                                    }
                                    DirWatcher.LOG.warn("Ignoring unexpected file: " + path);
                                }
                            }
                            catch (Throwable var12_17) {
                                var11_14 = var12_17;
                                throw var12_17;
                            }
                            finally {
                                if (dirStream != null) {
                                    if (var11_14 != null) {
                                        try {
                                            dirStream.close();
                                        }
                                        catch (Throwable x2) {
                                            var11_14.addSuppressed(x2);
                                        }
                                    } else {
                                        dirStream.close();
                                    }
                                }
                            }
                        }
                        catch (IOException e) {
                            DirWatcher.LOG.warn("Unable to list files under: " + resolvedPath);
                        }
                        cancelledWatch = true;
                        watchKey.cancel();
                        break;
lbl55:
                        // 1 sources

                        DirWatcher.LOG.warn("DEBUG: Found unexpected directory while looking for OUTPUT: " + event.context() + " under " + watchedPath);
                        break;
                    }
                    case 2: {
                        resolvedPath = watchedPath.resolve((java.nio.file.Path)event.context());
                        watchedPathInfo = new WatchedPathInfo(parentWatchedPathInfo, Type.FINAL, ((java.nio.file.Path)event.context()).getFileName().toString());
                        this.registerDir(resolvedPath, watchedPathInfo);
                        this.scanForFinalFiles(watchedPathInfo, resolvedPath);
                        break;
                    }
                    case 3: {
                        resolvedPath = watchedPath.resolve((java.nio.file.Path)event.context());
                        if (((java.nio.file.Path)event.context()).getFileName().toString().equals("file.out")) {
                            this.registerFoundAttempt(parentWatchedPathInfo.pathIdentifier, null, resolvedPath);
                            break;
                        }
                        if (((java.nio.file.Path)event.context()).getFileName().toString().equals("file.out.index")) {
                            this.registerFoundAttempt(parentWatchedPathInfo.pathIdentifier, resolvedPath, null);
                            break;
                        }
                        DirWatcher.LOG.warn("Ignoring unexpected file: " + watchedPath.resolve((java.nio.file.Path)event.context()));
                    }
                }
            }
            if (cancelledWatch || (valid = watchKey.reset())) continue;
            DirWatcher.LOG.warn("DEBUG: WatchKey: " + watchKey.watchable() + " no longer valid");
        }
    }

    private void scanForFinalFiles(WatchedPathInfo watchedPathInfo, java.nio.file.Path path) {
        try (DirectoryStream<java.nio.file.Path> dirStream = Files.newDirectoryStream(path);){
            for (java.nio.file.Path p : dirStream) {
                if (p.getFileName().toString().equals("file.out")) {
                    this.registerFoundAttempt(watchedPathInfo.pathIdentifier, null, path);
                    continue;
                }
                if (p.getFileName().toString().equals("file.out.index")) {
                    this.registerFoundAttempt(watchedPathInfo.pathIdentifier, path, null);
                    continue;
                }
                LOG.warn("Ignoring unknown file: " + p.getFileName());
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to open dir stream for attemptDir: " + path);
        }
    }

    private void registerFoundAttempt(ShuffleHandler.AttemptPathIdentifier pathIdentifier, java.nio.file.Path indexFile, java.nio.file.Path dataFile) {
        FoundPathInfo pathInfo = (FoundPathInfo)this.foundAttempts.get(pathIdentifier);
        if (pathInfo == null) {
            pathInfo = new FoundPathInfo(indexFile, dataFile);
            this.foundAttempts.put(pathIdentifier, pathInfo);
        }
        if (pathInfo.isComplete()) {
            this.listener.registerAttemptDirs(pathIdentifier, new ShuffleHandler.AttemptPathInfo(new Path(indexFile.toUri()), new Path(dataFile.toUri())));
            this.cancelWatchesForAttempt(pathIdentifier);
            this.foundAttempts.remove(pathIdentifier);
        }
    }

    private static class WatchedPathInfo
    implements Delayed {
        final long expiry;
        final Type type;
        final String appId;
        final int dagId;
        final String user;
        final String attemptId;
        final ShuffleHandler.AttemptPathIdentifier pathIdentifier;
        WatchKey watchKey;

        public WatchedPathInfo(long expiry, Type type, String jobId, int dagId, String user) {
            this.expiry = expiry;
            this.type = type;
            this.appId = jobId;
            this.dagId = dagId;
            this.user = user;
            this.attemptId = null;
            this.pathIdentifier = null;
        }

        public WatchedPathInfo(WatchedPathInfo other, Type type, String attemptId) {
            this.expiry = other.expiry;
            this.appId = other.appId;
            this.user = other.user;
            this.dagId = other.dagId;
            this.type = type;
            this.attemptId = attemptId;
            this.pathIdentifier = attemptId != null ? new ShuffleHandler.AttemptPathIdentifier(this.appId, this.dagId, this.user, attemptId) : null;
        }

        synchronized void setWatchKey(WatchKey watchKey) {
            this.watchKey = watchKey;
        }

        synchronized WatchKey getWatchKey() {
            return this.watchKey;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return this.expiry - System.currentTimeMillis();
        }

        @Override
        public int compareTo(Delayed o) {
            WatchedPathInfo other = (WatchedPathInfo)o;
            if (other.expiry > this.expiry) {
                return -1;
            }
            if (other.expiry < this.expiry) {
                return 1;
            }
            return 0;
        }
    }

    private static class FoundPathInfo {
        java.nio.file.Path indexPath;
        java.nio.file.Path dataPath;

        public FoundPathInfo(java.nio.file.Path indexPath, java.nio.file.Path dataPath) {
            this.indexPath = indexPath;
            this.dataPath = dataPath;
        }

        boolean isComplete() {
            return this.indexPath != null && this.dataPath != null;
        }
    }

    private class WatchExpirerCallable
    implements Callable<Void> {
        private WatchExpirerCallable() {
        }

        @Override
        public Void call() {
            while (!DirWatcher.this.shutdown.get()) {
                WatchedPathInfo pathInfo;
                try {
                    pathInfo = (WatchedPathInfo)DirWatcher.this.watchedPathQueue.take();
                }
                catch (InterruptedException e) {
                    if (DirWatcher.this.shutdown.get()) {
                        LOG.info("Shutting down WatchExpirer");
                        break;
                    }
                    LOG.error("WatchExpirer interrupted before being shutdown");
                    throw new RuntimeException("WatchExpirer interrupted before being shutdown", e);
                }
                WatchKey watchKey = pathInfo.getWatchKey();
                if (watchKey == null || !watchKey.isValid()) continue;
                watchKey.cancel();
            }
            return null;
        }
    }

    private class WatcherCallable
    implements Callable<Void> {
        private WatcherCallable() {
        }

        @Override
        public Void call() throws Exception {
            DirWatcher.this.watch();
            return null;
        }
    }

    private static enum Type {
        BASE,
        OUTPUT,
        FINAL;

    }
}

