/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.shufflehandler;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.cache.Weigher;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.util.NetUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.crypto.SecretKey;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.llap.shufflehandler.AttemptRegistrationListener;
import org.apache.hadoop.hive.llap.shufflehandler.DirWatcher;
import org.apache.hadoop.hive.llap.shufflehandler.FadvisedChunkedFile;
import org.apache.hadoop.hive.llap.shufflehandler.FadvisedFileRegion;
import org.apache.hadoop.hive.llap.shufflehandler.IndexCache;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.ReadaheadPool;
import org.apache.hadoop.io.SecureIOUtils;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.MutableCounterInt;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.tez.common.security.JobTokenIdentifier;
import org.apache.tez.common.security.JobTokenSecretManager;
import org.apache.tez.runtime.library.common.security.SecureShuffleUtils;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.ShuffleHeader;
import org.apache.tez.runtime.library.common.sort.impl.TezIndexRecord;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.http.QueryStringDecoder;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;
import org.jboss.netty.handler.timeout.IdleState;
import org.jboss.netty.handler.timeout.IdleStateAwareChannelHandler;
import org.jboss.netty.handler.timeout.IdleStateEvent;
import org.jboss.netty.handler.timeout.IdleStateHandler;
import org.jboss.netty.util.CharsetUtil;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleHandler
implements AttemptRegistrationListener {
    private static final Logger LOG = LoggerFactory.getLogger(ShuffleHandler.class);
    public static final String SHUFFLE_HANDLER_LOCAL_DIRS = "llap.shuffle.handler.local-dirs";
    public static final String SHUFFLE_MANAGE_OS_CACHE = "llap.shuffle.manage.os.cache";
    public static final boolean DEFAULT_SHUFFLE_MANAGE_OS_CACHE = true;
    public static final String SHUFFLE_OS_CACHE_ALWAYS_EVICT = "llap.shuffle.os.cache.always.evict";
    public static final boolean DEFAULT_SHUFFLE_OS_CACHE_ALWAYS_EVICT = false;
    public static final String SHUFFLE_READAHEAD_BYTES = "llap.shuffle.readahead.bytes";
    public static final int DEFAULT_SHUFFLE_READAHEAD_BYTES = 0x400000;
    public static final String SHUFFLE_DIR_WATCHER_ENABLED = "llap.shuffle.dir-watcher.enabled";
    public static final boolean SHUFFLE_DIR_WATCHER_ENABLED_DEFAULT = false;
    private static final Pattern IGNORABLE_ERROR_MESSAGE = Pattern.compile("^.*(?:connection.*reset|connection.*closed|broken.*pipe).*$", 2);
    private int port;
    private final ChannelFactory selector;
    private final ChannelGroup accepted = new DefaultChannelGroup();
    protected HttpPipelineFactory pipelineFact;
    private final int sslFileBufferSize;
    private final Configuration conf;
    private final String[] localDirs;
    private final DirWatcher dirWatcher;
    private final boolean manageOsCache;
    private final boolean shouldAlwaysEvictOsCache;
    private final int readaheadLength;
    private final int maxShuffleConnections;
    private final int shuffleBufferSize;
    private final boolean shuffleTransferToAllowed;
    private final ReadaheadPool readaheadPool = ReadaheadPool.getInstance();
    private final ConcurrentMap<String, Integer> registeredApps = new ConcurrentHashMap<String, Integer>();
    private final ConcurrentMap<String, String> userRsrc;
    private JobTokenSecretManager secretManager;
    public static final String SHUFFLE_PORT_CONFIG_KEY = "llap.shuffle.port";
    public static final int DEFAULT_SHUFFLE_PORT = 15551;
    public static final String SHUFFLE_CONNECTION_KEEP_ALIVE_ENABLED = "llap.shuffle.connection-keep-alive.enable";
    public static final boolean DEFAULT_SHUFFLE_CONNECTION_KEEP_ALIVE_ENABLED = true;
    public static final String SHUFFLE_CONNECTION_KEEP_ALIVE_TIME_OUT = "llap.shuffle.connection-keep-alive.timeout";
    public static final int DEFAULT_SHUFFLE_CONNECTION_KEEP_ALIVE_TIME_OUT = 5;
    public static final String SHUFFLE_MAPOUTPUT_META_INFO_CACHE_SIZE = "llap.shuffle.mapoutput-info.meta.cache.size";
    public static final int DEFAULT_SHUFFLE_MAPOUTPUT_META_INFO_CACHE_SIZE = 10000;
    public static final String CONNECTION_CLOSE = "close";
    public static final String SUFFLE_SSL_FILE_BUFFER_SIZE_KEY = "llap.shuffle.ssl.file.buffer.size";
    public static final int DEFAULT_SUFFLE_SSL_FILE_BUFFER_SIZE = 61440;
    public static final String MAX_SHUFFLE_CONNECTIONS = "llap.shuffle.max.connections";
    public static final int DEFAULT_MAX_SHUFFLE_CONNECTIONS = 0;
    public static final String MAX_SHUFFLE_THREADS = "llap.shuffle.max.threads";
    public static final int DEFAULT_MAX_SHUFFLE_THREADS = Runtime.getRuntime().availableProcessors() * 3;
    public static final String SHUFFLE_BUFFER_SIZE = "llap.shuffle.transfer.buffer.size";
    public static final int DEFAULT_SHUFFLE_BUFFER_SIZE = 131072;
    public static final String SHUFFLE_TRANSFERTO_ALLOWED = "llap.shuffle.transferTo.allowed";
    public static final boolean DEFAULT_SHUFFLE_TRANSFERTO_ALLOWED = true;
    static final String DATA_FILE_NAME = "file.out";
    static final String INDEX_FILE_NAME = "file.out.index";
    private static final AtomicBoolean started = new AtomicBoolean(false);
    private static final AtomicBoolean initing = new AtomicBoolean(false);
    private static ShuffleHandler INSTANCE;
    private static final String TIMEOUT_HANDLER = "timeout";
    final boolean connectionKeepAliveEnabled;
    final int connectionKeepAliveTimeOut;
    final int mapOutputMetaInfoCacheSize;
    Timer timer;
    private final LocalDirAllocator lDirAlloc = new LocalDirAllocator("llap.shuffle.handler.local-dirs");
    private final Shuffle shuffle;
    private static final String USERCACHE_CONSTANT = "usercache";
    private static final String APPCACHE_CONSTANT = "appcache";

    @Override
    public void registerAttemptDirs(AttemptPathIdentifier identifier, AttemptPathInfo pathInfo) {
        this.shuffle.registerAttemptDirs(identifier, pathInfo);
    }

    private ShuffleHandler(Configuration conf) {
        this.conf = conf;
        this.manageOsCache = conf.getBoolean(SHUFFLE_MANAGE_OS_CACHE, true);
        this.shouldAlwaysEvictOsCache = conf.getBoolean(SHUFFLE_OS_CACHE_ALWAYS_EVICT, false);
        this.readaheadLength = conf.getInt(SHUFFLE_READAHEAD_BYTES, 0x400000);
        this.maxShuffleConnections = conf.getInt(MAX_SHUFFLE_CONNECTIONS, 0);
        int maxShuffleThreads = conf.getInt(MAX_SHUFFLE_THREADS, DEFAULT_MAX_SHUFFLE_THREADS);
        if (maxShuffleThreads == 0) {
            maxShuffleThreads = 2 * Runtime.getRuntime().availableProcessors();
        }
        this.localDirs = conf.getTrimmedStrings(SHUFFLE_HANDLER_LOCAL_DIRS);
        this.shuffleBufferSize = conf.getInt(SHUFFLE_BUFFER_SIZE, 131072);
        this.shuffleTransferToAllowed = conf.getBoolean(SHUFFLE_TRANSFERTO_ALLOWED, true);
        ThreadFactory bossFactory = new ThreadFactoryBuilder().setNameFormat("ShuffleHandler Netty Boss #%d").build();
        ThreadFactory workerFactory = new ThreadFactoryBuilder().setNameFormat("ShuffleHandler Netty Worker #%d").build();
        this.selector = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(bossFactory), (Executor)Executors.newCachedThreadPool(workerFactory), maxShuffleThreads);
        this.sslFileBufferSize = conf.getInt(SUFFLE_SSL_FILE_BUFFER_SIZE_KEY, 61440);
        this.connectionKeepAliveEnabled = conf.getBoolean(SHUFFLE_CONNECTION_KEEP_ALIVE_ENABLED, true);
        this.connectionKeepAliveTimeOut = Math.max(1, conf.getInt(SHUFFLE_CONNECTION_KEEP_ALIVE_TIME_OUT, 5));
        this.mapOutputMetaInfoCacheSize = Math.max(1, conf.getInt(SHUFFLE_MAPOUTPUT_META_INFO_CACHE_SIZE, 10000));
        this.userRsrc = new ConcurrentHashMap<String, String>();
        this.secretManager = new JobTokenSecretManager();
        this.shuffle = new Shuffle(conf);
        if (conf.getBoolean(SHUFFLE_DIR_WATCHER_ENABLED, false)) {
            LOG.info("Attempting to start dirWatcher");
            DirWatcher localDirWatcher = null;
            try {
                localDirWatcher = new DirWatcher(this);
            }
            catch (IOException e) {
                LOG.warn("Unable to start DirWatcher. Active scans disabled");
            }
            this.dirWatcher = localDirWatcher;
        } else {
            LOG.info("DirWatcher disabled by config");
            this.dirWatcher = null;
        }
        LOG.info("manageOsCache:{}, shouldAlwaysEvictOsCache:{}, readaheadLength:{}, maxShuffleConnections:{}, localDirs:{}, shuffleBufferSize:{}, shuffleTransferToAllowed:{}, connectionKeepAliveEnabled:{}, connectionKeepAliveTimeOut:{}, mapOutputMetaInfoCacheSize:{}, sslFileBufferSize:{}", new Object[]{this.manageOsCache, this.shouldAlwaysEvictOsCache, this.readaheadLength, this.maxShuffleConnections, this.localDirs, this.shuffleBufferSize, this.shuffleTransferToAllowed, this.connectionKeepAliveEnabled, this.connectionKeepAliveTimeOut, this.mapOutputMetaInfoCacheSize, this.sslFileBufferSize});
    }

    public void start() throws Exception {
        ServerBootstrap bootstrap = new ServerBootstrap(this.selector);
        this.timer = new HashedWheelTimer();
        try {
            this.pipelineFact = new HttpPipelineFactory(this.conf, this.timer);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        bootstrap.setPipelineFactory((ChannelPipelineFactory)this.pipelineFact);
        bootstrap.setOption("backlog", (Object)NetUtil.SOMAXCONN);
        this.port = this.conf.getInt(SHUFFLE_PORT_CONFIG_KEY, 15551);
        Channel ch = bootstrap.bind((SocketAddress)new InetSocketAddress(this.port));
        this.accepted.add((Object)ch);
        this.port = ((InetSocketAddress)ch.getLocalAddress()).getPort();
        this.conf.set(SHUFFLE_PORT_CONFIG_KEY, Integer.toString(this.port));
        this.pipelineFact.SHUFFLE.setPort(this.port);
        if (this.dirWatcher != null) {
            this.dirWatcher.start();
        }
        LOG.info("LlapShuffleHandler listening on port " + this.port + " (SOMAXCONN: " + bootstrap.getOption("backlog") + ")");
    }

    public static void initializeAndStart(Configuration conf) throws Exception {
        if (!initing.getAndSet(true)) {
            INSTANCE = new ShuffleHandler(conf);
            INSTANCE.start();
            started.set(true);
        }
    }

    public static void shutdown() throws Exception {
        if (INSTANCE != null) {
            INSTANCE.stop();
        }
    }

    public static ShuffleHandler get() {
        Preconditions.checkState((boolean)started.get(), (Object)"ShuffleHandler must be started before invoking get");
        return INSTANCE;
    }

    public static ByteBuffer serializeMetaData(int port) throws IOException {
        DataOutputBuffer port_dob = new DataOutputBuffer();
        port_dob.writeInt(port);
        return ByteBuffer.wrap(port_dob.getData(), 0, port_dob.getLength());
    }

    public static int deserializeMetaData(ByteBuffer meta) throws IOException {
        DataInputByteBuffer in = new DataInputByteBuffer();
        in.reset(new ByteBuffer[]{meta});
        int port = in.readInt();
        return port;
    }

    public static ByteBuffer serializeServiceData(Token<JobTokenIdentifier> jobToken) throws IOException {
        DataOutputBuffer jobToken_dob = new DataOutputBuffer();
        jobToken.write((DataOutput)jobToken_dob);
        return ByteBuffer.wrap(jobToken_dob.getData(), 0, jobToken_dob.getLength());
    }

    static Token<JobTokenIdentifier> deserializeServiceData(ByteBuffer secret) throws IOException {
        DataInputByteBuffer in = new DataInputByteBuffer();
        in.reset(new ByteBuffer[]{secret});
        Token jt = new Token();
        jt.readFields((DataInput)in);
        return jt;
    }

    public int getPort() {
        return this.port;
    }

    public void registerDag(String applicationIdString, int dagIdentifier, Token<JobTokenIdentifier> appToken, String user, String[] appDirs) {
        Integer registeredDagIdentifier = this.registeredApps.putIfAbsent(applicationIdString, dagIdentifier);
        if (registeredDagIdentifier == null) {
            this.recordJobShuffleInfo(applicationIdString, user, appToken);
        }
        if (registeredDagIdentifier != null && !registeredDagIdentifier.equals(dagIdentifier)) {
            this.registeredApps.put(applicationIdString, dagIdentifier);
        }
        if (!(registeredDagIdentifier != null && registeredDagIdentifier.equals(dagIdentifier) || this.dirWatcher == null)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Registering watches for AppDirs: appId={}, dagId={}", (Object)applicationIdString, (Object)dagIdentifier);
            }
            for (String appDir : appDirs) {
                try {
                    this.dirWatcher.registerDagDir(appDir, applicationIdString, dagIdentifier, user, 300000L);
                }
                catch (IOException e) {
                    LOG.warn("Unable to register dir: " + appDir + " with watcher");
                }
            }
        }
    }

    public void unregisterDag(String dir, String applicationIdString, int dagIdentifier) {
        Integer currentDagIdentifier = (Integer)this.registeredApps.get(applicationIdString);
        if (currentDagIdentifier != null && currentDagIdentifier.equals(dagIdentifier)) {
            this.registeredApps.remove(applicationIdString);
            this.removeJobShuffleInfo(applicationIdString);
        }
        if (this.dirWatcher != null) {
            this.dirWatcher.unregisterDagDir(dir, applicationIdString, dagIdentifier);
        }
    }

    protected void stop() throws Exception {
        this.accepted.close().awaitUninterruptibly(10L, TimeUnit.SECONDS);
        if (this.selector != null) {
            ServerBootstrap bootstrap = new ServerBootstrap(this.selector);
            bootstrap.releaseExternalResources();
        }
        if (this.pipelineFact != null) {
            this.pipelineFact.destroy();
        }
        if (this.timer != null) {
            this.timer.stop();
        }
        if (this.dirWatcher != null) {
            this.dirWatcher.stop();
        }
    }

    protected Shuffle getShuffle(Configuration conf) {
        return this.shuffle;
    }

    private void addJobToken(String appIdString, String user, Token<JobTokenIdentifier> jobToken) {
        String jobIdString = appIdString.replace("application", "job");
        this.userRsrc.putIfAbsent(jobIdString, user);
        this.secretManager.addTokenForJob(jobIdString, jobToken);
        LOG.info("Added token for " + jobIdString);
    }

    private void recordJobShuffleInfo(String appIdString, String user, Token<JobTokenIdentifier> jobToken) {
        this.addJobToken(appIdString, user, jobToken);
    }

    private void removeJobShuffleInfo(String appIdString) {
        this.secretManager.removeTokenForJob(appIdString);
        this.userRsrc.remove(appIdString);
    }

    private static String getBaseLocation(String jobIdString, int dagId, String user) {
        String[] parts = jobIdString.split("_");
        Preconditions.checkArgument((parts.length == 3 ? 1 : 0) != 0, (Object)"Invalid jobId. Expecting 3 parts");
        ApplicationId appID = ApplicationId.newInstance((long)Long.parseLong(parts[1]), (int)Integer.parseInt(parts[2]));
        String baseStr = "usercache/" + user + "/" + APPCACHE_CONSTANT + "/" + ConverterUtils.toString((ApplicationId)appID) + "/" + dagId + "/output/";
        return baseStr;
    }

    static class AttemptPathIdentifier {
        private final String jobId;
        private final int dagId;
        private final String user;
        private final String attemptId;

        public AttemptPathIdentifier(String jobId, int dagId, String user, String attemptId) {
            this.jobId = jobId;
            this.dagId = dagId;
            this.user = user;
            this.attemptId = attemptId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AttemptPathIdentifier that = (AttemptPathIdentifier)o;
            if (this.dagId != that.dagId) {
                return false;
            }
            if (!this.jobId.equals(that.jobId)) {
                return false;
            }
            return this.attemptId.equals(that.attemptId);
        }

        public int hashCode() {
            int result = this.jobId.hashCode();
            result = 31 * result + this.dagId;
            result = 31 * result + this.attemptId.hashCode();
            return result;
        }

        public String toString() {
            return "AttemptPathIdentifier{jobId='" + this.jobId + '\'' + ", dagId=" + this.dagId + ", user='" + this.user + '\'' + ", attemptId='" + this.attemptId + '\'' + '}';
        }
    }

    static class AttemptPathInfo {
        private final Path indexPath;
        private final Path dataPath;

        public AttemptPathInfo(Path indexPath, Path dataPath) {
            this.indexPath = indexPath;
            this.dataPath = dataPath;
        }
    }

    class Shuffle
    extends SimpleChannelUpstreamHandler {
        private final Configuration conf;
        private final IndexCache indexCache;
        private int port;
        private final LoadingCache<AttemptPathIdentifier, AttemptPathInfo> pathCache = CacheBuilder.newBuilder().expireAfterAccess(300L, TimeUnit.SECONDS).softValues().concurrencyLevel(16).removalListener((RemovalListener)new RemovalListener<AttemptPathIdentifier, AttemptPathInfo>(){

            public void onRemoval(RemovalNotification<AttemptPathIdentifier, AttemptPathInfo> notification) {
                LOG.debug("PathCacheEviction: " + notification.getKey() + ", Reason=" + notification.getCause());
            }
        }).maximumWeight(0xA00000L).weigher((Weigher)new Weigher<AttemptPathIdentifier, AttemptPathInfo>(){

            public int weigh(AttemptPathIdentifier key, AttemptPathInfo value) {
                return key.jobId.length() + key.user.length() + key.attemptId.length() + value.indexPath.toString().length() + value.dataPath.toString().length();
            }
        }).build((CacheLoader)new CacheLoader<AttemptPathIdentifier, AttemptPathInfo>(){

            public AttemptPathInfo load(AttemptPathIdentifier key) throws Exception {
                String base = ShuffleHandler.getBaseLocation(key.jobId, key.dagId, key.user);
                String attemptBase = base + key.attemptId;
                Path indexFileName = ShuffleHandler.this.lDirAlloc.getLocalPathToRead(attemptBase + "/" + ShuffleHandler.INDEX_FILE_NAME, Shuffle.this.conf);
                Path mapOutputFileName = ShuffleHandler.this.lDirAlloc.getLocalPathToRead(attemptBase + "/" + ShuffleHandler.DATA_FILE_NAME, Shuffle.this.conf);
                LOG.debug("Loaded : " + key + " via loader");
                if (ShuffleHandler.this.dirWatcher != null) {
                    ShuffleHandler.this.dirWatcher.attemptInfoFound(key);
                }
                return new AttemptPathInfo(indexFileName, mapOutputFileName);
            }
        });

        public Shuffle(Configuration conf) {
            this.conf = conf;
            this.indexCache = new IndexCache(conf);
            this.port = conf.getInt(ShuffleHandler.SHUFFLE_PORT_CONFIG_KEY, 15551);
        }

        public void setPort(int port) {
            this.port = port;
        }

        void registerAttemptDirs(AttemptPathIdentifier identifier, AttemptPathInfo pathInfo) {
            LOG.debug("Registering " + identifier + " via watcher");
            this.pathCache.put((Object)identifier, (Object)pathInfo);
        }

        private List<String> splitMaps(List<String> mapq) {
            if (null == mapq) {
                return null;
            }
            ArrayList<String> ret = new ArrayList<String>();
            for (String s : mapq) {
                Collections.addAll(ret, s.split(","));
            }
            return ret;
        }

        public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent evt) throws Exception {
            if (ShuffleHandler.this.maxShuffleConnections > 0 && ShuffleHandler.this.accepted.size() >= ShuffleHandler.this.maxShuffleConnections) {
                LOG.info(String.format("Current number of shuffle connections (%d) is greater than or equal to the max allowed shuffle connections (%d)", ShuffleHandler.this.accepted.size(), ShuffleHandler.this.maxShuffleConnections));
                evt.getChannel().close();
                return;
            }
            ShuffleHandler.this.accepted.add((Object)evt.getChannel());
            super.channelOpen(ctx, evt);
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent evt) throws Exception {
            int dagId;
            String jobId;
            int reduceId;
            HttpRequest request = (HttpRequest)evt.getMessage();
            if (request.getMethod() != HttpMethod.GET) {
                this.sendError(ctx, HttpResponseStatus.METHOD_NOT_ALLOWED);
                return;
            }
            if (!"mapreduce".equals(request.headers().get("name")) || !"1.0.0".equals(request.headers().get("version"))) {
                this.sendError(ctx, "Incompatible shuffle request version", HttpResponseStatus.BAD_REQUEST);
            }
            Map q = new QueryStringDecoder(request.getUri()).getParameters();
            List keepAliveList = (List)q.get("keepAlive");
            boolean keepAliveParam = false;
            if (keepAliveList != null && keepAliveList.size() == 1) {
                keepAliveParam = Boolean.parseBoolean((String)keepAliveList.get(0));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("KeepAliveParam : " + keepAliveList + " : " + keepAliveParam);
                }
            }
            List<String> mapIds = this.splitMaps((List)q.get("map"));
            List reduceQ = (List)q.get("reduce");
            List jobQ = (List)q.get("job");
            List dagIdQ = (List)q.get("dag");
            if (LOG.isDebugEnabled()) {
                LOG.debug("RECV: " + request.getUri() + "\n  mapId: " + mapIds + "\n  reduceId: " + reduceQ + "\n  jobId: " + jobQ + "\n  dagId: " + dagIdQ + "\n  keepAlive: " + keepAliveParam);
            }
            if (mapIds == null || reduceQ == null || jobQ == null | dagIdQ == null) {
                this.sendError(ctx, "Required param job, map and reduce", HttpResponseStatus.BAD_REQUEST);
                return;
            }
            if (reduceQ.size() != 1 || jobQ.size() != 1 || dagIdQ.size() != 1) {
                this.sendError(ctx, "Too many job/reduce parameters", HttpResponseStatus.BAD_REQUEST);
                return;
            }
            try {
                reduceId = Integer.parseInt((String)reduceQ.get(0));
                jobId = (String)jobQ.get(0);
                dagId = Integer.parseInt((String)dagIdQ.get(0));
            }
            catch (NumberFormatException e) {
                this.sendError(ctx, "Bad reduce parameter", HttpResponseStatus.BAD_REQUEST);
                return;
            }
            catch (IllegalArgumentException e) {
                this.sendError(ctx, "Bad job parameter", HttpResponseStatus.BAD_REQUEST);
                return;
            }
            String reqUri = request.getUri();
            if (null == reqUri) {
                this.sendError(ctx, HttpResponseStatus.FORBIDDEN);
                return;
            }
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            try {
                this.verifyRequest(jobId, ctx, request, (HttpResponse)response, new URL("http", "", this.port, reqUri));
            }
            catch (IOException e) {
                LOG.warn("Shuffle failure ", (Throwable)e);
                this.sendError(ctx, e.getMessage(), HttpResponseStatus.UNAUTHORIZED);
                return;
            }
            HashMap<String, MapOutputInfo> mapOutputInfoMap = new HashMap<String, MapOutputInfo>();
            Channel ch = evt.getChannel();
            ChannelPipeline pipeline = ch.getPipeline();
            final TimeoutHandler timeoutHandler = (TimeoutHandler)pipeline.get(ShuffleHandler.TIMEOUT_HANDLER);
            timeoutHandler.setEnabledTimeout(false);
            String user = (String)ShuffleHandler.this.userRsrc.get(jobId);
            try {
                this.populateHeaders(mapIds, jobId, dagId, user, reduceId, (HttpResponse)response, keepAliveParam, mapOutputInfoMap);
            }
            catch (IOException e) {
                ch.write((Object)response);
                LOG.error("Shuffle error in populating headers :", (Throwable)e);
                String errorMessage = this.getErrorMessage(e);
                this.sendError(ctx, errorMessage, HttpResponseStatus.INTERNAL_SERVER_ERROR);
                return;
            }
            ch.write((Object)response);
            ChannelFuture lastMap = null;
            for (String mapId : mapIds) {
                try {
                    MapOutputInfo info = (MapOutputInfo)mapOutputInfoMap.get(mapId);
                    if (info == null) {
                        info = this.getMapOutputInfo(jobId, dagId, mapId, reduceId, user);
                    }
                    if (null != (lastMap = this.sendMapOutput(ctx, ch, user, mapId, reduceId, info))) continue;
                    this.sendError(ctx, HttpResponseStatus.NOT_FOUND);
                    return;
                }
                catch (IOException e) {
                    LOG.error("Shuffle error :", (Throwable)e);
                    String errorMessage = this.getErrorMessage(e);
                    this.sendError(ctx, errorMessage, HttpResponseStatus.INTERNAL_SERVER_ERROR);
                    return;
                }
            }
            if (!keepAliveParam && !ShuffleHandler.this.connectionKeepAliveEnabled) {
                lastMap.addListener(ChannelFutureListener.CLOSE);
            } else {
                lastMap.addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (!future.isSuccess()) {
                            future.getChannel().close();
                            return;
                        }
                        timeoutHandler.setEnabledTimeout(true);
                    }
                });
            }
        }

        private String getErrorMessage(Throwable t) {
            StringBuilder sb = new StringBuilder(t.getMessage());
            while (t.getCause() != null) {
                sb.append(t.getCause().getMessage());
                t = t.getCause();
            }
            return sb.toString();
        }

        protected MapOutputInfo getMapOutputInfo(String jobId, int dagId, String mapId, int reduce, String user) throws IOException {
            AttemptPathInfo pathInfo;
            try {
                AttemptPathIdentifier identifier = new AttemptPathIdentifier(jobId, dagId, user, mapId);
                pathInfo = (AttemptPathInfo)this.pathCache.get((Object)identifier);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Retrieved pathInfo for " + identifier + " check for corresponding loaded messages to determine whether it was loaded or cached");
                }
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
            TezIndexRecord info = this.indexCache.getIndexInformation(mapId, reduce, pathInfo.indexPath, user);
            if (LOG.isDebugEnabled()) {
                LOG.debug("jobId=" + jobId + ", mapId=" + mapId + ",dataFile=" + pathInfo.dataPath + ", indexFile=" + pathInfo.indexPath);
            }
            MapOutputInfo outputInfo = new MapOutputInfo(pathInfo.dataPath, info);
            return outputInfo;
        }

        protected void populateHeaders(List<String> mapIds, String jobId, int dagId, String user, int reduce, HttpResponse response, boolean keepAliveParam, Map<String, MapOutputInfo> mapOutputInfoMap) throws IOException {
            long contentLength = 0L;
            for (String mapId : mapIds) {
                MapOutputInfo outputInfo = this.getMapOutputInfo(jobId, dagId, mapId, reduce, user);
                if (mapOutputInfoMap.size() < ShuffleHandler.this.mapOutputMetaInfoCacheSize) {
                    mapOutputInfoMap.put(mapId, outputInfo);
                }
                ShuffleHeader header = new ShuffleHeader(mapId, outputInfo.indexRecord.getPartLength(), outputInfo.indexRecord.getRawLength(), reduce);
                DataOutputBuffer dob = new DataOutputBuffer();
                header.write((DataOutput)dob);
                contentLength += outputInfo.indexRecord.getPartLength();
                contentLength += (long)dob.getLength();
            }
            this.setResponseHeaders(response, keepAliveParam, contentLength);
        }

        protected void setResponseHeaders(HttpResponse response, boolean keepAliveParam, long contentLength) {
            if (!ShuffleHandler.this.connectionKeepAliveEnabled && !keepAliveParam) {
                LOG.info("Setting connection close header...");
                response.headers().add("Connection", (Object)ShuffleHandler.CONNECTION_CLOSE);
            } else {
                response.headers().add("Content-Length", (Object)String.valueOf(contentLength));
                response.headers().add("Connection", (Object)"keep-alive");
                response.headers().add("keep-alive", (Object)("timeout=" + ShuffleHandler.this.connectionKeepAliveTimeOut));
                LOG.debug("Content Length in shuffle : " + contentLength);
            }
        }

        protected void verifyRequest(String appid, ChannelHandlerContext ctx, HttpRequest request, HttpResponse response, URL requestUri) throws IOException {
            SecretKey tokenSecret = ShuffleHandler.this.secretManager.retrieveTokenSecret(appid);
            if (null == tokenSecret) {
                LOG.info("Request for unknown token " + appid);
                throw new IOException("could not find jobid");
            }
            String enc_str = SecureShuffleUtils.buildMsgFrom((URL)requestUri);
            String urlHashStr = request.headers().get("UrlHash");
            if (urlHashStr == null) {
                LOG.info("Missing header hash for " + appid);
                throw new IOException("fetcher cannot be authenticated");
            }
            if (LOG.isDebugEnabled()) {
                int len = urlHashStr.length();
                LOG.debug("verifying request. enc_str=" + enc_str + "; hash=..." + urlHashStr.substring(len - len / 2, len - 1));
            }
            SecureShuffleUtils.verifyReply((String)urlHashStr, (String)enc_str, (SecretKey)tokenSecret);
            String reply = SecureShuffleUtils.generateHash((byte[])urlHashStr.getBytes(Charsets.UTF_8), (SecretKey)tokenSecret);
            response.headers().add("ReplyHash", (Object)reply);
            response.headers().add("name", (Object)"mapreduce");
            response.headers().add("version", (Object)"1.0.0");
            if (LOG.isDebugEnabled()) {
                int len = reply.length();
                LOG.debug("Fetcher request verified. enc_str=" + enc_str + ";reply=" + reply.substring(len - len / 2, len - 1));
            }
        }

        protected ChannelFuture sendMapOutput(ChannelHandlerContext ctx, Channel ch, String user, String mapId, int reduce, MapOutputInfo mapOutputInfo) throws IOException {
            ChannelFuture writeFuture;
            RandomAccessFile spill;
            TezIndexRecord info = mapOutputInfo.indexRecord;
            ShuffleHeader header = new ShuffleHeader(mapId, info.getPartLength(), info.getRawLength(), reduce);
            DataOutputBuffer dob = new DataOutputBuffer();
            header.write((DataOutput)dob);
            ch.write((Object)ChannelBuffers.wrappedBuffer((byte[])dob.getData(), (int)0, (int)dob.getLength()));
            File spillfile = new File(mapOutputInfo.mapOutputFileName.toString());
            try {
                spill = SecureIOUtils.openForRandomRead((File)spillfile, (String)"r", (String)user, null);
            }
            catch (FileNotFoundException e) {
                LOG.info(spillfile + " not found");
                return null;
            }
            if (ch.getPipeline().get(SslHandler.class) == null) {
                boolean canEvictAfterTransfer = true;
                if (!ShuffleHandler.this.shouldAlwaysEvictOsCache) {
                    canEvictAfterTransfer = reduce > 0;
                }
                final FadvisedFileRegion partition = new FadvisedFileRegion(spill, info.getStartOffset(), info.getPartLength(), ShuffleHandler.this.manageOsCache, ShuffleHandler.this.readaheadLength, ShuffleHandler.this.readaheadPool, spillfile.getAbsolutePath(), ShuffleHandler.this.shuffleBufferSize, ShuffleHandler.this.shuffleTransferToAllowed, canEvictAfterTransfer);
                writeFuture = ch.write((Object)partition);
                writeFuture.addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) {
                        if (future.isSuccess()) {
                            partition.transferSuccessful();
                        }
                        partition.releaseExternalResources();
                    }
                });
            } else {
                FadvisedChunkedFile chunk = new FadvisedChunkedFile(spill, info.getStartOffset(), info.getPartLength(), ShuffleHandler.this.sslFileBufferSize, ShuffleHandler.this.manageOsCache, ShuffleHandler.this.readaheadLength, ShuffleHandler.this.readaheadPool, spillfile.getAbsolutePath());
                writeFuture = ch.write((Object)chunk);
            }
            return writeFuture;
        }

        protected void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
            this.sendError(ctx, "", status);
        }

        protected void sendError(ChannelHandlerContext ctx, String message, HttpResponseStatus status) {
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
            response.headers().add("Content-Type", (Object)"text/plain; charset=UTF-8");
            response.headers().add("name", (Object)"mapreduce");
            response.headers().add("version", (Object)"1.0.0");
            response.setContent(ChannelBuffers.copiedBuffer((CharSequence)message, (Charset)CharsetUtil.UTF_8));
            ctx.getChannel().write((Object)response).addListener(ChannelFutureListener.CLOSE);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            Channel ch = e.getChannel();
            Throwable cause = e.getCause();
            if (cause instanceof TooLongFrameException) {
                this.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
                return;
            }
            if (cause instanceof IOException) {
                if (cause instanceof ClosedChannelException) {
                    LOG.debug("Ignoring closed channel error", cause);
                    return;
                }
                String message = String.valueOf(cause.getMessage());
                if (IGNORABLE_ERROR_MESSAGE.matcher(message).matches()) {
                    LOG.debug("Ignoring client socket close", cause);
                    return;
                }
            }
            LOG.error("Shuffle error: ", cause);
            if (ch.isConnected()) {
                LOG.error("Shuffle error " + e);
                this.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
            }
        }

        class MapOutputInfo {
            final Path mapOutputFileName;
            final TezIndexRecord indexRecord;

            MapOutputInfo(Path mapOutputFileName, TezIndexRecord indexRecord) {
                this.mapOutputFileName = mapOutputFileName;
                this.indexRecord = indexRecord;
            }
        }
    }

    class HttpPipelineFactory
    implements ChannelPipelineFactory {
        final Shuffle SHUFFLE;
        private SSLFactory sslFactory;
        private final ChannelHandler idleStateHandler;

        public HttpPipelineFactory(Configuration conf, Timer timer) throws Exception {
            this.SHUFFLE = ShuffleHandler.this.getShuffle(conf);
            this.idleStateHandler = new IdleStateHandler(timer, 0, ShuffleHandler.this.connectionKeepAliveTimeOut, 0);
        }

        public void destroy() {
            if (this.sslFactory != null) {
                this.sslFactory.destroy();
            }
        }

        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = Channels.pipeline();
            if (this.sslFactory != null) {
                pipeline.addLast("ssl", (ChannelHandler)new SslHandler(this.sslFactory.createSSLEngine()));
            }
            pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
            pipeline.addLast("aggregator", (ChannelHandler)new HttpChunkAggregator(65536));
            pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
            pipeline.addLast("chunking", (ChannelHandler)new ChunkedWriteHandler());
            pipeline.addLast("shuffle", (ChannelHandler)this.SHUFFLE);
            pipeline.addLast("idle", this.idleStateHandler);
            pipeline.addLast(ShuffleHandler.TIMEOUT_HANDLER, (ChannelHandler)new TimeoutHandler());
            return pipeline;
        }
    }

    private static class TimeoutHandler
    extends IdleStateAwareChannelHandler {
        private boolean enabledTimeout;

        private TimeoutHandler() {
        }

        void setEnabledTimeout(boolean enabledTimeout) {
            this.enabledTimeout = enabledTimeout;
        }

        public void channelIdle(ChannelHandlerContext ctx, IdleStateEvent e) {
            if (e.getState() == IdleState.WRITER_IDLE && this.enabledTimeout) {
                e.getChannel().close();
            }
        }
    }

    @Metrics(about="Shuffle output metrics", context="mapred")
    static class ShuffleMetrics
    implements ChannelFutureListener {
        @Metric(value={"Shuffle output in bytes"})
        MutableCounterLong shuffleOutputBytes;
        @Metric(value={"# of failed shuffle outputs"})
        MutableCounterInt shuffleOutputsFailed;
        @Metric(value={"# of succeeded shuffle outputs"})
        MutableCounterInt shuffleOutputsOK;
        @Metric(value={"# of current shuffle connections"})
        MutableGaugeInt shuffleConnections;

        ShuffleMetrics() {
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (future.isSuccess()) {
                this.shuffleOutputsOK.incr();
            } else {
                this.shuffleOutputsFailed.incr();
            }
            this.shuffleConnections.decr();
        }
    }
}

