/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.avro;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.rmi.server.UID;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.UnresolvedUnionException;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.serde2.avro.AvroGenericRecordWritable;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeException;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeUtils;
import org.apache.hadoop.hive.serde2.avro.SchemaToTypeInfo;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.objectinspector.StandardUnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaHiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AvroDeserializer {
    private static final Logger LOG = LoggerFactory.getLogger(AvroDeserializer.class);
    private final HashSet<UID> noEncodingNeeded = new HashSet();
    private final HashMap<UID, SchemaReEncoder> reEncoderCache = new HashMap();
    private static boolean warnedOnce = false;
    private List<Object> row;

    AvroDeserializer() {
    }

    public Object deserialize(List<String> columnNames, List<TypeInfo> columnTypes, Writable writable, Schema readerSchema) throws AvroSerdeException {
        if (!(writable instanceof AvroGenericRecordWritable)) {
            throw new AvroSerdeException("Expecting a AvroGenericRecordWritable");
        }
        if (this.row == null || this.row.size() != columnNames.size()) {
            this.row = new ArrayList<Object>(columnNames.size());
        } else {
            this.row.clear();
        }
        AvroGenericRecordWritable recordWritable = (AvroGenericRecordWritable)writable;
        GenericRecord r = recordWritable.getRecord();
        Schema fileSchema = recordWritable.getFileSchema();
        UID recordReaderId = recordWritable.getRecordReaderID();
        if (!this.noEncodingNeeded.contains(recordReaderId)) {
            SchemaReEncoder reEncoder = null;
            if (this.reEncoderCache.containsKey(recordReaderId)) {
                reEncoder = this.reEncoderCache.get(recordReaderId);
            } else if (!r.getSchema().equals((Object)readerSchema)) {
                reEncoder = new SchemaReEncoder(r.getSchema(), readerSchema);
                this.reEncoderCache.put(recordReaderId, reEncoder);
            } else {
                LOG.debug("Adding new valid RRID :" + recordReaderId);
                this.noEncodingNeeded.add(recordReaderId);
            }
            if (reEncoder != null) {
                if (!warnedOnce) {
                    LOG.warn("Received different schemas.  Have to re-encode: " + r.getSchema().toString(false) + "\nSIZE" + this.reEncoderCache + " ID " + recordReaderId);
                    warnedOnce = true;
                }
                r = reEncoder.reencode(r);
            }
        }
        this.workerBase(this.row, fileSchema, columnNames, columnTypes, r);
        return this.row;
    }

    private List<Object> workerBase(List<Object> objectRow, Schema fileSchema, List<String> columnNames, List<TypeInfo> columnTypes, GenericRecord record) throws AvroSerdeException {
        for (int i = 0; i < columnNames.size(); ++i) {
            TypeInfo columnType = columnTypes.get(i);
            String columnName = columnNames.get(i);
            Object datum = record.get(columnName);
            Schema datumSchema = record.getSchema().getField(columnName).schema();
            Schema.Field field = AvroSerdeUtils.isNullableType(fileSchema) ? AvroSerdeUtils.getOtherTypeFromNullableType(fileSchema).getField(columnName) : fileSchema.getField(columnName);
            objectRow.add(this.worker(datum, field == null ? null : field.schema(), datumSchema, columnType));
        }
        return objectRow;
    }

    private Object worker(Object datum, Schema fileSchema, Schema recordSchema, TypeInfo columnType) throws AvroSerdeException {
        if (AvroSerdeUtils.isNullableType(recordSchema)) {
            return this.deserializeNullableUnion(datum, fileSchema, recordSchema);
        }
        switch (columnType.getCategory()) {
            case STRUCT: {
                return this.deserializeStruct((GenericData.Record)datum, fileSchema, (StructTypeInfo)columnType);
            }
            case UNION: {
                return this.deserializeUnion(datum, fileSchema, recordSchema, (UnionTypeInfo)columnType);
            }
            case LIST: {
                return this.deserializeList(datum, fileSchema, recordSchema, (ListTypeInfo)columnType);
            }
            case MAP: {
                return this.deserializeMap(datum, fileSchema, recordSchema, (MapTypeInfo)columnType);
            }
            case PRIMITIVE: {
                return this.deserializePrimitive(datum, fileSchema, recordSchema, (PrimitiveTypeInfo)columnType);
            }
        }
        throw new AvroSerdeException("Unknown TypeInfo: " + (Object)((Object)columnType.getCategory()));
    }

    private Object deserializePrimitive(Object datum, Schema fileSchema, Schema recordSchema, PrimitiveTypeInfo columnType) throws AvroSerdeException {
        switch (columnType.getPrimitiveCategory()) {
            case STRING: {
                return datum.toString();
            }
            case BINARY: {
                if (recordSchema.getType() == Schema.Type.FIXED) {
                    GenericData.Fixed fixed = (GenericData.Fixed)datum;
                    return fixed.bytes();
                }
                if (recordSchema.getType() == Schema.Type.BYTES) {
                    return AvroSerdeUtils.getBytesFromByteBuffer((ByteBuffer)datum);
                }
                throw new AvroSerdeException("Unexpected Avro schema for Binary TypeInfo: " + recordSchema.getType());
            }
            case DECIMAL: {
                if (fileSchema == null) {
                    throw new AvroSerdeException("File schema is missing for decimal field. Reader schema is " + columnType);
                }
                int scale = 0;
                try {
                    scale = fileSchema.getJsonProp("scale").asInt();
                }
                catch (Exception ex) {
                    throw new AvroSerdeException("Failed to obtain scale value from file schema: " + fileSchema, ex);
                }
                HiveDecimal dec = AvroSerdeUtils.getHiveDecimalFromByteBuffer((ByteBuffer)datum, scale);
                JavaHiveDecimalObjectInspector oi = (JavaHiveDecimalObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((DecimalTypeInfo)columnType);
                return oi.set(null, dec);
            }
            case CHAR: {
                if (fileSchema == null) {
                    throw new AvroSerdeException("File schema is missing for char field. Reader schema is " + columnType);
                }
                int maxLength = 0;
                try {
                    maxLength = fileSchema.getJsonProp("maxLength").getValueAsInt();
                }
                catch (Exception ex) {
                    throw new AvroSerdeException("Failed to obtain maxLength value for char field from file schema: " + fileSchema, ex);
                }
                String str = datum.toString();
                HiveChar hc = new HiveChar(str, maxLength);
                return hc;
            }
            case VARCHAR: {
                if (fileSchema == null) {
                    throw new AvroSerdeException("File schema is missing for varchar field. Reader schema is " + columnType);
                }
                int maxLength = 0;
                try {
                    maxLength = fileSchema.getJsonProp("maxLength").getValueAsInt();
                }
                catch (Exception ex) {
                    throw new AvroSerdeException("Failed to obtain maxLength value for varchar field from file schema: " + fileSchema, ex);
                }
                String str = datum.toString();
                HiveVarchar hvc = new HiveVarchar(str, maxLength);
                return hvc;
            }
            case DATE: {
                if (recordSchema.getType() != Schema.Type.INT) {
                    throw new AvroSerdeException("Unexpected Avro schema for Date TypeInfo: " + recordSchema.getType());
                }
                return new Date(DateWritable.daysToMillis((int)((Integer)datum)));
            }
            case TIMESTAMP: {
                if (recordSchema.getType() != Schema.Type.LONG) {
                    throw new AvroSerdeException("Unexpected Avro schema for Date TypeInfo: " + recordSchema.getType());
                }
                return new Timestamp((Long)datum);
            }
        }
        return datum;
    }

    private Object deserializeNullableUnion(Object datum, Schema fileSchema, Schema recordSchema) throws AvroSerdeException {
        int tag = GenericData.get().resolveUnion(recordSchema, datum);
        Schema schema = (Schema)recordSchema.getTypes().get(tag);
        if (schema.getType().equals((Object)Schema.Type.NULL)) {
            return null;
        }
        Schema currentFileSchema = null;
        if (fileSchema != null) {
            if (fileSchema.getType() == Schema.Type.UNION) {
                try {
                    tag = GenericData.get().resolveUnion(fileSchema, datum);
                    currentFileSchema = (Schema)fileSchema.getTypes().get(tag);
                }
                catch (UnresolvedUnionException e) {
                    if (LOG.isDebugEnabled()) {
                        String datumClazz = null;
                        if (datum != null) {
                            datumClazz = datum.getClass().getName();
                        }
                        String msg = "File schema union could not resolve union. fileSchema = " + fileSchema + ", recordSchema = " + recordSchema + ", datum class = " + datumClazz + ": " + (Object)((Object)e);
                        LOG.debug(msg, (Throwable)e);
                    }
                    currentFileSchema = schema;
                }
            } else {
                currentFileSchema = fileSchema;
            }
        }
        return this.worker(datum, currentFileSchema, schema, SchemaToTypeInfo.generateTypeInfo(schema, null));
    }

    private Object deserializeStruct(GenericData.Record datum, Schema fileSchema, StructTypeInfo columnType) throws AvroSerdeException {
        ArrayList<TypeInfo> innerFieldTypes = columnType.getAllStructFieldTypeInfos();
        ArrayList<String> innerFieldNames = columnType.getAllStructFieldNames();
        ArrayList<Object> innerObjectRow = new ArrayList<Object>(innerFieldTypes.size());
        return this.workerBase(innerObjectRow, fileSchema, innerFieldNames, innerFieldTypes, (GenericRecord)datum);
    }

    private Object deserializeUnion(Object datum, Schema fileSchema, Schema recordSchema, UnionTypeInfo columnType) throws AvroSerdeException {
        int fsTag = GenericData.get().resolveUnion(fileSchema, datum);
        int rsTag = GenericData.get().resolveUnion(recordSchema, datum);
        Object desered = this.worker(datum, fileSchema == null ? null : (Schema)fileSchema.getTypes().get(fsTag), (Schema)recordSchema.getTypes().get(rsTag), columnType.getAllUnionObjectTypeInfos().get(rsTag));
        return new StandardUnionObjectInspector.StandardUnion((byte)rsTag, desered);
    }

    private Object deserializeList(Object datum, Schema fileSchema, Schema recordSchema, ListTypeInfo columnType) throws AvroSerdeException {
        if (recordSchema.getType().equals((Object)Schema.Type.FIXED)) {
            GenericData.Fixed fixed = (GenericData.Fixed)datum;
            ArrayList<Byte> asList = new ArrayList<Byte>(fixed.bytes().length);
            for (int j = 0; j < fixed.bytes().length; ++j) {
                asList.add(fixed.bytes()[j]);
            }
            return asList;
        }
        if (recordSchema.getType().equals((Object)Schema.Type.BYTES)) {
            ByteBuffer bb = (ByteBuffer)datum;
            ArrayList<Byte> asList = new ArrayList<Byte>(bb.capacity());
            byte[] array = bb.array();
            for (int j = 0; j < array.length; ++j) {
                asList.add(array[j]);
            }
            return asList;
        }
        List listData = (List)datum;
        Schema listSchema = recordSchema.getElementType();
        ArrayList<Object> listContents = new ArrayList<Object>(listData.size());
        for (Object obj : listData) {
            listContents.add(this.worker(obj, fileSchema == null ? null : fileSchema.getElementType(), listSchema, columnType.getListElementTypeInfo()));
        }
        return listContents;
    }

    private Object deserializeMap(Object datum, Schema fileSchema, Schema mapSchema, MapTypeInfo columnType) throws AvroSerdeException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map mapDatum = (Map)datum;
        Schema valueSchema = mapSchema.getValueType();
        TypeInfo valueTypeInfo = columnType.getMapValueTypeInfo();
        for (CharSequence key : mapDatum.keySet()) {
            Object value = mapDatum.get(key);
            map.put(key.toString(), this.worker(value, fileSchema == null ? null : fileSchema.getValueType(), valueSchema, valueTypeInfo));
        }
        return map;
    }

    public HashSet<UID> getNoEncodingNeeded() {
        return this.noEncodingNeeded;
    }

    public HashMap<UID, SchemaReEncoder> getReEncoderCache() {
        return this.reEncoderCache;
    }

    static class SchemaReEncoder {
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        private final GenericDatumWriter<GenericRecord> gdw = new GenericDatumWriter();
        private BinaryDecoder binaryDecoder = null;
        GenericDatumReader<GenericRecord> gdr = null;

        public SchemaReEncoder(Schema writer, Schema reader) {
            this.gdr = new GenericDatumReader(writer, reader);
        }

        public GenericRecord reencode(GenericRecord r) throws AvroSerdeException {
            this.baos.reset();
            BinaryEncoder be = EncoderFactory.get().directBinaryEncoder((OutputStream)this.baos, null);
            this.gdw.setSchema(r.getSchema());
            try {
                this.gdw.write((Object)r, (Encoder)be);
                ByteArrayInputStream bais = new ByteArrayInputStream(this.baos.toByteArray());
                this.binaryDecoder = DecoderFactory.defaultFactory().createBinaryDecoder((InputStream)bais, this.binaryDecoder);
                return (GenericRecord)this.gdr.read((Object)r, (Decoder)this.binaryDecoder);
            }
            catch (IOException e) {
                throw new AvroSerdeException("Exception trying to re-encode record to new schema", e);
            }
        }
    }
}

