/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.extractor.BoundaryExtractor;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.ResultRenderer;
import org.apache.jmeter.visualizers.ViewResultsFullVisualizer;
import org.apache.jorphan.gui.GuiUtils;
import org.apache.jorphan.gui.JLabeledTextField;

public class RenderAsBoundaryExtractor
implements ResultRenderer,
ActionListener {
    private static final String BOUNDARY_EXTRACTOR_TESTER_COMMAND = "boundary_extractor_tester";
    private JPanel boundaryExtractorPane;
    private JTextArea boundaryExtractorDataField;
    private JLabeledTextField boundaryExtractorFieldLeft;
    private JLabeledTextField boundaryExtractorFieldRight;
    private JTextArea boundaryExtractorResultField;
    private JTabbedPane rightSide;

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        String boundaryExtractorDataFieldText = this.boundaryExtractorDataField.getText();
        if (StringUtils.isNotEmpty((CharSequence)boundaryExtractorDataFieldText) && BOUNDARY_EXTRACTOR_TESTER_COMMAND.equals(command)) {
            this.executeAndShowBoundaryExtractorTester(boundaryExtractorDataFieldText);
        }
    }

    private void executeAndShowBoundaryExtractorTester(String textToParse) {
        if (textToParse != null && textToParse.length() > 0 && this.boundaryExtractorFieldLeft.getText().length() > 0 && this.boundaryExtractorFieldRight.getText().length() > 0) {
            this.boundaryExtractorResultField.setText(this.process(textToParse));
            this.boundaryExtractorResultField.setCaretPosition(0);
        }
    }

    private String process(String textToParse) {
        BoundaryExtractor extractor = new BoundaryExtractor();
        List<String> matches = extractor.extractAll(this.boundaryExtractorFieldLeft.getText(), this.boundaryExtractorFieldRight.getText(), textToParse);
        int nbFound = matches.size();
        StringBuilder sb = new StringBuilder();
        sb.append("Match count: ").append(nbFound).append("\n");
        for (int j = 0; j < nbFound; ++j) {
            String match = matches.get(j);
            sb.append("Match[").append(j + 1).append("]=").append(match).append("\n");
        }
        return sb.toString();
    }

    @Override
    public void clearData() {
        this.boundaryExtractorDataField.setText("");
        this.boundaryExtractorFieldLeft.setText("");
        this.boundaryExtractorFieldRight.setText("");
        this.boundaryExtractorResultField.setText("");
    }

    @Override
    public void init() {
        this.boundaryExtractorPane = this.createBoundaryExtractorPanel();
    }

    private JPanel createBoundaryExtractorPanel() {
        this.boundaryExtractorDataField = new JTextArea();
        this.boundaryExtractorDataField.setEditable(true);
        this.boundaryExtractorDataField.setLineWrap(true);
        this.boundaryExtractorDataField.setWrapStyleWord(true);
        JScrollPane boundaryExtractorDataPane = GuiUtils.makeScrollPane((Component)this.boundaryExtractorDataField);
        boundaryExtractorDataPane.setPreferredSize(new Dimension(0, 200));
        JPanel pane = new JPanel(new BorderLayout(0, 5));
        JSplitPane mainSplit = new JSplitPane(0, boundaryExtractorDataPane, this.createBoundaryExtractorTasksPanel());
        mainSplit.setDividerLocation(0.6);
        mainSplit.setOneTouchExpandable(true);
        pane.add((Component)mainSplit, "Center");
        return pane;
    }

    private JPanel createBoundaryExtractorTasksPanel() {
        JPanel boundaryExtractorActionPanel = new JPanel();
        boundaryExtractorActionPanel.setLayout(new BoxLayout(boundaryExtractorActionPanel, 0));
        EmptyBorder margin = new EmptyBorder(5, 5, 0, 5);
        boundaryExtractorActionPanel.setBorder(margin);
        this.boundaryExtractorFieldLeft = new JLabeledTextField(JMeterUtils.getResString((String)"boundaryextractor_leftboundary_field"));
        boundaryExtractorActionPanel.add((Component)this.boundaryExtractorFieldLeft, "West");
        this.boundaryExtractorFieldRight = new JLabeledTextField(JMeterUtils.getResString((String)"boundaryextractor_rightboundary_field"));
        boundaryExtractorActionPanel.add((Component)this.boundaryExtractorFieldRight, "West");
        JButton boundaryExtractorTester = new JButton(JMeterUtils.getResString((String)"boundaryextractor_tester_button_test"));
        boundaryExtractorTester.setActionCommand(BOUNDARY_EXTRACTOR_TESTER_COMMAND);
        boundaryExtractorTester.addActionListener(this);
        boundaryExtractorActionPanel.add((Component)boundaryExtractorTester, "East");
        this.boundaryExtractorResultField = new JTextArea();
        this.boundaryExtractorResultField.setEditable(false);
        this.boundaryExtractorResultField.setLineWrap(true);
        this.boundaryExtractorResultField.setWrapStyleWord(true);
        JPanel boundaryExtractorTasksPanel = new JPanel(new BorderLayout(0, 5));
        boundaryExtractorTasksPanel.add((Component)boundaryExtractorActionPanel, "North");
        boundaryExtractorTasksPanel.add((Component)GuiUtils.makeScrollPane((Component)this.boundaryExtractorResultField), "Center");
        return boundaryExtractorTasksPanel;
    }

    @Override
    public void setupTabPane() {
        if (this.rightSide.indexOfTab(JMeterUtils.getResString((String)"boundaryextractor_tester_title")) < 0) {
            this.rightSide.addTab(JMeterUtils.getResString((String)"boundaryextractor_tester_title"), this.boundaryExtractorPane);
        }
        this.clearData();
    }

    @Override
    public void setLastSelectedTab(int index) {
    }

    @Override
    public synchronized void setRightSide(JTabbedPane side) {
        this.rightSide = side;
    }

    @Override
    public void setSamplerResult(Object userObject) {
    }

    @Override
    public void renderResult(SampleResult sampleResult) {
        this.clearData();
        String response = ViewResultsFullVisualizer.getResponseAsString(sampleResult);
        this.boundaryExtractorDataField.setText(response);
        this.boundaryExtractorDataField.setCaretPosition(0);
    }

    @Override
    public String toString() {
        return JMeterUtils.getResString((String)"boundaryextractor_tester_title");
    }

    @Override
    public void renderImage(SampleResult sampleResult) {
        this.clearData();
        this.boundaryExtractorDataField.setText(JMeterUtils.getResString((String)"boundaryextractor_render_no_text"));
    }

    @Override
    public void setBackgroundColor(Color backGround) {
    }
}

