/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.time.Instant;
import java.time.Year;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeShift
extends AbstractFunction {
    private static final Logger log = LoggerFactory.getLogger(TimeShift.class);
    private static final String KEY = "__timeShift";
    private static final List<String> desc = Arrays.asList(JMeterUtils.getResString((String)"time_format_shift"), JMeterUtils.getResString((String)"date_to_shift"), JMeterUtils.getResString((String)"value_to_shift"), JMeterUtils.getResString((String)"locale_format"), JMeterUtils.getResString((String)"function_name_paropt"));
    private String format = "";
    private CompoundVariable dateToShiftCompound;
    private CompoundVariable amountToShiftCompound;
    private Locale locale = JMeterUtils.getLocale();
    private String variableName = "";
    private ZoneId systemDefaultZoneID = ZoneId.systemDefault();
    private Cache<LocaleFormatObject, DateTimeFormatter> dateTimeFormatterCache = null;

    public String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        JMeterVariables vars;
        String amountToShift = this.amountToShiftCompound.execute().trim();
        String dateToShift = this.dateToShiftCompound.execute().trim();
        ZonedDateTime zonedDateTimeToShift = ZonedDateTime.now(this.systemDefaultZoneID);
        DateTimeFormatter formatter = null;
        if (!StringUtils.isEmpty((CharSequence)this.format)) {
            try {
                LocaleFormatObject lfo = new LocaleFormatObject(this.format, this.locale);
                formatter = (DateTimeFormatter)this.dateTimeFormatterCache.get((Object)lfo, this::createFormatter);
            }
            catch (IllegalArgumentException ex) {
                log.error("Format date pattern '{}' is invalid (see https://docs.oracle.com/javase/8/docs/api/java/time/format/DateTimeFormatter.html)", (Object)this.format, (Object)ex);
                return "";
            }
        }
        if (!dateToShift.isEmpty()) {
            try {
                zonedDateTimeToShift = formatter != null ? ZonedDateTime.parse(dateToShift, formatter) : ZonedDateTime.ofInstant(Instant.ofEpochMilli(Long.parseLong(dateToShift)), this.systemDefaultZoneID);
            }
            catch (NumberFormatException | DateTimeParseException ex) {
                log.error("Failed to parse the date '{}' to shift with formatter '{}'", new Object[]{dateToShift, formatter, ex});
            }
        }
        if (!StringUtils.isEmpty((CharSequence)amountToShift)) {
            try {
                Duration duration = Duration.parse(amountToShift);
                zonedDateTimeToShift = zonedDateTimeToShift.plus(duration);
            }
            catch (DateTimeParseException ex) {
                log.error("Failed to parse the amount duration '{}' to shift (see https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html#parse-java.lang.CharSequence-) ", (Object)amountToShift, (Object)ex);
            }
        }
        String dateString = formatter != null ? zonedDateTimeToShift.format(formatter) : String.valueOf(zonedDateTimeToShift.toInstant().toEpochMilli());
        if (!StringUtils.isEmpty((CharSequence)this.variableName) && (vars = this.getVariables()) != null) {
            vars.put(this.variableName, dateString);
        }
        return dateString;
    }

    private DateTimeFormatter createFormatter(LocaleFormatObject format) {
        log.debug("Create a new instance of DateTimeFormatter for format '{}' in the cache", (Object)format);
        return new DateTimeFormatterBuilder().appendPattern(format.getFormat()).parseDefaulting(ChronoField.NANO_OF_SECOND, 0L).parseDefaulting(ChronoField.MILLI_OF_SECOND, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.DAY_OF_MONTH, 1L).parseDefaulting(ChronoField.MONTH_OF_YEAR, 1L).parseDefaulting(ChronoField.YEAR_OF_ERA, Year.now().getValue()).parseDefaulting(ChronoField.OFFSET_SECONDS, ZonedDateTime.now().getOffset().getTotalSeconds()).toFormatter(format.getLocale());
    }

    public void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 4, 5);
        Object[] values = parameters.toArray();
        this.format = ((CompoundVariable)values[0]).execute().trim();
        this.dateToShiftCompound = (CompoundVariable)values[1];
        this.amountToShiftCompound = (CompoundVariable)values[2];
        if (values.length == 4) {
            this.variableName = ((CompoundVariable)values[3]).execute().trim();
        } else {
            String localeAsString = ((CompoundVariable)values[3]).execute().trim();
            if (!localeAsString.trim().isEmpty()) {
                this.locale = LocaleUtils.toLocale((String)localeAsString);
            }
            this.variableName = ((CompoundVariable)values[4]).execute().trim();
        }
        if (this.dateTimeFormatterCache == null) {
            this.dateTimeFormatterCache = Caffeine.newBuilder().maximumSize(100L).build();
        }
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    private static final class LocaleFormatObject {
        private String format;
        private Locale locale;

        public LocaleFormatObject(String format, Locale locale) {
            this.format = format;
            this.locale = locale;
        }

        public String getFormat() {
            return this.format;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public int hashCode() {
            return this.format.hashCode() + this.locale.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof LocaleFormatObject)) {
                return false;
            }
            LocaleFormatObject otherError = (LocaleFormatObject)other;
            return this.format.equals(otherError.getFormat()) && this.locale.getDisplayName().equals(otherError.getLocale().getDisplayName());
        }

        public String toString() {
            return "LocaleFormatObject [format=" + this.format + ", locale=" + this.locale + "]";
        }
    }
}

