/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.nio.ByteBuffer;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.InvalidRecordException;
import org.junit.Assert;
import org.junit.Test;

public class EndTransactionMarkerTest {
    @Test(expected=IllegalArgumentException.class)
    public void testUnknownControlTypeNotAllowed() {
        new EndTransactionMarker(ControlRecordType.UNKNOWN, 24);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCannotDeserializeUnknownControlType() {
        EndTransactionMarker.deserializeValue((ControlRecordType)ControlRecordType.UNKNOWN, (ByteBuffer)ByteBuffer.wrap(new byte[0]));
    }

    @Test(expected=InvalidRecordException.class)
    public void testIllegalNegativeVersion() {
        ByteBuffer buffer = ByteBuffer.allocate(2);
        buffer.putShort((short)-1);
        buffer.flip();
        EndTransactionMarker.deserializeValue((ControlRecordType)ControlRecordType.ABORT, (ByteBuffer)buffer);
    }

    @Test(expected=InvalidRecordException.class)
    public void testNotEnoughBytes() {
        EndTransactionMarker.deserializeValue((ControlRecordType)ControlRecordType.COMMIT, (ByteBuffer)ByteBuffer.wrap(new byte[0]));
    }

    @Test
    public void testSerde() {
        int coordinatorEpoch = 79;
        EndTransactionMarker marker = new EndTransactionMarker(ControlRecordType.COMMIT, coordinatorEpoch);
        ByteBuffer buffer = marker.serializeValue();
        EndTransactionMarker deserialized = EndTransactionMarker.deserializeValue((ControlRecordType)ControlRecordType.COMMIT, (ByteBuffer)buffer);
        Assert.assertEquals((long)coordinatorEpoch, (long)deserialized.coordinatorEpoch());
    }

    @Test
    public void testDeserializeNewerVersion() {
        int coordinatorEpoch = 79;
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putShort((short)5);
        buffer.putInt(coordinatorEpoch);
        buffer.putShort((short)0);
        buffer.flip();
        EndTransactionMarker deserialized = EndTransactionMarker.deserializeValue((ControlRecordType)ControlRecordType.COMMIT, (ByteBuffer)buffer);
        Assert.assertEquals((long)coordinatorEpoch, (long)deserialized.coordinatorEpoch());
    }
}

